/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.block;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.handler.ConfigurationHandler;
import codechicken.enderstorage.tile.TileEnderChest;
import codechicken.enderstorage.tile.TileEnderTank;
import codechicken.enderstorage.tile.TileFrequencyOwner;
import codechicken.lib.colour.EnumColour;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.util.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockEnderStorage
extends Block
implements ITileEntityProvider {
    public static final PropertyEnum<Type> VARIANTS = PropertyEnum.func_177709_a((String)"type", Type.class);

    public BlockEnderStorage() {
        super(Material.field_151576_e);
        this.func_149711_c(20.0f);
        this.func_149752_b(100.0f);
        this.func_149647_a(CreativeTabs.field_78029_e);
        this.func_149663_c("ender_storage");
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        switch (meta) {
            case 0: {
                return new TileEnderChest();
            }
            case 1: {
                return new TileEnderTank();
            }
        }
        return null;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        worldIn.func_175713_t(pos);
    }

    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileFrequencyOwner tile = (TileFrequencyOwner)world.func_175625_s(pos);
        if (tile != null) {
            ret.add(this.createItem(state.func_177230_c().func_176201_c(state), tile.frequency));
            if (ConfigurationHandler.anarchyMode && tile.frequency.hasOwner()) {
                ret.add(ConfigurationHandler.personalItem.func_77946_l());
            }
        }
        return ret;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult rayTraceResult, World world, BlockPos pos, EntityPlayer player) {
        TileFrequencyOwner tile = (TileFrequencyOwner)world.func_175625_s(pos);
        return this.createItem(this.func_176201_c(state), tile.frequency);
    }

    private ItemStack createItem(int meta, Frequency freq) {
        ItemStack stack = new ItemStack((Block)this, 1, meta);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (ConfigurationHandler.anarchyMode) {
            freq.setOwner(null);
        }
        freq.writeToStack(stack);
        return stack;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        EnumColour dye;
        ItemStack item;
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileFrequencyOwner)) {
            return false;
        }
        TileFrequencyOwner owner = (TileFrequencyOwner)tile;
        RayTraceResult hit = RayTracer.retraceBlock((World)world, (EntityPlayer)player, (BlockPos)pos);
        if (hit == null) {
            return false;
        }
        if (hit.subHit == 4) {
            ItemStack item2 = player.field_71071_by.func_70448_g();
            if (player.func_70093_af() && owner.frequency.hasOwner()) {
                if (!player.field_71075_bZ.field_75098_d && !player.field_71071_by.func_70441_a(ConfigurationHandler.personalItem.func_77946_l())) {
                    return false;
                }
                owner.setFreq(owner.frequency.copy().setOwner(null));
                return true;
            }
            if (!item2.func_190926_b() && ItemUtils.areStacksSameTypeCrafting((ItemStack)item2, (ItemStack)ConfigurationHandler.personalItem) && !owner.frequency.hasOwner()) {
                owner.setFreq(owner.frequency.copy().setOwner(player.getDisplayNameString()));
                if (!player.field_71075_bZ.field_75098_d) {
                    item2.func_190918_g(1);
                }
                return true;
            }
        } else if (hit.subHit >= 1 && hit.subHit <= 3 && !(item = player.field_71071_by.func_70448_g()).func_190926_b() && (dye = EnumColour.fromDyeStack((ItemStack)item)) != null) {
            EnumColour[] colours = new EnumColour[]{null, null, null};
            if (colours[hit.subHit - 1] == dye) {
                return false;
            }
            colours[hit.subHit - 1] = dye;
            owner.setFreq(owner.frequency.copy().set(colours));
            if (!player.field_71075_bZ.field_75098_d) {
                item.func_190918_g(1);
            }
            return true;
        }
        return !player.func_70093_af() && owner.activate(player, hit.subHit, hand);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileFrequencyOwner) {
            ((TileFrequencyOwner)tile).onPlaced(placer);
        }
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d start, Vec3d end) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileFrequencyOwner) {
            return RayTracer.rayTraceCuboidsClosest((Vec3d)start, (Vec3d)end, (BlockPos)pos, (List)((TileFrequencyOwner)tile).getIndexedCuboids());
        }
        return super.func_180636_a(state, world, pos, start, end);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileFrequencyOwner owner;
        TileEntity tile = source.func_175625_s(pos);
        if (tile != null && tile instanceof TileFrequencyOwner && !(owner = (TileFrequencyOwner)tile).getIndexedCuboids().isEmpty()) {
            return ((IndexedCuboid6)owner.getIndexedCuboids().get(0)).aabb();
        }
        return super.func_185496_a(state, source, pos);
    }

    public void func_149666_a(CreativeTabs creativeTab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 0));
        list.add((Object)new ItemStack((Block)this, 1, 1));
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileFrequencyOwner) {
            return ((TileFrequencyOwner)tile).getLightValue();
        }
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANTS});
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANTS))).getMetadata();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANTS, (Comparable)((Object)Type.byMetadata(meta)));
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        return tile != null && tile instanceof TileFrequencyOwner && ((TileFrequencyOwner)tile).redstoneInteraction();
    }

    public boolean func_149740_M(IBlockState state) {
        return this.func_176201_c(state) == 0;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileFrequencyOwner ? ((TileFrequencyOwner)tile).comparatorInput() : 0;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileFrequencyOwner && ((TileFrequencyOwner)tile).rotate();
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int eventID, int eventParam) {
        super.func_189539_a(state, worldIn, pos, eventID, eventParam);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(eventID, eventParam);
    }

    public static enum Type implements IStringSerializable
    {
        CHEST(0, "ender_chest"),
        TANK(1, "ender_tank");

        public static final Type[] VALUES;
        private final int metadata;
        private final String name;

        private Type(int meta, String name) {
            this.metadata = meta;
            this.name = name;
        }

        public int getMetadata() {
            return this.metadata;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static Type byMetadata(int metadata) {
            if (metadata < 0 || metadata >= VALUES.length) {
                metadata = 0;
            }
            return VALUES[metadata];
        }

        static {
            VALUES = new Type[Type.values().length];
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type type;
                Type.VALUES[type.getMetadata()] = type = typeArray[i];
            }
        }
    }
}

