/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.block;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.config.EnderStorageConfig;
import codechicken.enderstorage.tile.TileFrequencyOwner;
import codechicken.lib.colour.EnumColour;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.util.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;

public abstract class BlockEnderStorage
extends Block {
    public BlockEnderStorage(Block.Properties properties) {
        super(properties);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, IFluidState fluid) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        TileFrequencyOwner tile = (TileFrequencyOwner)((Object)builder.func_216019_b(LootParameters.field_216288_h));
        if (tile != null) {
            drops.add(this.createItem(tile.getFrequency()));
            if (EnderStorageConfig.anarchyMode && tile.getFrequency().hasOwner()) {
                drops.add(EnderStorageConfig.personalItem.func_77946_l());
            }
        }
        return drops;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult rayTraceResult, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileFrequencyOwner tile = (TileFrequencyOwner)world.func_175625_s(pos);
        return this.createItem(tile.getFrequency());
    }

    private ItemStack createItem(Frequency freq) {
        ItemStack stack = new ItemStack((IItemProvider)this, 1);
        if (EnderStorageConfig.anarchyMode) {
            freq.setOwner(null);
        }
        freq.writeToStack(stack);
        return stack;
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult clientHit) {
        EnumColour dye;
        ItemStack item;
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileFrequencyOwner)) {
            return false;
        }
        TileFrequencyOwner owner = (TileFrequencyOwner)tile;
        BlockRayTraceResult hit = RayTracer.retrace((PlayerEntity)player);
        if (hit == null) {
            return false;
        }
        if (hit.subHit == 4) {
            ItemStack item2 = player.field_71071_by.func_70448_g();
            if (player.func_70093_af() && owner.getFrequency().hasOwner()) {
                if (!player.field_71075_bZ.field_75098_d && !player.field_71071_by.func_70441_a(EnderStorageConfig.personalItem.func_77946_l())) {
                    return false;
                }
                owner.setFreq(owner.getFrequency().copy().setOwner(null));
                return true;
            }
            if (!item2.func_190926_b() && ItemUtils.areStacksSameOrTagged((ItemStack)item2, (ItemStack)EnderStorageConfig.personalItem) && !owner.getFrequency().hasOwner()) {
                owner.setFreq(owner.getFrequency().copy().setOwner(player.func_110124_au()).setOwnerName(player.func_200200_C_()));
                if (!player.field_71075_bZ.field_75098_d) {
                    item2.func_190918_g(1);
                }
                return true;
            }
        } else if (hit.subHit >= 1 && hit.subHit <= 3 && !(item = player.field_71071_by.func_70448_g()).func_190926_b() && (dye = EnumColour.fromDyeStack((ItemStack)item)) != null) {
            EnumColour[] colours = new EnumColour[]{null, null, null};
            if (colours[hit.subHit - 1] == dye) {
                return false;
            }
            colours[hit.subHit - 1] = dye;
            owner.setFreq(owner.getFrequency().copy().set(colours));
            if (!player.field_71075_bZ.field_75098_d) {
                item.func_190918_g(1);
            }
            return true;
        }
        return !player.func_70093_af() && owner.activate(player, hit.subHit, hand);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileFrequencyOwner) {
            ((TileFrequencyOwner)tile).onNeighborChange(fromPos);
        }
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileFrequencyOwner) {
            ((TileFrequencyOwner)tile).onPlaced(placer);
        }
    }

    public int getLightValue(BlockState state, IEnviromentBlockReader world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileFrequencyOwner) {
            return ((TileFrequencyOwner)tile).getLightValue();
        }
        return 0;
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileFrequencyOwner && ((TileFrequencyOwner)tile).redstoneInteraction();
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileFrequencyOwner ? ((TileFrequencyOwner)tile).comparatorInput() : 0;
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation direction) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileFrequencyOwner) {
            ((TileFrequencyOwner)tile).rotate();
        }
        return state;
    }

    public boolean func_189539_a(BlockState state, World worldIn, BlockPos pos, int eventID, int eventParam) {
        super.func_189539_a(state, worldIn, pos, eventID, eventParam);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(eventID, eventParam);
    }
}

