/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.client.render;

import codechicken.lib.texture.TextureUtils;
import com.mojang.blaze3d.platform.GlStateManager;
import java.nio.FloatBuffer;
import java.util.Random;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;

public class RenderCustomEndPortal {
    private static final ResourceLocation end_skyTex = new ResourceLocation("textures/environment/end_sky.png");
    private static final ResourceLocation end_portalTex = new ResourceLocation("textures/entity/end_portal.png");
    private double surfaceY;
    private double surfaceX1;
    private double surfaceX2;
    private double surfaceZ1;
    private double surfaceZ2;
    FloatBuffer texBuffer;

    public RenderCustomEndPortal(double y, double x1, double x2, double z1, double z2) {
        this.surfaceY = y;
        this.surfaceX1 = x1;
        this.surfaceX2 = x2;
        this.surfaceZ1 = z1;
        this.surfaceZ2 = z2;
        this.texBuffer = GLAllocation.func_74529_h((int)16);
    }

    public void render(double posX, double posY, double posZ, ActiveRenderInfo renderInfo) {
        if (renderInfo == null) {
            return;
        }
        Vec3d projectedView = renderInfo.func_216785_c();
        GlStateManager.disableLighting();
        Random random = new Random(31100L);
        for (int i = 0; i < 16; ++i) {
            GlStateManager.pushMatrix();
            float f5 = 16 - i;
            float f6 = 0.0625f;
            float f7 = 1.0f / (f5 + 1.0f);
            if (i == 0) {
                TextureUtils.changeTexture((ResourceLocation)end_skyTex);
                f7 = 0.1f;
                f5 = 65.0f;
                f6 = 0.125f;
                GlStateManager.enableBlend();
                GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            }
            if (i == 1) {
                TextureUtils.changeTexture((ResourceLocation)end_portalTex);
                GlStateManager.enableBlend();
                GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                f6 = 0.5f;
            }
            float f8 = (float)(-(posY + this.surfaceY));
            float f9 = (float)((double)f8 + projectedView.field_72448_b);
            float f10 = (float)((double)(f8 + f5) + projectedView.field_72448_b);
            float f11 = f9 / f10;
            f11 = (float)(posY + this.surfaceY) + f11;
            GlStateManager.translated((double)projectedView.field_72450_a, (double)f11, (double)projectedView.field_72449_c);
            GlStateManager.texGenMode((GlStateManager.TexGen)GlStateManager.TexGen.S, (int)9217);
            GlStateManager.texGenMode((GlStateManager.TexGen)GlStateManager.TexGen.T, (int)9217);
            GlStateManager.texGenMode((GlStateManager.TexGen)GlStateManager.TexGen.R, (int)9217);
            GlStateManager.texGenMode((GlStateManager.TexGen)GlStateManager.TexGen.Q, (int)9216);
            GlStateManager.texGenParam((GlStateManager.TexGen)GlStateManager.TexGen.S, (int)9473, (FloatBuffer)this.bufferTexData(1.0f, 0.0f, 0.0f, 0.0f));
            GlStateManager.texGenParam((GlStateManager.TexGen)GlStateManager.TexGen.T, (int)9473, (FloatBuffer)this.bufferTexData(0.0f, 0.0f, 1.0f, 0.0f));
            GlStateManager.texGenParam((GlStateManager.TexGen)GlStateManager.TexGen.R, (int)9473, (FloatBuffer)this.bufferTexData(0.0f, 0.0f, 0.0f, 1.0f));
            GlStateManager.texGenParam((GlStateManager.TexGen)GlStateManager.TexGen.Q, (int)9474, (FloatBuffer)this.bufferTexData(0.0f, 1.0f, 0.0f, 0.0f));
            GlStateManager.enableTexGen((GlStateManager.TexGen)GlStateManager.TexGen.S);
            GlStateManager.enableTexGen((GlStateManager.TexGen)GlStateManager.TexGen.T);
            GlStateManager.enableTexGen((GlStateManager.TexGen)GlStateManager.TexGen.R);
            GlStateManager.enableTexGen((GlStateManager.TexGen)GlStateManager.TexGen.Q);
            GlStateManager.popMatrix();
            GlStateManager.matrixMode((int)5890);
            GlStateManager.pushMatrix();
            GlStateManager.loadIdentity();
            GlStateManager.translatef((float)0.0f, (float)((float)(System.currentTimeMillis() % 700000L) / 700000.0f), (float)0.0f);
            GlStateManager.scalef((float)f6, (float)f6, (float)f6);
            GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.0f);
            GlStateManager.rotatef((float)((float)(i * i * 4321 + i * 9) * 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)0.0f);
            GlStateManager.translated((double)(-projectedView.field_72450_a), (double)(-projectedView.field_72449_c), (double)(-projectedView.field_72448_b));
            f9 = f8 + (float)projectedView.field_72448_b;
            GlStateManager.translated((double)(projectedView.field_72450_a * (double)f5 / (double)f9), (double)(projectedView.field_72449_c * (double)f5 / (double)f9), (double)(-projectedView.field_72448_b + 20.0));
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            f11 = (random.nextFloat() * 0.5f + 0.1f) * f7;
            float f12 = (random.nextFloat() * 0.5f + 0.4f) * f7;
            float f13 = (random.nextFloat() * 0.5f + 0.5f) * f7;
            if (i == 0) {
                f12 = f13 = 1.0f * f7;
                f11 = f13;
            }
            buffer.func_181662_b(posX + this.surfaceX1, posY + this.surfaceY, posZ + this.surfaceZ1).func_181666_a(f11, f12, f13, 1.0f).func_181675_d();
            buffer.func_181662_b(posX + this.surfaceX1, posY + this.surfaceY, posZ + this.surfaceZ2).func_181666_a(f11, f12, f13, 1.0f).func_181675_d();
            buffer.func_181662_b(posX + this.surfaceX2, posY + this.surfaceY, posZ + this.surfaceZ2).func_181666_a(f11, f12, f13, 1.0f).func_181675_d();
            buffer.func_181662_b(posX + this.surfaceX2, posY + this.surfaceY, posZ + this.surfaceZ1).func_181666_a(f11, f12, f13, 1.0f).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.popMatrix();
            GlStateManager.matrixMode((int)5888);
        }
        GlStateManager.disableBlend();
        GlStateManager.disableTexGen((GlStateManager.TexGen)GlStateManager.TexGen.S);
        GlStateManager.disableTexGen((GlStateManager.TexGen)GlStateManager.TexGen.T);
        GlStateManager.disableTexGen((GlStateManager.TexGen)GlStateManager.TexGen.R);
        GlStateManager.disableTexGen((GlStateManager.TexGen)GlStateManager.TexGen.Q);
        GlStateManager.enableLighting();
    }

    private FloatBuffer bufferTexData(float f, float f1, float f2, float f3) {
        this.texBuffer.clear();
        this.texBuffer.put(f).put(f1).put(f2).put(f3);
        this.texBuffer.flip();
        return this.texBuffer;
    }
}

