/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.client.render.tile;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.block.BlockEnderChest;
import codechicken.enderstorage.client.model.ButtonModelLibrary;
import codechicken.enderstorage.client.model.ModelEnderChest;
import codechicken.enderstorage.client.render.RenderCustomEndPortal;
import codechicken.enderstorage.tile.TileEnderChest;
import codechicken.lib.colour.EnumColour;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCModelLibrary;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.util.ClientUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.UVTranslation;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;

public class RenderTileEnderChest
extends TileEntityRenderer<TileEnderChest> {
    private static final ModelEnderChest model = new ModelEnderChest();
    private static final RenderCustomEndPortal renderEndPortal = new RenderCustomEndPortal(0.626, 0.188, 0.812, 0.188, 0.812);

    public void render(TileEnderChest enderChest, double x, double y, double z, float partialTicks, int destroyStage) {
        RenderTileEnderChest.renderChest(enderChest.rotation, enderChest.getFrequency(), x, y, z, RenderUtils.getTimeOffset((BlockPos)enderChest.func_174877_v()), (float)enderChest.getRadianLidAngle(partialTicks));
    }

    public static void renderChest(int rotation, Frequency freq, double x, double y, double z, int offset, float lidAngle) {
        TileEntityRendererDispatcher info = TileEntityRendererDispatcher.field_147556_a;
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        renderEndPortal.render(x, y, z, info.field_217666_g);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TextureUtils.changeTexture((String)"enderstorage:textures/enderchest.png");
        GlStateManager.pushMatrix();
        GlStateManager.enableRescaleNormal();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.translated((double)x, (double)(y + 1.0), (double)(z + 1.0));
        GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.rotatef((float)(rotation * 90), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        RenderTileEnderChest.model.chestLid.field_78795_f = lidAngle;
        model.render(freq.hasOwner());
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)x, (double)y, (double)z);
        TextureUtils.changeTexture((String)"enderstorage:textures/buttons.png");
        EnumColour[] colours = freq.toArray();
        ccrs.startDrawing(7, DefaultVertexFormats.field_181710_j);
        for (int i = 0; i < 3; ++i) {
            CCModel button = ButtonModelLibrary.button.copy();
            button.apply(BlockEnderChest.buttonT[i]);
            button.apply((Transformation)new Translation(0.5, 0.0, 0.5));
            button.apply(new Rotation((double)lidAngle, 1.0, 0.0, 0.0).at(new Vector3(0.0, 0.5625, 0.0625)));
            button.apply(new Rotation((double)(-90 * rotation) * 0.017453292519943, Vector3.Y_POS).at(new Vector3(0.5, 0.0, 0.5)));
            button.render(ccrs, new IVertexOperation[]{new UVTranslation(0.25 * (double)(colours[i].getWoolMeta() % 4), 0.25 * (double)(colours[i].getWoolMeta() / 4))});
        }
        ccrs.draw();
        GlStateManager.popMatrix();
        GlStateManager.disableLighting();
        TextureUtils.changeTexture((String)"enderstorage:textures/hedronmap.png");
        GlStateManager.pushMatrix();
        double time = ClientUtils.getRenderTime() + (double)offset;
        Matrix4 pearlMat = RenderUtils.getMatrix((Vector3)new Vector3(x + 0.5, y + 0.2 + (double)lidAngle * -0.5 + (double)RenderUtils.getPearlBob((double)time), z + 0.5), (Rotation)new Rotation(time / 3.0, new Vector3(0.0, 1.0, 0.0)), (double)0.04);
        ccrs.startDrawing(7, DefaultVertexFormats.field_181712_l);
        CCModelLibrary.icosahedron7.render(ccrs, new IVertexOperation[]{pearlMat});
        ccrs.draw();
        GlStateManager.popMatrix();
        GlStateManager.enableLighting();
    }
}

