/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.proxy;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.client.EnderPouchBakery;
import codechicken.enderstorage.client.gui.GuiEnderItemStorage;
import codechicken.enderstorage.client.render.entity.TankLayerRenderer;
import codechicken.enderstorage.client.render.item.EnderChestItemRender;
import codechicken.enderstorage.client.render.item.EnderTankItemRender;
import codechicken.enderstorage.client.render.tile.RenderTileEnderChest;
import codechicken.enderstorage.client.render.tile.RenderTileEnderTank;
import codechicken.enderstorage.config.EnderStorageConfig;
import codechicken.enderstorage.init.ModContent;
import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.enderstorage.proxy.Proxy;
import codechicken.enderstorage.storage.EnderItemStorage;
import codechicken.enderstorage.tile.TileEnderChest;
import codechicken.enderstorage.tile.TileEnderTank;
import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.model.bakery.CCBakeryModel;
import codechicken.lib.model.bakery.ModelBakery;
import codechicken.lib.texture.IIconRegister;
import codechicken.lib.texture.SpriteRegistryHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.item.Item;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class ProxyClient
extends Proxy {
    public static SpriteRegistryHelper spriteHelper = new SpriteRegistryHelper();
    public static ModelRegistryHelper modelHelper = new ModelRegistryHelper();

    @Override
    public void clientSetup(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a(ModContent.containerItemStorage, GuiEnderItemStorage::new);
        spriteHelper.addIIconRegister((IIconRegister)EnderPouchBakery.INSTANCE);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEnderChest.class, (TileEntityRenderer)new RenderTileEnderChest());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEnderTank.class, (TileEntityRenderer)new RenderTileEnderTank());
        if (!EnderStorageConfig.disableCreatorVisuals) {
            for (PlayerRenderer renderPlayer : Minecraft.func_71410_x().func_175598_ae().getSkinMap().values()) {
                renderPlayer.func_177094_a((LayerRenderer)new TankLayerRenderer((IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)renderPlayer));
            }
        }
        ModelResourceLocation invLocation = new ModelResourceLocation(ModContent.itemEnderPouch.getRegistryName(), "inventory");
        modelHelper.register(invLocation, (IBakedModel)new CCBakeryModel());
        ModelBakery.registerItemKeyGenerator((Item)ModContent.itemEnderPouch, stack -> {
            Frequency frequency = Frequency.readFromStack(stack);
            boolean open = EnderStorageManager.instance(true).getStorage(frequency, EnderItemStorage.TYPE).openCount() > 0;
            return ModelBakery.defaultItemKeyGenerator.generateKey(stack) + "|" + frequency.toModelLoc() + "|" + open;
        });
        modelHelper.register(new ModelResourceLocation(ModContent.itemEnderChest.getRegistryName(), "inventory"), (IBakedModel)new EnderChestItemRender());
        modelHelper.register(new ModelResourceLocation(ModContent.itemEnderTank.getRegistryName(), "inventory"), (IBakedModel)new EnderTankItemRender());
    }
}

