/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.tile;

import codechicken.enderstorage.init.ModContent;
import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.enderstorage.network.EnderStorageNetwork;
import codechicken.enderstorage.network.TankSynchroniser;
import codechicken.enderstorage.storage.EnderLiquidStorage;
import codechicken.enderstorage.tile.TileFrequencyOwner;
import codechicken.lib.capability.CapabilityCache;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.fluid.FluidUtils;
import codechicken.lib.math.MathHelper;
import codechicken.lib.packet.PacketCustom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;

public class TileEnderTank
extends TileFrequencyOwner {
    public int rotation;
    public EnderTankState liquid_state = new EnderTankState();
    public PressureState pressure_state = new PressureState();
    private CapabilityCache capCache = new CapabilityCache();
    private LazyOptional<IFluidHandler> fluidHandler = LazyOptional.empty();
    private boolean described;

    public TileEnderTank() {
        super(ModContent.tileEnderTankType);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.capCache.tick();
        this.pressure_state.update(this.field_145850_b.field_72995_K);
        if (this.pressure_state.a_pressure) {
            this.ejectLiquid();
        }
        this.liquid_state.update(this.field_145850_b.field_72995_K);
    }

    public void onLoad() {
        this.capCache.setWorldPos(this.func_145831_w(), this.func_174877_v());
    }

    @Override
    public void onNeighborChange(BlockPos from) {
        this.capCache.onNeighborChanged(from);
    }

    private void ejectLiquid() {
        EnderLiquidStorage source = this.getStorage();
        for (Direction side : Direction.field_82609_l) {
            int qty;
            IFluidHandler dest = (IFluidHandler)this.capCache.getCapabilityOr(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side, (Object)EmptyFluidHandler.INSTANCE);
            FluidStack drain = source.drain(100, IFluidHandler.FluidAction.SIMULATE);
            if (drain.isEmpty() || (qty = dest.fill(drain, IFluidHandler.FluidAction.EXECUTE)) <= 0) continue;
            source.drain(qty, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    public void onFrequencySet() {
        if (this.field_145850_b == null) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.liquid_state.setFrequency(this.frequency);
        }
        this.fluidHandler.invalidate();
        this.fluidHandler = LazyOptional.of(this::getStorage);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.fluidHandler.invalidate();
    }

    @Override
    public EnderLiquidStorage getStorage() {
        return EnderStorageManager.instance(this.field_145850_b.field_72995_K).getStorage(this.frequency, EnderLiquidStorage.TYPE);
    }

    @Override
    public void onPlaced(LivingEntity entity) {
        this.rotation = (int)Math.floor((double)(entity.field_70177_z * 4.0f / 360.0f) + 2.5) & 3;
        this.pressure_state.b_rotate = this.pressure_state.a_rotate = this.pressure_state.approachRotate();
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74774_a("rot", (byte)this.rotation);
        tag.func_74757_a("ir", this.pressure_state.invert_redstone);
        return tag;
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.liquid_state.setFrequency(this.frequency);
        this.rotation = tag.func_74771_c("rot") & 3;
        this.pressure_state.invert_redstone = tag.func_74767_n("ir");
    }

    @Override
    public void writeToPacket(MCDataOutput packet) {
        super.writeToPacket(packet);
        packet.writeByte(this.rotation);
        packet.writeFluidStack(this.liquid_state.s_liquid);
        packet.writeBoolean(this.pressure_state.a_pressure);
    }

    @Override
    public void readFromPacket(MCDataInput packet) {
        super.readFromPacket(packet);
        this.liquid_state.setFrequency(this.frequency);
        this.rotation = packet.readUByte() & 3;
        this.liquid_state.s_liquid = packet.readFluidStack();
        this.pressure_state.a_pressure = packet.readBoolean();
        if (!this.described) {
            this.liquid_state.c_liquid = this.liquid_state.s_liquid;
            this.pressure_state.b_rotate = this.pressure_state.a_rotate = this.pressure_state.approachRotate();
        }
        this.described = true;
    }

    @Override
    public boolean activate(PlayerEntity player, int subHit, Hand hand) {
        if (subHit == 4) {
            this.pressure_state.invert();
            return true;
        }
        return FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)this.getStorage());
    }

    @Override
    public int getLightValue() {
        if (this.liquid_state.s_liquid.getAmount() > 0) {
            return FluidUtils.getLuminosity((FluidStack)this.liquid_state.c_liquid, (double)((double)this.liquid_state.s_liquid.getAmount() / 16.0));
        }
        return 0;
    }

    @Override
    public boolean redstoneInteraction() {
        return true;
    }

    public void sync(PacketCustom packet) {
        if (packet.getType() == 5) {
            this.liquid_state.sync(packet.readFluidStack());
        } else if (packet.getType() == 6) {
            this.pressure_state.a_pressure = packet.readBoolean();
        }
    }

    @Override
    public boolean rotate() {
        if (!this.field_145850_b.field_72995_K) {
            this.rotation = (this.rotation + 1) % 4;
            PacketCustom.sendToChunk((IPacket)this.func_189518_D_(), (World)this.field_145850_b, (int)(this.field_174879_c.func_177958_n() >> 4), (int)(this.field_174879_c.func_177952_p() >> 4));
        }
        return true;
    }

    @Override
    public int comparatorInput() {
        EnderLiquidStorage tank = this.getStorage();
        FluidStack fluid = tank.getFluid();
        if (fluid == null) {
            fluid = FluidStack.EMPTY;
        }
        return fluid.getAmount() * 14 / tank.getCapacity() + (fluid.getAmount() > 0 ? 1 : 0);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.field_145846_f && cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public class PressureState {
        public boolean invert_redstone;
        public boolean a_pressure;
        public boolean b_pressure;
        public double a_rotate;
        public double b_rotate;

        public void update(boolean client) {
            if (client) {
                this.b_rotate = this.a_rotate;
                this.a_rotate = MathHelper.approachExp((double)this.a_rotate, (double)this.approachRotate(), (double)0.5, (double)20.0);
            } else {
                this.b_pressure = this.a_pressure;
                boolean bl = this.a_pressure = TileEnderTank.this.field_145850_b.func_175640_z(TileEnderTank.this.func_174877_v()) != this.invert_redstone;
                if (this.a_pressure != this.b_pressure) {
                    this.sendSyncPacket();
                }
            }
        }

        public double approachRotate() {
            return this.a_pressure ? -90.0 : 90.0;
        }

        private void sendSyncPacket() {
            PacketCustom packet = new PacketCustom(EnderStorageNetwork.NET_CHANNEL, 6);
            packet.writePos(TileEnderTank.this.func_174877_v());
            packet.writeBoolean(this.a_pressure);
            packet.sendToChunk((TileEntity)TileEnderTank.this);
        }

        public void invert() {
            this.invert_redstone = !this.invert_redstone;
            TileEnderTank.this.field_145850_b.func_217349_x(TileEnderTank.this.field_174879_c).func_177427_f(true);
        }
    }

    public class EnderTankState
    extends TankSynchroniser.TankState {
        @Override
        public void sendSyncPacket() {
            PacketCustom packet = new PacketCustom(EnderStorageNetwork.NET_CHANNEL, 5);
            packet.writePos(TileEnderTank.this.func_174877_v());
            packet.writeFluidStack(this.s_liquid);
            packet.sendToChunk((TileEntity)TileEnderTank.this);
        }

        @Override
        public void onLiquidChanged() {
            TileEnderTank.this.field_145850_b.func_72863_F().func_212863_j_().func_215568_a(TileEnderTank.this.field_174879_c);
        }
    }
}

