/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.tile;

import codechicken.enderstorage.api.AbstractEnderStorage;
import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.network.EnderStorageNetwork;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.Cuboid6;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class TileFrequencyOwner
extends TileEntity
implements ITickableTileEntity {
    public static Cuboid6 selection_button = new Cuboid6(-0.0625, 0.0, -0.125, 0.0625, 0.0625, 0.125);
    protected Frequency frequency = new Frequency();
    private int changeCount;

    public TileFrequencyOwner(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public Frequency getFrequency() {
        return this.frequency;
    }

    public void setFreq(Frequency frequency) {
        this.frequency = frequency;
        this.onFrequencySet();
        this.func_70296_d();
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        if (!this.field_145850_b.field_72995_K) {
            this.sendUpdatePacket();
        }
    }

    public void func_73660_a() {
        if (this.getStorage().getChangeCount() > this.changeCount) {
            this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
            this.changeCount = this.getStorage().getChangeCount();
        }
    }

    public abstract AbstractEnderStorage getStorage();

    public void onFrequencySet() {
    }

    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.frequency.set(new Frequency(tag.func_74775_l("Frequency")));
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_218657_a("Frequency", (INBT)this.frequency.writeToNBT(new CompoundNBT()));
        return tag;
    }

    public void func_145834_a(World worldIn) {
        super.func_145834_a(worldIn);
        this.onFrequencySet();
    }

    public boolean activate(PlayerEntity player, int subHit, Hand hand) {
        return false;
    }

    public void onNeighborChange(BlockPos from) {
    }

    public void onPlaced(LivingEntity entity) {
    }

    protected void sendUpdatePacket() {
        this.createPacket().sendToChunk(this.field_145850_b, this.func_174877_v().func_177958_n() >> 4, this.func_174877_v().func_177952_p() >> 4);
    }

    public PacketCustom createPacket() {
        PacketCustom packet = new PacketCustom(EnderStorageNetwork.NET_CHANNEL, 1);
        this.writeToPacket((MCDataOutput)packet);
        return packet;
    }

    public final SUpdateTileEntityPacket func_189518_D_() {
        return this.createPacket().toTilePacket(this.func_174877_v());
    }

    public CompoundNBT func_189517_E_() {
        return this.createPacket().writeToNBT(super.func_189517_E_());
    }

    public void writeToPacket(MCDataOutput packet) {
        this.frequency.writeToPacket(packet);
    }

    public void readFromPacket(MCDataInput packet) {
        this.frequency.set(Frequency.readFromPacket(packet));
        this.onFrequencySet();
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.readFromPacket((MCDataInput)PacketCustom.fromTilePacket((SUpdateTileEntityPacket)pkt));
    }

    public void handleUpdateTag(CompoundNBT tag) {
        this.readFromPacket((MCDataInput)PacketCustom.fromNBTTag((CompoundNBT)tag));
    }

    public int getLightValue() {
        return 0;
    }

    public boolean redstoneInteraction() {
        return false;
    }

    public int comparatorInput() {
        return 0;
    }

    public boolean rotate() {
        return false;
    }
}

