/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.block;

import codechicken.enderstorage.block.BlockEnderStorage;
import codechicken.enderstorage.tile.TileEnderTank;
import codechicken.enderstorage.tile.TileFrequencyOwner;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.raytracer.SubHitVoxelShape;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;

public class BlockEnderTank
extends BlockEnderStorage {
    private static IndexedCuboid6 TANK = new IndexedCuboid6((Object)0, new Cuboid6(0.15, 0.0, 0.15, 0.85, 0.916, 0.85));
    private static final IndexedCuboid6[][] BUTTONS = new IndexedCuboid6[4][3];
    private static final IndexedCuboid6[] DIAL = new IndexedCuboid6[4];
    private static final VoxelShape TANK_SHAPE = VoxelShapes.func_197881_a((AxisAlignedBB)TANK.aabb());
    private static final VoxelShape[] SHAPES = new VoxelShape[4];
    public static Transformation[] buttonT = new Transformation[3];

    public BlockEnderTank(Block.Properties properties) {
        super(properties);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape shape = TANK_SHAPE;
        TileEntity t = worldIn.func_175625_s(pos);
        if (t instanceof TileEnderTank) {
            TileEnderTank tile = (TileEnderTank)t;
            shape = SHAPES[tile.rotation];
        }
        return shape;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEnderTank();
    }

    static {
        for (int i = 0; i < 3; ++i) {
            BlockEnderTank.buttonT[i] = new Scale(0.6).with((Transformation)new Translation(0.35 + (double)(2 - i) * 0.15, 0.91, 0.5));
        }
        Cuboid6 dialBase = new Cuboid6(0.358, 0.268, 0.05, 0.662, 0.565, 0.15);
        for (int rot = 0; rot < 4; ++rot) {
            Transformation rotation = Rotation.quarterRotations[rot ^ 2].at(Vector3.CENTER);
            for (int button = 0; button < 3; ++button) {
                BlockEnderTank.BUTTONS[rot][button] = new IndexedCuboid6((Object)(button + 1), TileFrequencyOwner.selection_button.copy().apply(buttonT[button]).apply(rotation));
            }
            BlockEnderTank.DIAL[rot] = new IndexedCuboid6((Object)4, dialBase.copy().apply(rotation));
            ArrayList<IndexedCuboid6> cuboids = new ArrayList<IndexedCuboid6>();
            cuboids.add(TANK);
            Collections.addAll(cuboids, BUTTONS[rot]);
            cuboids.add(DIAL[rot]);
            BlockEnderTank.SHAPES[rot] = new SubHitVoxelShape(TANK_SHAPE, cuboids);
        }
    }
}

