/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.init;

import codechicken.enderstorage.block.BlockEnderChest;
import codechicken.enderstorage.block.BlockEnderTank;
import codechicken.enderstorage.container.ContainerEnderItemStorage;
import codechicken.enderstorage.item.ItemEnderPouch;
import codechicken.enderstorage.item.ItemEnderStorage;
import codechicken.enderstorage.recipe.CreateRecipe;
import codechicken.enderstorage.recipe.ReColourRecipe;
import codechicken.enderstorage.tile.TileEnderChest;
import codechicken.enderstorage.tile.TileEnderTank;
import codechicken.lib.inventory.container.ICCLContainerType;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="enderstorage")
@Mod.EventBusSubscriber(modid="enderstorage", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModContent {
    @ObjectHolder(value="ender_chest")
    public static BlockEnderChest blockEnderChest;
    @ObjectHolder(value="ender_tank")
    public static BlockEnderTank blockEnderTank;
    @ObjectHolder(value="ender_chest")
    public static ItemEnderStorage itemEnderChest;
    @ObjectHolder(value="ender_tank")
    public static ItemEnderStorage itemEnderTank;
    @ObjectHolder(value="ender_pouch")
    public static ItemEnderPouch itemEnderPouch;
    @ObjectHolder(value="ender_chest")
    public static TileEntityType<TileEnderChest> tileEnderChestType;
    @ObjectHolder(value="ender_tank")
    public static TileEntityType<TileEnderTank> tileEnderTankType;
    @ObjectHolder(value="item_storage")
    public static ContainerType<ContainerEnderItemStorage> containerItemStorage;
    @ObjectHolder(value="create_recipe")
    public static IRecipeSerializer<CreateRecipe> createRecipeSerializer;
    @ObjectHolder(value="recolour_recipe")
    public static IRecipeSerializer<ReColourRecipe> reColourRecipeSerializer;

    @SubscribeEvent
    public static void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        Block.Properties properties = Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(20.0f, 100.0f);
        registry.register(new BlockEnderChest(properties).setRegistryName("ender_chest"));
        registry.register(new BlockEnderTank(properties).setRegistryName("ender_tank"));
    }

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register(new ItemEnderStorage(blockEnderChest).setRegistryName("ender_chest"));
        registry.register(new ItemEnderStorage(blockEnderTank).setRegistryName("ender_tank"));
        registry.register(new ItemEnderPouch().setRegistryName("enderstorage", "ender_pouch"));
    }

    @SubscribeEvent
    public static void onRegisterTiles(RegistryEvent.Register<TileEntityType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register(TileEntityType.Builder.func_223042_a(TileEnderChest::new, (Block[])new Block[]{blockEnderChest}).func_206865_a(null).setRegistryName("ender_chest"));
        registry.register(TileEntityType.Builder.func_223042_a(TileEnderTank::new, (Block[])new Block[]{blockEnderTank}).func_206865_a(null).setRegistryName("ender_tank"));
    }

    @SubscribeEvent
    public static void onRegisterContainers(RegistryEvent.Register<ContainerType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register(ICCLContainerType.create(ContainerEnderItemStorage::new).setRegistryName("item_storage"));
    }

    @SubscribeEvent
    public static void onRegisterRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register(new CreateRecipe.Serializer().setRegistryName("create_recipe"));
        registry.register(new ReColourRecipe.Serializer().setRegistryName("recolour_recipe"));
    }
}

