/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.animation;

import com.toma.pubgmc.animation.Animation;
import javax.vecmath.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;

public class AimingAnimation
extends Animation {
    final Vector3f values;
    float mx;
    float my;
    float mz;
    float speed;
    boolean invx;
    boolean invy;
    boolean invz;

    public AimingAnimation(float x, float y, float z) {
        this.speed = 3.0f;
        this.values = new Vector3f(x, y, z);
        this.invx = this.values.x < 0.0f;
        this.invy = this.values.y < 0.0f;
        this.invz = this.values.z < 0.0f;
    }

    public AimingAnimation(float x, float y, float z, float speed) {
        this.values = new Vector3f(x, y, z);
        this.invx = this.values.x < 0.0f;
        this.invy = this.values.y < 0.0f;
        this.invz = this.values.z < 0.0f;
        this.speed = speed;
    }

    @Override
    public Vector3f getMovementVec() {
        return new Vector3f(this.mx, this.my, this.mz);
    }

    @Override
    public Vector3f getRotationVector() {
        return EMPTYVEC;
    }

    public Vector3f getFinalState() {
        return this.values;
    }

    public void processAnimation(boolean aiming) {
        if (!Minecraft.func_71410_x().func_147113_T()) {
            if ((this.movementX == 0.0f || this.movementZ == 0.0f) && aiming) {
                this.calculateMovementVariables(this.values.x, this.values.y, this.values.z);
            }
            if (this.mx == 0.0f && this.my == 0.0f && this.mz == 0.0f && aiming) {
                this.onAnimationFinished();
            }
            if (aiming && !this.isFinished()) {
                this.handleAiming();
            } else if (!aiming && !this.hasReturned()) {
                this.handleReturning();
            }
            GlStateManager.func_179109_b((float)this.mx, (float)this.my, (float)this.mz);
        }
    }

    protected boolean isFinished() {
        return this.mx == this.values.x && this.my == this.values.y && this.mz == this.values.z;
    }

    protected boolean hasReturned() {
        return this.mx == 0.0f && this.my == 0.0f && this.mz == 0.0f;
    }

    private void handleReturning() {
        float f = this.invx ? (this.mx < 0.0f ? this.mx + AimingAnimation.calculateMovement(this.movementX) * this.speed : 0.0f) : (this.mx = this.mx > 0.0f ? this.mx - AimingAnimation.calculateMovement(this.movementX) * this.speed : 0.0f);
        float f2 = this.invy ? (this.my < 0.0f ? this.my + AimingAnimation.calculateMovement(this.movementY) * this.speed : 0.0f) : (this.my = this.my > 0.0f ? this.my - AimingAnimation.calculateMovement(this.movementY) * this.speed : 0.0f);
        this.mz = this.invz ? (this.mz < 0.0f ? this.mz + AimingAnimation.calculateMovement(this.movementZ) * this.speed : 0.0f) : (this.mz > 0.0f ? this.mz - AimingAnimation.calculateMovement(this.movementZ) * this.speed : 0.0f);
    }

    private void handleAiming() {
        float f = this.invx ? (this.mx > this.values.x ? this.mx - AimingAnimation.calculateMovement(this.movementX) * this.speed : this.values.x) : (this.mx = this.mx < this.values.x ? this.mx + AimingAnimation.calculateMovement(this.movementX) * this.speed : this.values.x);
        float f2 = this.invy ? (this.my > this.values.y ? this.my - AimingAnimation.calculateMovement(this.movementY) * this.speed : this.values.y) : (this.my = this.my < this.values.y ? this.my + AimingAnimation.calculateMovement(this.movementY) * this.speed : this.values.y);
        this.mz = this.invz ? (this.mz > this.values.z ? this.mz - AimingAnimation.calculateMovement(this.movementZ) * this.speed : this.values.z) : (this.mz < this.values.z ? this.mz + AimingAnimation.calculateMovement(this.movementZ) * this.speed : this.values.z);
    }

    private void reset() {
        this.mx = 0.0f;
        this.my = 0.0f;
        this.mz = 0.0f;
    }

    public String toString() {
        return "Final=" + this.values + ", Current=" + this.mx + ", " + this.my + ", " + this.mz;
    }
}

