/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.animation;

import com.toma.pubgmc.animation.IPartAnimated;
import javax.annotation.Nonnull;
import javax.vecmath.Vector3f;
import net.minecraft.client.Minecraft;

public abstract class Animation {
    public static final Vector3f EMPTYVEC = new Vector3f(0.0f, 0.0f, 0.0f);
    public float movementX;
    public float movementY;
    public float movementZ;

    public static float calculateMovement(float baseMovement) {
        return baseMovement * 60.0f / (float)Minecraft.func_175610_ah();
    }

    public static float getPartialMovement(float movement, float finalPos, float modifier) {
        return Math.abs(movement - finalPos) < modifier ? finalPos : (movement < finalPos ? movement + Animation.calculateMovement(modifier) : movement - Animation.calculateMovement(modifier));
    }

    public static float decreasePartialMovement(float movement, float finalPos, float modifier) {
        return movement > finalPos ? movement - Animation.calculateMovement(modifier) : finalPos;
    }

    public static float increasePartialMovement(float movement, float finalPos, float modifier) {
        return movement < finalPos ? movement + Animation.calculateMovement(modifier) : finalPos;
    }

    public static boolean isPartMovementFinished(IPartAnimated part) {
        Vector3f transl = part.animationSteps()[part.currentStep()];
        Vector3f magTransl = part.getPartMovement();
        boolean b = magTransl.x == transl.x && magTransl.y == transl.y && magTransl.z == transl.z;
        return b;
    }

    public static boolean isPartReturned(IPartAnimated part) {
        Vector3f translation = part.getPartMovement();
        return translation.x == 0.0f && translation.y == 0.0f && translation.z == 0.0f;
    }

    public static boolean canExecuteNextStep(int current, Vector3f[] group) {
        return current + 1 < group.length;
    }

    @Nonnull
    public abstract Vector3f getMovementVec();

    @Nonnull
    public abstract Vector3f getRotationVector();

    public final void calculateMovementVariables(float x, float y, float z) {
        this.movementY = 0.0064f;
        this.movementX = Math.abs(this.movementY * x / y);
        this.movementZ = Math.abs(this.movementY * z / y);
    }

    public void onAnimationFinished() {
        this.movementX = 0.0f;
        this.movementY = 0.0f;
    }
}

