/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.animation;

import com.toma.pubgmc.animation.Animation;
import javax.vecmath.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;

public class HeldAnimation
extends Animation {
    private final HeldStyle style;
    private Vector3f value = EMPTYVEC;
    private float mx;
    private float my;
    private float mz;
    private float rx;
    private float ry;
    private float rz;

    public HeldAnimation(HeldStyle style) {
        this.style = style;
    }

    public void processAnimation() {
        if (!Minecraft.func_71410_x().func_147113_T()) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                player = Minecraft.func_71410_x().field_71439_g;
                return;
            }
            this.getHeldStyle().handle(this, player.func_70051_ag());
        }
    }

    @Override
    public Vector3f getRotationVector() {
        return new Vector3f(this.rx, this.ry, this.rz);
    }

    @Override
    public Vector3f getMovementVec() {
        return new Vector3f(this.mx, this.my, this.mz);
    }

    public HeldStyle getHeldStyle() {
        return this.style;
    }

    private boolean isNormalModeFinished() {
        return this.ry == this.style.rotation.y && this.mx == this.style.x;
    }

    private boolean hasReturned() {
        return this.ry == 0.0f && this.mx == 0.0f;
    }

    private boolean isSmallModeRotFinished() {
        return this.rx == this.style.rotation.x;
    }

    public static enum HeldStyle {
        SMALL(new Vector3f(30.0f, 0.0f, 0.0f), 0.0f, 0.0f, 0.0f),
        NORMAL(new Vector3f(0.0f, 80.0f, 0.0f), -0.5f, 0.0f, 0.0f);

        public final float x;
        public final float y;
        public final float z;
        public final Vector3f rotation;

        private HeldStyle(Vector3f rot, float x, float y, float z) {
            this.rotation = rot;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public void handle(HeldAnimation a, boolean sprint) {
            if (this.equals((Object)SMALL)) {
                this.handleSmall(a, sprint);
            } else if (this.equals((Object)NORMAL)) {
                this.handleNormal(a, sprint);
            }
        }

        private void handleSmall(HeldAnimation a, boolean sprint) {
            if (sprint && !a.isSmallModeRotFinished()) {
                a.rx = Animation.increasePartialMovement(a.rx, this.rotation.x, 3.5f);
            } else if (!sprint && a.rx != 0.0f) {
                a.rx = Animation.decreasePartialMovement(a.rx, 0.0f, 3.5f);
            }
            GlStateManager.func_179114_b((float)a.rx, (float)1.0f, (float)0.0f, (float)0.0f);
        }

        private void handleNormal(HeldAnimation a, boolean sprint) {
            if (sprint && !a.isNormalModeFinished()) {
                a.ry = Animation.increasePartialMovement(a.ry, this.rotation.y, 4.0f);
                a.mx = Animation.decreasePartialMovement(a.mx, this.x, 0.025f);
            } else if (!sprint && !a.hasReturned()) {
                a.ry = Animation.decreasePartialMovement(a.ry, 0.0f, 4.0f);
                a.mx = Animation.increasePartialMovement(a.mx, 0.0f, 0.025f);
            }
            GlStateManager.func_179109_b((float)a.mx, (float)a.my, (float)a.mz);
            GlStateManager.func_179114_b((float)a.ry, (float)0.0f, (float)1.0f, (float)0.0f);
        }
    }
}

