/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.animation;

import com.toma.pubgmc.animation.Animation;
import com.toma.pubgmc.util.PUBGMCUtil;
import javax.vecmath.Vector3f;
import net.minecraft.client.model.ModelRenderer;

public interface IPartAnimated<T extends Animation> {
    public ModelRenderer getPart();

    public Vector3f getPartMovement();

    public float getSpeed();

    public T initMovement(Vector3f[] var1);

    public int currentStep();

    public void setCurrentStep(int var1);

    public Vector3f[] animationSteps();

    public void setMovement(float var1, float var2, float var3);

    default public void process(boolean bool) {
        if (this.getPart() == null || this.animationSteps() == null) {
            return;
        }
        Vector3f step = this.animationSteps()[this.currentStep()];
        Vector3f movement = this.getPartMovement();
        if (bool) {
            if (!Animation.isPartMovementFinished(this)) {
                this.setMovement(Animation.getPartialMovement(movement.x, step.x, 0.8f * this.getSpeed()), Animation.getPartialMovement(movement.y, step.y, 0.8f * this.getSpeed()), Animation.getPartialMovement(movement.z, step.z, 0.8f * this.getSpeed()));
            } else if (Animation.canExecuteNextStep(this.currentStep(), this.animationSteps())) {
                this.setCurrentStep(this.currentStep() + 1);
            }
        } else if (!bool) {
            this.setCurrentStep(0);
            if (!Animation.isPartReturned(this)) {
                this.setMovement(Animation.getPartialMovement(movement.x, 0.0f, 0.8f * this.getSpeed()), Animation.getPartialMovement(movement.y, 0.0f, 0.8f * this.getSpeed()), Animation.getPartialMovement(movement.z, 0.0f, 0.8f * this.getSpeed()));
            }
        }
        PUBGMCUtil.setModelPosition(this.getPart(), movement.x, movement.y, movement.z);
    }
}

