/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.animation;

import com.toma.pubgmc.animation.Animation;
import com.toma.pubgmc.animation.IPartAnimated;
import com.toma.pubgmc.client.models.ModelGun;
import javax.vecmath.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;

public class ReloadAnimation
extends Animation
implements IPartAnimated<ReloadAnimation> {
    final ModelRenderer magazine;
    final ReloadStyle style;
    private Vector3f[] steps = ModelGun.DEFAULT_PART_ANIMATION;
    private float x;
    private float y;
    private float z;
    private float rx;
    private float ry;
    private float rz;
    private float px;
    private float py;
    private float pz;
    private int step;
    private float speedMultiplier;
    private final float[] defaultRotationAngles;

    public ReloadAnimation(ModelRenderer partToAnimate, ReloadStyle styleOfReload) {
        float[] fArray;
        this.magazine = partToAnimate;
        this.style = styleOfReload;
        this.speedMultiplier = 1.0f;
        if (partToAnimate == null) {
            fArray = new float[]{};
        } else {
            float[] fArray2 = new float[3];
            fArray2[0] = partToAnimate.field_78795_f;
            fArray2[1] = partToAnimate.field_78796_g;
            fArray = fArray2;
            fArray2[2] = partToAnimate.field_78808_h;
        }
        this.defaultRotationAngles = fArray;
    }

    public ReloadAnimation withSpeed(float speed) {
        this.speedMultiplier = speed = speed < 0.0f ? Math.abs(speed) : speed;
        return this;
    }

    public final void processAnimation(boolean reloading) {
        if (!Minecraft.func_71410_x().func_147113_T()) {
            this.getReloadStyle().process(reloading, this);
        }
    }

    @Override
    public void setCurrentStep(int step) {
        this.step = step;
    }

    @Override
    public int currentStep() {
        return this.step;
    }

    @Override
    public void setMovement(float x, float y, float z) {
        this.px = x;
        this.py = y;
        this.pz = z;
    }

    @Override
    public ReloadAnimation initMovement(Vector3f[] steps) {
        if (this.magazine == null) {
            return this;
        }
        this.steps = steps;
        return this;
    }

    public ReloadAnimation initMovement(Vector3f[] steps, int rotationDegrees) {
        Vector3f[] modified = new Vector3f[steps.length];
        for (int i = 0; i < steps.length; ++i) {
            Vector3f vector3f;
            Vector3f vec = steps[i];
            switch (rotationDegrees) {
                case -90: 
                case 90: {
                    vector3f = new Vector3f(vec.z, vec.y, -vec.x);
                    break;
                }
                case 180: {
                    vector3f = new Vector3f(-vec.x, vec.y, -vec.z);
                    break;
                }
                default: {
                    vector3f = vec;
                }
            }
            modified[i] = vector3f;
        }
        return this.initMovement(modified);
    }

    @Override
    public Vector3f[] animationSteps() {
        return this.steps;
    }

    @Override
    public float getSpeed() {
        return this.speedMultiplier;
    }

    @Override
    public Vector3f getMovementVec() {
        return new Vector3f(this.x, this.y, this.z);
    }

    @Override
    public Vector3f getRotationVector() {
        return new Vector3f(this.rx, this.ry, this.rz);
    }

    @Override
    public ModelRenderer getPart() {
        return this.magazine;
    }

    @Override
    public Vector3f getPartMovement() {
        return new Vector3f(this.px, this.py, this.pz);
    }

    public ReloadStyle getReloadStyle() {
        return this.style;
    }

    private boolean isMagFinished() {
        return this.rx == ((ReloadStyle)this.style).rotation.x && this.rz == ((ReloadStyle)this.style).rotation.z && this.z == ((ReloadStyle)this.style).translation.z;
    }

    private boolean isMagReturned() {
        return this.rx == 0.0f && this.rz == 0.0f && this.z == 0.0f;
    }

    private boolean isSingleFinished() {
        return this.ry == ((ReloadStyle)this.style).rotation.y && this.rz == ((ReloadStyle)this.style).rotation.z && this.x == ((ReloadStyle)this.style).translation.x && this.z == ((ReloadStyle)this.style).translation.z;
    }

    private boolean isSingleReturned() {
        return this.ry == 0.0f && this.rz == 0.0f && this.x == 0.0f && this.z == 0.0f;
    }

    private boolean isRevolverFinished() {
        return this.rx == ((ReloadStyle)this.style).rotation.x && this.rz == ((ReloadStyle)this.style).rotation.z;
    }

    private boolean isRevolverReturned() {
        return this.rx == 0.0f && this.rz == 0.0f;
    }

    public static enum ReloadStyle {
        MAGAZINE(new Vector3f(60.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.5f, -0.25f)),
        REVOLVER(new Vector3f(-20.0f, 0.0f, -15.0f), Animation.EMPTYVEC),
        SINGLE(new Vector3f(0.0f, 10.0f, 15.0f), new Vector3f(-0.05f, 0.0f, 0.05f));

        private final Vector3f rotation;
        private final Vector3f translation;

        private ReloadStyle(Vector3f rotation, Vector3f translation) {
            this.rotation = rotation;
            this.translation = translation;
        }

        public final void process(boolean reload, ReloadAnimation animation) {
            if (this.equals((Object)MAGAZINE)) {
                this.handleMagazineStyle(reload, animation);
            } else if (this.equals((Object)SINGLE)) {
                this.handleSingleStyle(reload, animation);
            } else if (this.equals((Object)REVOLVER)) {
                this.handleRevolverStyle(reload, animation);
            } else {
                throw new IllegalStateException("Uknown reload style!");
            }
        }

        private void handleMagazineStyle(boolean reload, ReloadAnimation a) {
            a.process(reload);
            if (reload && !a.isMagFinished()) {
                a.z = Animation.decreasePartialMovement(a.z, this.translation.z, 0.04f);
                a.rx = Animation.increasePartialMovement(a.rx, this.rotation.x, 3.5f);
                a.rz = Animation.decreasePartialMovement(a.rz, this.rotation.z, 2.7f);
            } else if (!reload && !a.isMagReturned()) {
                a.z = Animation.increasePartialMovement(a.z, 0.0f, 0.04f);
                a.rx = Animation.decreasePartialMovement(a.rx, 0.0f, 3.5f);
                a.rz = Animation.increasePartialMovement(a.rz, 0.0f, 2.7f);
            }
            GlStateManager.func_179114_b((float)a.rx, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)a.rz, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)a.z);
        }

        private void handleSingleStyle(boolean reload, ReloadAnimation a) {
            a.process(reload);
            if (reload && !a.isSingleFinished()) {
                a.ry = Animation.increasePartialMovement(a.ry, this.rotation.y, 2.5f);
                a.rz = Animation.increasePartialMovement(a.rz, this.rotation.z, 2.5f);
                a.x = Animation.decreasePartialMovement(a.x, this.translation.x, 0.02f);
                a.z = Animation.increasePartialMovement(a.z, this.translation.z, 0.02f);
            } else if (!reload && !a.isSingleReturned()) {
                a.ry = Animation.decreasePartialMovement(a.ry, 0.0f, 2.5f);
                a.rz = Animation.decreasePartialMovement(a.rz, 0.0f, 2.5f);
                a.x = Animation.increasePartialMovement(a.x, 0.0f, 0.02f);
                a.z = Animation.decreasePartialMovement(a.z, 0.0f, 0.02f);
            }
            GlStateManager.func_179114_b((float)a.ry, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)a.rz, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)a.x, (float)0.0f, (float)a.z);
        }

        private void handleRevolverStyle(boolean reload, ReloadAnimation a) {
            a.process(reload);
            if (reload && !a.isRevolverFinished()) {
                a.rx = Animation.decreasePartialMovement(a.rx, this.rotation.x, 2.5f);
                a.rz = Animation.decreasePartialMovement(a.rz, this.rotation.z, 2.5f);
            } else if (!reload && !a.isRevolverReturned()) {
                a.rx = Animation.increasePartialMovement(a.rx, 0.0f, 2.5f);
                a.rz = Animation.increasePartialMovement(a.rz, 0.0f, 2.5f);
            }
            GlStateManager.func_179114_b((float)a.rx, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)a.rz, (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }
}

