/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.api;

import com.toma.pubgmc.Pubgmc;
import com.toma.pubgmc.api.GameUtils;
import com.toma.pubgmc.common.capability.IGameData;
import com.toma.pubgmc.common.entity.bot.EntityAIPlayer;
import com.toma.pubgmc.network.PacketHandler;
import com.toma.pubgmc.network.sp.PacketSyncGameData;
import com.toma.pubgmc.util.PUBGMCUtil;
import com.toma.pubgmc.world.BlueZone;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Game {
    public final String registryName;
    public BlueZone zone;
    public int onlinePlayers;
    public GameInfo gameInfo;
    public int gameTimer;
    private List<UUID> playersInGame = new ArrayList<UUID>();
    public int botsInGame;

    public Game(String name) {
        this.registryName = name;
        this.onlinePlayers = 0;
        this.gameTimer = 0;
    }

    public abstract void populatePlayerList(World var1);

    public abstract void onGameStart(World var1);

    public abstract void onGameTick(World var1);

    public abstract void onGameStopped(World var1);

    public abstract void writeDataToNBT(NBTTagCompound var1);

    public abstract void readDataFromNBT(NBTTagCompound var1);

    public abstract void onPlayerKilled(EntityPlayer var1, @Nullable EntityLivingBase var2, ItemStack var3, boolean var4);

    @Nonnull
    public abstract BlueZone initializeZone(World var1);

    public abstract boolean canSpawnBots();

    public abstract <T extends EntityAIPlayer> Consumer<T> getLootDistributor();

    public boolean respawnPlayer(EntityPlayer player) {
        return false;
    }

    public boolean shouldCreateDeathCrate() {
        return true;
    }

    public boolean shouldUpdateTileEntities() {
        return true;
    }

    public int getMinimalPlayerCount() {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderGameInfo(ScaledResolution res) {
    }

    public int playerCounterUpdateFrequency() {
        return 100;
    }

    @Nullable
    public CommandException onGameStartCommandExecuted(ICommandSender sender, MinecraftServer server, String[] additionalArgs) {
        return null;
    }

    public String[] getCommandAutoCompletions(int additonalArgIndex, String arg) {
        return new String[0];
    }

    public void setGameInfo(GameInfo gameInfo) {
        this.gameInfo = gameInfo;
    }

    public void onBotDeath(EntityAIPlayer bot) {
        if (this.botsInGame > 0) {
            --this.botsInGame;
        }
    }

    public final boolean startGame(World world) {
        try {
            this.playersInGame = new ArrayList<UUID>();
            IGameData gameData = this.getGameData(world);
            this.zone = this.initializeZone(world);
            this.populatePlayerList(world);
            this.onlinePlayers = this.playersInGame.size();
            if (this.playersInGame.size() < 1) {
                throw new IllegalStateException("Cannot start game because there are no valid players");
            }
            this.onGameStart(world);
            gameData.setGame(this);
            gameData.setGameID(PUBGMCUtil.generateID(7));
            this.gameTimer = 0;
            if (this.shouldUpdateTileEntities()) {
                GameUtils.updateLoadedTileEntities(world, this, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Pubgmc.logger.fatal(e.getMessage() + " => aborting game start!");
            return false;
        }
        return true;
    }

    public final void updatePlayerCounter(World world) {
        this.onlinePlayers = (int)this.playersInGame.stream().filter(uuid -> world.func_152378_a(uuid) != null).count();
    }

    public final void tickGame(World world) {
        try {
            IGameData gameData = this.getGameData(world);
            if (gameData.isPlaying()) {
                ++this.gameTimer;
                this.onGameTick(world);
                this.zone.bluezoneTick(world);
                if (this.gameTimer % this.playerCounterUpdateFrequency() == 0) {
                    this.updatePlayerCounter(world);
                    this.updateDataToClients(world);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getGameData(world).setPlaying(false);
            Pubgmc.logger.fatal("Exception occured during game tick! Stopping game!");
            this.updateDataToClients(world);
        }
    }

    public final void stopGame(World world) {
        IGameData data = (IGameData)world.getCapability(IGameData.GameDataProvider.GAMEDATA, null);
        if (data != null && data.getLobby() != null && data.getLobby().center.func_177956_o() > 0) {
            BlockPos pos = data.getLobby().center;
            for (UUID uuid : this.playersInGame) {
                EntityPlayer player = world.func_152378_a(uuid);
                if (player == null) continue;
                this.teleportEntityTo((EntityLivingBase)player, pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
            }
            data.setPlaying(false);
            this.onGameStopped(world);
            this.playersInGame = null;
            this.gameTimer = 0;
            this.updateDataToClients(world);
        }
    }

    public final List<UUID> getJoinedPlayers() {
        return this.playersInGame;
    }

    public final int getGameTimer() {
        return this.gameTimer;
    }

    public final List<EntityPlayer> getOnlinePlayers(World world) {
        ArrayList<EntityPlayer> list = new ArrayList<EntityPlayer>();
        if (this.playersInGame == null || this.playersInGame.isEmpty()) {
            return list;
        }
        this.playersInGame.stream().filter(uuid -> world.func_152378_a(uuid) != null).forEach(uuid -> list.add(world.func_152378_a(uuid)));
        return list;
    }

    public final GameInfo getGameInformation() {
        return this.gameInfo;
    }

    public void notifyAllPlayers(World world, String message) {
        this.playersInGame.stream().filter(uuid -> world.func_152378_a(uuid) != null).forEach(uuid -> world.func_152378_a(uuid).func_145747_a((ITextComponent)new TextComponentString(message)));
    }

    public final void updateDataToClients(World world) {
        PacketHandler.sendToAllClients(new PacketSyncGameData((IGameData)world.getCapability(IGameData.GameDataProvider.GAMEDATA, null)));
    }

    public final void updateDataToClient(World world, EntityPlayerMP player) {
        PacketHandler.sendToClient(new PacketSyncGameData((IGameData)world.getCapability(IGameData.GameDataProvider.GAMEDATA, null)), player);
    }

    public final NBTTagCompound writeToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.playersInGame == null) {
            this.playersInGame = new ArrayList<UUID>();
        }
        nbt.func_74768_a("timer", this.gameTimer);
        NBTTagList uuidList = new NBTTagList();
        this.playersInGame.forEach(uuid -> uuidList.func_74742_a((NBTBase)new NBTTagString(uuid.toString())));
        nbt.func_74782_a("players", (NBTBase)uuidList);
        if (this.zone != null) {
            nbt.func_74782_a("zone", (NBTBase)this.zone.serializeNBT());
        }
        this.writeDataToNBT(nbt);
        return nbt;
    }

    public final void readFromNBT(NBTTagCompound nbt) {
        this.playersInGame = new ArrayList<UUID>();
        this.gameTimer = nbt.func_74762_e("timer");
        NBTTagList uuids = nbt.func_150295_c("players", 8);
        uuids.forEach(tag -> this.playersInGame.add(UUID.fromString(((NBTTagString)tag).func_150285_a_())));
        if (nbt.func_74764_b("zone")) {
            this.zone = BlueZone.fromNBT(nbt.func_74775_l("zone"));
        }
        this.readDataFromNBT(nbt);
    }

    public IGameData getGameData(World world) {
        return (IGameData)world.getCapability(IGameData.GameDataProvider.GAMEDATA, null);
    }

    protected final void teleportEntityTo(EntityLivingBase entity, int x, int y, int z) {
        entity.field_70165_t = (double)x + 0.5;
        entity.field_70163_u = y;
        entity.field_70161_v = (double)z + 0.5;
        entity.func_70634_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public class GameInfo {
        public final String author;
        public final String[] gameInformation;

        public GameInfo(String author, String ... gameInformation) {
            this.author = author;
            this.gameInformation = gameInformation;
        }
    }
}

