/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.api;

import com.toma.pubgmc.Pubgmc;
import com.toma.pubgmc.api.Game;
import com.toma.pubgmc.api.IGameTileEntity;
import com.toma.pubgmc.api.Lobby;
import com.toma.pubgmc.common.capability.IGameData;
import com.toma.pubgmc.common.entity.EntityPlane;
import com.toma.pubgmc.config.ConfigPMC;
import com.toma.pubgmc.init.PMCRegistry;
import java.text.DecimalFormat;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class GameUtils {
    public static final DecimalFormat FORMATTER = new DecimalFormat("##00");

    public static void updateLoadedTileEntities(World world, Game game, boolean forcedUpdate) {
        IGameData gameData = game.getGameData(world);
        if (!game.shouldUpdateTileEntities()) {
            return;
        }
        for (TileEntity tileEntity : world.field_147482_g) {
            if (!(tileEntity instanceof IGameTileEntity)) continue;
            IGameTileEntity te = (IGameTileEntity)tileEntity;
            if (forcedUpdate) {
                te.setGameHash(gameData.getGameID());
                try {
                    te.onLoaded();
                }
                catch (Exception e) {
                    Pubgmc.logger.fatal("Fatal error occurred when updating {}, aborting update!", (Object)tileEntity);
                }
                continue;
            }
            if (te.getGameHash().equals(gameData.getGameID())) continue;
            te.setGameHash(gameData.getGameID());
            try {
                te.onLoaded();
            }
            catch (Exception e) {
                Pubgmc.logger.fatal("Fatal error occurred when updating {}, aborting update!", (Object)tileEntity);
            }
        }
    }

    public static void createAndFillPlanes(World world) {
        IGameData gameData = (IGameData)world.getCapability(IGameData.GameDataProvider.GAMEDATA, null);
        Game game = gameData.getCurrentGame();
        EntityPlane plane = new EntityPlane(world, gameData);
        int joined = 0;
        Iterator<EntityPlayer> iterator = game.getOnlinePlayers(world).iterator();
        while (iterator.hasNext()) {
            BlockPos start;
            EntityPlayer player = iterator.next();
            player.field_71071_by.func_174888_l();
            player.func_191521_c(new ItemStack(PMCRegistry.PMCItems.PARACHUTE));
            boolean flag = iterator.hasNext();
            ++joined;
            plane.pendingPlayers.add(player);
            if (!flag) {
                start = plane.getStartingPosition();
                plane.pendingPlayers.forEach(p -> game.teleportEntityTo((EntityLivingBase)p, start.func_177958_n(), ConfigPMC.common.world.planeHeight, start.func_177952_p()));
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)plane);
                }
                for (EntityPlayer p2 : plane.pendingPlayers) {
                    if (p2 == null) continue;
                    p2.func_184220_m((Entity)plane);
                }
                plane.pendingPlayers = null;
                continue;
            }
            if (joined < 31) continue;
            start = plane.getStartingPosition();
            plane.pendingPlayers.forEach(p -> game.teleportEntityTo((EntityLivingBase)p, start.func_177958_n(), ConfigPMC.common.world.planeHeight, start.func_177952_p()));
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)plane);
            }
            for (EntityPlayer p2 : plane.pendingPlayers) {
                if (p2 == null) continue;
                p2.func_184220_m((Entity)plane);
            }
            plane.pendingPlayers = null;
            if (!flag) continue;
            plane = new EntityPlane(world, gameData);
            joined = 0;
        }
    }

    public static void markBlockForRemoval(World world, BlockPos pos, Block block) {
        world.func_175684_a(pos, block, 3);
    }

    public static void teleportPlayersIntoLobby(World world, Game game) {
        Lobby lobby = game.getGameData(world).getLobby();
        int x = lobby.center.func_177958_n();
        int y = lobby.center.func_177956_o() + 1;
        int z = lobby.center.func_177952_p();
        game.getOnlinePlayers(world).forEach(player -> player.func_70634_a((double)x, (double)y, (double)z));
    }

    public static String getFormattedTime(int amount, boolean isInTicks) {
        if (isInTicks) {
            amount /= 20;
        }
        int left = amount;
        int hours = left / 3600;
        int minutes = (left %= 3600) / 60;
        int seconds = left % 60;
        StringBuilder builder = new StringBuilder(8);
        if (hours > 0) {
            builder.append(FORMATTER.format(hours)).append(":");
        }
        builder.append(FORMATTER.format(minutes)).append(":");
        builder.append(FORMATTER.format(seconds));
        return builder.toString();
    }
}

