/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.api;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;

public final class Lobby {
    public final BlockPos center;
    public final int radius;

    public Lobby(BlockPos pos, int size) {
        this.center = pos;
        this.radius = size;
    }

    public boolean isInLobby(EntityPlayer player) {
        BlockPos playerPos = player.func_180425_c();
        return Math.abs(this.center.func_177958_n() - playerPos.func_177958_n()) <= this.radius && Math.abs(this.center.func_177952_p() - playerPos.func_177952_p()) <= this.radius;
    }

    public static NBTTagCompound toNBT(Lobby lobby) {
        if (lobby == null) {
            return new NBTTagCompound();
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("pos", (NBTBase)NBTUtil.func_186859_a((BlockPos)lobby.center));
        nbt.func_74768_a("rad", lobby.radius);
        return nbt;
    }

    public static Lobby fromNBT(NBTTagCompound nbt) {
        BlockPos center = NBTUtil.func_186861_c((NBTTagCompound)nbt.func_74775_l("pos"));
        int range = nbt.func_74762_e("rad");
        if (center.func_177956_o() < 1 && range < 1) {
            return null;
        }
        return new Lobby(center, range);
    }
}

