/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.api.games;

import com.toma.pubgmc.Pubgmc;
import com.toma.pubgmc.api.Game;
import com.toma.pubgmc.api.GameUtils;
import com.toma.pubgmc.api.Lobby;
import com.toma.pubgmc.common.capability.IGameData;
import com.toma.pubgmc.common.capability.IPlayerData;
import com.toma.pubgmc.common.entity.bot.EntityAIPlayer;
import com.toma.pubgmc.common.items.guns.GunBase;
import com.toma.pubgmc.init.PMCRegistry;
import com.toma.pubgmc.network.PacketHandler;
import com.toma.pubgmc.network.server.PacketChooseLocation;
import com.toma.pubgmc.util.PUBGMCUtil;
import com.toma.pubgmc.util.game.ZoneSettings;
import com.toma.pubgmc.util.game.loot.LootManager;
import com.toma.pubgmc.util.game.loot.LootType;
import com.toma.pubgmc.util.math.ZonePos;
import com.toma.pubgmc.world.BlueZone;
import com.toma.pubgmc.world.MapLocation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GameBattleRoyale
extends Game {
    private int zoneTimer;
    private List<BlockPos> scheduledAirdrops = new ArrayList<BlockPos>();
    private boolean hadRegenActive = false;
    private int botsLeft = 0;

    public GameBattleRoyale(String name) {
        super(name);
        this.setGameInfo(new Game.GameInfo("Toma", "- Classic BR mode", "- One life per game", "- Shrinking zone"));
    }

    @Override
    public BlueZone initializeZone(World world) {
        ZoneSettings settings = ZoneSettings.Builder.create().damage(0.1f).speed(0.25f).build();
        return new BlueZone(this.getGameData(world), settings);
    }

    @Override
    public void onGameStart(World world) {
        if (world.field_72995_K) {
            return;
        }
        GameUtils.createAndFillPlanes(world);
        IGameData gameData = this.getGameData(world);
        this.zoneTimer = 0;
        this.scheduledAirdrops.clear();
        List<EntityPlayer> joinedPlayers = this.getOnlinePlayers(world);
        joinedPlayers.forEach(p -> {
            p.func_70606_j(20.0f);
            p.func_71024_bL().func_75114_a(20);
            p.func_145747_a((ITextComponent)new TextComponentString("Choose one drop location"));
            for (final MapLocation location : gameData.getSpawnLocations()) {
                TextComponentString msg = new TextComponentString("- " + location.name());
                msg.func_150255_a(msg.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "", (EntityPlayer)p){
                    final /* synthetic */ EntityPlayer val$p;
                    {
                        this.val$p = entityPlayer;
                        super(x0, x1);
                    }

                    public ClickEvent.Action func_150669_a() {
                        PacketHandler.sendToServer(new PacketChooseLocation(location.pos(), this.val$p.func_184187_bx().func_145782_y()));
                        for (int i = 0; i < 50; ++i) {
                            this.val$p.func_145747_a((ITextComponent)new TextComponentString(""));
                        }
                        this.val$p.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Successfully selected drop location, you will be dropped automatically"));
                        return super.func_150669_a();
                    }
                }).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(location.pos().toString()))));
                p.func_145747_a((ITextComponent)msg);
            }
        });
        this.hadRegenActive = world.func_82736_K().func_82766_b("naturalRegeneration");
        world.func_82736_K().func_82764_b("naturalRegeneration", "false");
        this.botsLeft = 50 - this.onlinePlayers;
    }

    @Override
    public void onPlayerKilled(EntityPlayer player, @Nullable EntityLivingBase entityLivingBase, ItemStack gun, boolean headshot) {
        TextComponentString deathMessage = new TextComponentString(entityLivingBase == null ? "You have been killed!" : "You have been killed by " + entityLivingBase.func_145748_c_().func_150254_d() + (gun != null ? " using " + gun.func_82833_r() + "!" + (headshot ? "(headshot)" : "") : "!"));
        player.func_145747_a((ITextComponent)deathMessage);
        if (entityLivingBase != null) {
            int range = (int)PUBGMCUtil.getDistanceToBlockPos(player.func_180425_c(), entityLivingBase.func_180425_c());
            TextComponentString killerMSG = new TextComponentString("You have killed " + player.func_145748_c_() + " [" + range + "m]");
            TextComponentString msgForOthers = new TextComponentString(player.func_145748_c_() + (entityLivingBase == null ? "has been killed!" : "has been killed by ") + entityLivingBase.func_145748_c_() + (gun != null ? " using " + gun.func_82833_r() + "!" + (headshot ? "(headshot)" : "") : "!"));
            this.getOnlinePlayers(player.field_70170_p).stream().filter(p -> p.equals((Object)player) || p.equals((Object)entityLivingBase)).forEach(p -> p.func_145747_a((ITextComponent)msgForOthers));
        }
    }

    @Override
    public void onBotDeath(EntityAIPlayer bot) {
        super.onBotDeath(bot);
        --this.botsLeft;
        if (this.onlinePlayers <= 1 && this.botsLeft <= 0) {
            this.notifyAllPlayers(bot.field_70170_p, "Game has ended");
            this.stopGame(bot.field_70170_p);
        }
    }

    @Override
    public void onGameStopped(World world) {
        if (this.hadRegenActive) {
            world.func_82736_K().func_82764_b("naturalRegeneration", "true");
        }
    }

    @Override
    public void populatePlayerList(World world) {
        world.field_73010_i.forEach(p -> this.getJoinedPlayers().add(p.func_110124_au()));
    }

    @Override
    public boolean respawnPlayer(EntityPlayer player) {
        Lobby lobby = this.getGameData(player.field_70170_p).getLobby();
        BlockPos pos = lobby.center;
        player.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        IPlayerData data = IPlayerData.PlayerData.get(player);
        data.setBoost(0.0f);
        data.setBackpackLevel(0);
        data.hasEquippedNV(false);
        return super.respawnPlayer(player);
    }

    @Override
    public void onGameTick(World world) {
        if (!this.zone.isShrinking()) {
            ++this.zoneTimer;
            if (this.zone.currentStage == 0) {
                if (this.zoneTimer >= 2400) {
                    this.zone.notifyFirstZoneCreation(world);
                    this.scheduleAirdrop(world);
                    this.zoneTimer = 0;
                }
            } else if (this.zoneTimer >= 2000) {
                this.zone.shrink();
                if (this.zone.currentStage < 5) {
                    this.scheduleAirdrop(world);
                }
                this.zoneTimer = 0;
            }
        }
        if (this.gameTimer % 20 == 0) {
            this.tickScheduledDrops(world);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderGameInfo(ScaledResolution res) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71466_p.func_175063_a("Players left: " + (this.onlinePlayers + this.botsLeft), (float)(res.func_78326_a() - 85), 10.0f, 0xFFFFFF);
        boolean shrink = this.zone.isShrinking();
        int ticksLeft = this.zone.currentStage == 0 ? 2400 : 2000;
        int secs = (ticksLeft - this.zoneTimer) / 20;
        mc.field_71466_p.func_175063_a("Zone: ", 10.0f, 10.0f, 0xFFFFFF);
        mc.field_71466_p.func_175063_a(shrink ? "Shrinking.." : (this.zone.currentStage > 0 ? "Shrinking in " + secs + "s" : "-"), 40.0f, 10.0f, shrink ? 0xFF2323 : 0x23FF23);
    }

    @Override
    public void writeDataToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("zoneTimer", this.zoneTimer);
        NBTTagList scheduledDrops = new NBTTagList();
        this.scheduledAirdrops.forEach(p -> scheduledDrops.func_74742_a((NBTBase)NBTUtil.func_186859_a((BlockPos)p)));
        nbt.func_74782_a("scheduledAirdrops", (NBTBase)scheduledDrops);
        nbt.func_74757_a("regen", this.hadRegenActive);
        nbt.func_74768_a("botsLeft", this.botsLeft);
    }

    @Override
    public void readDataFromNBT(NBTTagCompound nbt) {
        this.scheduledAirdrops.clear();
        this.zoneTimer = nbt.func_74762_e("zoneTimer");
        NBTTagList list = nbt.func_150295_c("scheduledAirdrops", 10);
        list.forEach(tag -> this.scheduledAirdrops.add(NBTUtil.func_186861_c((NBTTagCompound)((NBTTagCompound)tag))));
        this.hadRegenActive = nbt.func_74767_n("regen");
        this.botsLeft = nbt.func_74762_e("botsLeft");
    }

    private void scheduleAirdrop(World world) {
        ZonePos min = this.zone.nextBounds.min();
        ZonePos max = this.zone.nextBounds.max();
        boolean hasDroppedOnce = false;
        while (world.field_73012_v.nextFloat() <= 0.01f || !hasDroppedOnce) {
            int x = Pubgmc.rng().nextInt(Math.abs((int)max.distanceX(min)));
            int z = Pubgmc.rng().nextInt(Math.abs((int)max.distanceZ(min)));
            int y = world.func_175672_r(new BlockPos(min.x + (double)x, 250.0, min.z + (double)z)).func_177956_o();
            if ((y += 100) > 255) {
                y = 255;
            }
            BlockPos airdrop = new BlockPos(min.x + (double)x, (double)y, min.z + (double)z);
            this.scheduledAirdrops.add(airdrop);
            this.notifyAllPlayers(world, TextFormatting.BOLD + "Airdrop is appearing at [ " + airdrop.func_177958_n() + " ; " + airdrop.func_177952_p() + " ]! Hurry up!");
            hasDroppedOnce = true;
        }
    }

    private void tickScheduledDrops(World world) {
        Iterator<BlockPos> it = this.scheduledAirdrops.iterator();
        while (it.hasNext()) {
            BlockPos pos = it.next();
            if (!world.func_175667_e(pos)) continue;
            PUBGMCUtil.spawnAirdrop(world, pos, false);
            it.remove();
        }
    }

    @Override
    public boolean canSpawnBots() {
        return this.botsLeft > 0 && this.botsLeft - this.botsInGame > 0 && this.botsInGame < 5;
    }

    public Consumer<EntityAIPlayer> getLootDistributor() {
        return this::addLootByZone;
    }

    private void addLootByZone(EntityAIPlayer player) {
        switch (this.zone.currentStage) {
            case 0: {
                return;
            }
            case 1: {
                GunBase gun = (GunBase)LootManager.getRandomObject(LootType.GUN, new GunBase.GunType[]{GunBase.GunType.PISTOL, GunBase.GunType.SHOTGUN, GunBase.GunType.SMG}, (byte)0);
                EntityItem item = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack((Item)gun));
                player.inventory.set(0, (Object)new ItemStack((Item)(player.func_70681_au().nextInt(2) == 0 ? PMCRegistry.PMCItems.PAINKILLERS : PMCRegistry.PMCItems.ENERGYDRINK)));
                Item ammo = gun.getAmmoType().ammo();
                player.inventory.set(1, (Object)new ItemStack(ammo, 30));
                player.inventory.set(2, (Object)new ItemStack(ammo, 30));
                if (player.func_70681_au().nextInt(2) == 0) {
                    player.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(PMCRegistry.PMCItems.ARMOR1HELMET));
                } else {
                    player.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(PMCRegistry.PMCItems.ARMOR1BODY));
                }
                player.field_70170_p.func_72838_d((Entity)item);
                break;
            }
            case 2: 
            case 3: {
                GunBase gun = (GunBase)LootManager.getRandomObject(LootType.GUN, new GunBase.GunType[]{GunBase.GunType.AR, GunBase.GunType.DMR, GunBase.GunType.SMG}, (byte)0);
                EntityItem item = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack((Item)gun));
                player.inventory.set(0, (Object)new ItemStack((Item)(player.func_70681_au().nextInt(2) == 0 ? PMCRegistry.PMCItems.FIRSTAIDKIT : PMCRegistry.PMCItems.BANDAGE)));
                Item ammo = gun.getAmmoType().ammo();
                player.inventory.set(1, (Object)new ItemStack(ammo, 30));
                player.inventory.set(2, (Object)new ItemStack(ammo, 30));
                player.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(PMCRegistry.PMCItems.ARMOR2HELMET));
                player.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(PMCRegistry.PMCItems.ARMOR1BODY));
                player.field_70170_p.func_72838_d((Entity)item);
                break;
            }
            default: {
                GunBase gun = (GunBase)LootManager.getRandomObject(LootType.GUN, new GunBase.GunType[]{GunBase.GunType.AR, GunBase.GunType.DMR, GunBase.GunType.SR}, (byte)1);
                EntityItem item = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack((Item)gun));
                player.inventory.set(0, (Object)new ItemStack((Item)(player.func_70681_au().nextInt(2) == 0 ? PMCRegistry.PMCItems.FIRSTAIDKIT : PMCRegistry.PMCItems.MEDKIT)));
                Item ammo = gun.getAmmoType().ammo();
                player.inventory.set(1, (Object)new ItemStack(ammo, 30));
                player.inventory.set(2, (Object)new ItemStack(ammo, 30));
                player.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(player.func_70681_au().nextInt(5) == 0 ? PMCRegistry.PMCItems.ARMOR3HELMET : PMCRegistry.PMCItems.ARMOR2HELMET));
                player.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(PMCRegistry.PMCItems.ARMOR2BODY));
                player.field_70170_p.func_72838_d((Entity)item);
                break;
            }
        }
    }
}

