/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.api.games;

import com.toma.pubgmc.Pubgmc;
import com.toma.pubgmc.api.Game;
import com.toma.pubgmc.api.GameUtils;
import com.toma.pubgmc.common.capability.IPlayerData;
import com.toma.pubgmc.common.entity.bot.EntityAIPlayer;
import com.toma.pubgmc.common.items.guns.GunBase;
import com.toma.pubgmc.config.ConfigPMC;
import com.toma.pubgmc.init.PMCRegistry;
import com.toma.pubgmc.util.PUBGMCUtil;
import com.toma.pubgmc.util.game.ZoneSettings;
import com.toma.pubgmc.util.game.loot.LootManager;
import com.toma.pubgmc.util.game.loot.LootType;
import com.toma.pubgmc.util.math.ZonePos;
import com.toma.pubgmc.world.BlueZone;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GameDeathmatch
extends Game {
    private int lootType = 0;
    private GunBase.GunType spawnWeaponType;
    private int matchDuration;
    private boolean airdrops;
    private int size;

    public GameDeathmatch(String modeName) {
        super(modeName);
        this.setGameInfo(new Game.GameInfo("Toma", "- Everybody vs Everybody!", "- Respawn on death", "- Players respawn with loot"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderGameInfo(ScaledResolution res) {
        Minecraft.func_71410_x().field_71466_p.func_78276_b("Time left: " + GameUtils.getFormattedTime(this.matchDuration - this.gameTimer, true), 10, 10, 0xFFFFFF);
    }

    @Override
    public void populatePlayerList(World world) {
        world.field_73010_i.forEach(player -> this.getJoinedPlayers().add(player.func_110124_au()));
    }

    @Override
    @Nonnull
    public BlueZone initializeZone(World world) {
        ZoneSettings settings = ZoneSettings.Builder.create().damage(10.0f).size(this.size).setStatic().build();
        return new BlueZone(this.getGameData(world), settings);
    }

    @Override
    public void onGameStart(World world) {
        this.getJoinedPlayers().forEach(player -> this.spawnAtRandomPosition(world.func_152378_a(player)));
    }

    @Override
    public void onGameTick(World world) {
        if (this.airdrops && this.gameTimer % 1200 == 0) {
            this.spawnAirdrop(world);
        }
        if (this.gameTimer >= this.matchDuration) {
            this.stopGame(world);
        }
    }

    @Override
    public void onGameStopped(World world) {
        GameUtils.teleportPlayersIntoLobby(world, this);
        List<EntityPlayer> players = this.getOnlinePlayers(world);
        players.forEach(p -> p.field_71071_by.func_174888_l());
    }

    @Override
    public void onPlayerKilled(EntityPlayer player, @Nullable EntityLivingBase entityLivingBase, ItemStack gun, boolean headshot) {
        player.field_71071_by.func_174888_l();
    }

    @Override
    public boolean respawnPlayer(EntityPlayer player) {
        if (!this.getGameData(player.field_70170_p).isPlaying()) {
            return false;
        }
        IPlayerData playerData = (IPlayerData)player.getCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null);
        playerData.setBackpackLevel(3);
        playerData.sync(player);
        this.addLootIntoInventory(player);
        return true;
    }

    @Override
    public boolean shouldCreateDeathCrate() {
        return false;
    }

    @Override
    public boolean shouldUpdateTileEntities() {
        return true;
    }

    @Override
    public boolean canSpawnBots() {
        return this.botsInGame < 3;
    }

    public Consumer<EntityAIPlayer> getLootDistributor() {
        return this::addLootIntoInventory;
    }

    @Override
    @Nullable
    public CommandException onGameStartCommandExecuted(ICommandSender sender, MinecraftServer server, String[] additionalArgs) {
        int matchDuration;
        int size;
        int loot;
        if (additionalArgs.length < 4) {
            return new CommandException("Additional arguments needed! Use /game start <weaponClass> <weaponRarity> <mapDiameter> <matchDuration[seconds]> <airdrops>", new Object[0]);
        }
        GunBase.GunType type = GunBase.GunType.getTypeFromName(additionalArgs[0]);
        if (type == null) {
            return new CommandException("Unknown weapon class!", new Object[0]);
        }
        int n = additionalArgs[1].equalsIgnoreCase("normalWeapons") ? 0 : (additionalArgs[1].equalsIgnoreCase("allowDropWeapons") ? 1 : (loot = additionalArgs[1].equalsIgnoreCase("onlyDropWeapons") ? 2 : -1));
        if (loot < 0) {
            return new CommandException("Unknown loot style! Valid styles are [normalWeapons, allowDropWeapons, onlyDropWeapons]", new Object[0]);
        }
        boolean airdrops = additionalArgs.length > 4 ? Boolean.parseBoolean(additionalArgs[4]) : false;
        try {
            size = Integer.parseInt(additionalArgs[2]);
            matchDuration = Integer.parseInt(additionalArgs[3]);
        }
        catch (NumberFormatException e) {
            return new CommandException(additionalArgs[2] + " is not a valid number!", new Object[0]);
        }
        if (size < 0) {
            return new CommandException("Size value must be positive!", new Object[0]);
        }
        this.spawnWeaponType = type;
        this.lootType = loot;
        this.size = size;
        this.matchDuration = matchDuration * 20;
        this.airdrops = airdrops;
        return null;
    }

    @Override
    public String[] getCommandAutoCompletions(int additonalArgIndex, String arg) {
        if (additonalArgIndex == 0) {
            return new String[]{"pistol", "smg", "shotgun", "ar", "dmr", "sr"};
        }
        if (additonalArgIndex == 1) {
            return new String[]{"normalWeapons", "allowDropWeapons", "onlyDropWeapons"};
        }
        if (additonalArgIndex == 4) {
            return new String[]{"true", "false"};
        }
        return new String[0];
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound) {
        compound.func_74757_a("airdrops", this.airdrops);
        compound.func_74768_a("lootRarity", this.lootType);
        if (this.spawnWeaponType != null) {
            compound.func_74768_a("lootClass", this.spawnWeaponType.ordinal());
        }
        compound.func_74768_a("matchDuration", this.matchDuration);
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound) {
        this.airdrops = compound.func_74767_n("airdrops");
        this.lootType = compound.func_74762_e("lootRarity");
        this.spawnWeaponType = compound.func_74764_b("lootClass") ? GunBase.GunType.values()[compound.func_74762_e("lootClass")] : null;
        this.matchDuration = compound.func_74762_e("matchDuration");
    }

    private void addLootIntoInventory(EntityAIPlayer bot) {
        GunBase item = (GunBase)LootManager.getRandomObject(LootType.GUN, new GunBase.GunType[]{this.spawnWeaponType}, (byte)this.lootType);
        ItemStack gun = new ItemStack((Item)item);
        bot.inventory.clear();
        if (!bot.field_70170_p.field_72995_K) {
            EntityItem itemEntity = new EntityItem(bot.field_70170_p, bot.field_70165_t, bot.field_70163_u, bot.field_70161_v, gun);
            itemEntity.func_174867_a(0);
            bot.field_70170_p.func_72838_d((Entity)itemEntity);
        }
        Item ammo = item.getAmmoType().ammo();
        bot.inventory.set(0, (Object)new ItemStack((Item)PMCRegistry.PMCItems.PAINKILLERS));
        bot.inventory.set(1, (Object)new ItemStack(ammo, 30));
        bot.inventory.set(2, (Object)new ItemStack(ammo, 30));
        bot.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(PMCRegistry.PMCItems.ARMOR1HELMET));
        bot.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(PMCRegistry.PMCItems.ARMOR1BODY));
    }

    private void addLootIntoInventory(EntityPlayer player) {
        GunBase item = (GunBase)LootManager.getRandomObject(LootType.GUN, new GunBase.GunType[]{this.spawnWeaponType}, (byte)this.lootType);
        ItemStack stack = new ItemStack((Item)item);
        NBTTagCompound nbt = this.createAttachmentNBT(item, stack);
        stack.func_77982_d(nbt);
        player.field_71071_by.func_174888_l();
        player.func_191521_c(stack);
        for (int i = 0; i < 5; ++i) {
            player.func_191521_c(item.getAmmoType().ammoStack(ConfigPMC.items().ammoLimit));
        }
        player.func_191521_c(new ItemStack((Item)PMCRegistry.PMCItems.PAINKILLERS));
        player.func_191521_c(new ItemStack((Item)PMCRegistry.PMCItems.BANDAGE, 5));
        player.func_191521_c(new ItemStack((Item)PMCRegistry.PMCItems.FIRSTAIDKIT));
    }

    private void spawnAtRandomPosition(EntityPlayer player) {
        if (player == null) {
            return;
        }
        ZonePos min = this.zone.currentBounds.min();
        int maxDist = (int)Math.abs(this.zone.currentBounds.max().x - min.x);
        int x = (int)min.x + Pubgmc.rng().nextInt(maxDist);
        int z = (int)min.z + Pubgmc.rng().nextInt(maxDist);
        int y = player.field_70170_p.func_189649_b(x, z);
        BlockPos pos = new BlockPos(x, y, z);
        player.func_70634_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        this.addLootIntoInventory(player);
    }

    private NBTTagCompound createAttachmentNBT(GunBase gun, ItemStack stack) {
        NBTTagCompound nbt = new NBTTagCompound();
        int ordinal = gun.getGunType().ordinal();
        int scopeType = gun.getScopeAttachments().length == 0 ? 0 : (ordinal == 1 || ordinal == 3 ? 1 : (ordinal > 3 ? ordinal - 1 : 0));
        int ammoAmount = gun.getWeaponAmmoLimit(stack);
        nbt.func_74757_a("isValidWeapon", true);
        nbt.func_74768_a("ammo", ammoAmount);
        nbt.func_74768_a("scope", scopeType);
        return nbt;
    }

    private void spawnAirdrop(World world) {
        List<EntityPlayer> players = this.getOnlinePlayers(world);
        EntityPlayer player = players.get(Pubgmc.rng().nextInt(players.size()));
        PUBGMCUtil.spawnAirdrop(world, new BlockPos(player.field_70165_t, player.field_70163_u + 100.0, player.field_70161_v), false);
    }
}

