/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.client;

import com.toma.pubgmc.Pubgmc;
import com.toma.pubgmc.client.models.ModelGhillie;
import com.toma.pubgmc.client.util.KeyBinds;
import com.toma.pubgmc.common.capability.IPlayerData;
import com.toma.pubgmc.common.entity.EntityParachute;
import com.toma.pubgmc.common.entity.EntityVehicle;
import com.toma.pubgmc.common.items.ItemAmmo;
import com.toma.pubgmc.common.items.ItemFuelCan;
import com.toma.pubgmc.common.items.armor.ArmorBase;
import com.toma.pubgmc.common.items.armor.ItemGhillie;
import com.toma.pubgmc.common.items.guns.GunBase;
import com.toma.pubgmc.common.items.heal.ItemHealing;
import com.toma.pubgmc.config.ConfigPMC;
import com.toma.pubgmc.config.client.CFGAimType;
import com.toma.pubgmc.config.client.CFGEnumOverlayStyle;
import com.toma.pubgmc.init.PMCRegistry;
import com.toma.pubgmc.init.PMCSounds;
import com.toma.pubgmc.network.PacketHandler;
import com.toma.pubgmc.network.server.PacketHandleParachuteInputs;
import com.toma.pubgmc.network.server.PacketHandleVehicleInput;
import com.toma.pubgmc.network.server.PacketOpenGui;
import com.toma.pubgmc.network.server.PacketProne;
import com.toma.pubgmc.network.server.PacketReloading;
import com.toma.pubgmc.network.server.PacketServerAction;
import com.toma.pubgmc.network.server.PacketSetScopeVariants;
import com.toma.pubgmc.network.server.PacketShoot;
import com.toma.pubgmc.network.server.PacketUpdateBoostValue;
import com.toma.pubgmc.util.handlers.GuiHandler;
import com.toma.pubgmc.util.helper.ImageUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ClientEvents {
    private static final ResourceLocation ScopeVSS = new ResourceLocation("pubgmc:textures/overlay/scopevss.png");
    private static final ResourceLocation Scope2X = new ResourceLocation("pubgmc:textures/overlay/scope2x.png");
    private static final ResourceLocation[] Scope4X = new ResourceLocation[]{new ResourceLocation("pubgmc:textures/overlay/scope4x_arrow.png"), new ResourceLocation("pubgmc:textures/overlay/scope4x_cross.png")};
    private static final ResourceLocation Scope8X = new ResourceLocation("pubgmc:textures/overlay/scope8x.png");
    private static final ResourceLocation Scope15X = new ResourceLocation("pubgmc:textures/overlay/scope15x.png");
    private static final ResourceLocation NV = new ResourceLocation("pubgmc:textures/overlay/nv.png");
    private static final ResourceLocation BOOST = new ResourceLocation("pubgmc:textures/overlay/boost_empty.png");
    private static final ResourceLocation BOOST_FULL = new ResourceLocation("pubgmc:textures/overlay/boost_full.png");
    private static final ResourceLocation BOOST_OVERLAY = new ResourceLocation("pubgmc:textures/overlay/boost_overlay.png");
    private static final ResourceLocation[] BACKPACK_OVERLAY = new ResourceLocation[]{new ResourceLocation("pubgmc:textures/overlay/backpack1.png"), new ResourceLocation("pubgmc:textures/overlay/backpack2.png"), new ResourceLocation("pubgmc:textures/overlay/backpack3.png")};
    private static final ResourceLocation[] NIGHT_VISION_OVERLAY = new ResourceLocation[]{new ResourceLocation("pubgmc:textures/overlay/nightvision_off.png"), new ResourceLocation("pubgmc:textures/overlay/nightvision_on.png")};
    private static final ResourceLocation VEHICLE = new ResourceLocation("pubgmc:textures/overlay/vehicle.png");
    private static final List<ResourceLocation> SCOPES = new ArrayList<ResourceLocation>();
    private static final List<ResourceLocation> HOLOS = new ArrayList<ResourceLocation>();
    private static final DecimalFormat DECIMAL = new DecimalFormat("###");
    public static int recoilTicks = 0;
    private static final int AIM_TIME = 10;
    private final ModelGhillie ghillieSuit = new ModelGhillie();
    private final Random rand = new Random();
    private int aimingTicks;
    private int reloadingSlot;
    private float prevBrightness;
    private int timer;
    private int shotsFired;
    private boolean shooting;
    private int shootingTimer;
    public static float mouseSens;
    private boolean hasAmmo;
    private int aimSlot;
    private int currentColor = 0;
    private int currentType = 0;

    private static void renderBoost(IPlayerData data) {
        ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
        int width = res.func_78326_a();
        int height = res.func_78328_b();
        if (ConfigPMC.client.overlays.imageBoostOverlay == CFGEnumOverlayStyle.IMAGE) {
            int left = width / 2 - 91;
            int top = height - 32 + 3;
            int barWidth = 182;
            ImageUtil.drawCustomSizedImage(Minecraft.func_71410_x(), BOOST, left + ConfigPMC.client.overlays.imgBoostOverlayPos.x, top + ConfigPMC.client.overlays.imgBoostOverlayPos.y, barWidth, 5.0, false);
            if (data.getBoost() > 0.0f) {
                int boost = (int)data.getBoost();
                double sizeX = 1.82 * (double)boost;
                ImageUtil.drawCustomSizedImage(Minecraft.func_71410_x(), BOOST_FULL, left + ConfigPMC.client.overlays.imgBoostOverlayPos.x, top + ConfigPMC.client.overlays.imgBoostOverlayPos.y, sizeX, 5.0, false);
            }
            ImageUtil.drawCustomSizedImage(Minecraft.func_71410_x(), BOOST_OVERLAY, left + ConfigPMC.client.overlays.imgBoostOverlayPos.x, top + ConfigPMC.client.overlays.imgBoostOverlayPos.y, barWidth, 5.0, true);
        }
    }

    private static void sendWarningToPlayer(EntityPlayer player, String textToSend) {
        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + textToSend));
    }

    private static int getScopeTypeID(int scope, int color) {
        int id = 0;
        switch (scope) {
            case 0: {
                id += 0;
                break;
            }
            case 1: {
                id += 4;
                break;
            }
            case 2: {
                id += 8;
            }
        }
        switch (color) {
            case 0: {
                id += 0;
                break;
            }
            case 1: {
                ++id;
                break;
            }
            case 2: {
                id += 2;
                break;
            }
            case 3: {
                id += 3;
            }
        }
        return id;
    }

    private static int getHoloID(int color) {
        int id = 0;
        switch (color) {
            case 0: {
                id += 0;
                break;
            }
            case 1: {
                ++id;
                break;
            }
            case 2: {
                id += 2;
                break;
            }
            case 3: {
                id += 3;
            }
        }
        return id;
    }

    private static int get4xIDFromGun(GunBase gun) {
        return gun.getGunType() == GunBase.GunType.DMR || gun.getGunType() == GunBase.GunType.SR ? 1 : 0;
    }

    private static void renderArmorIcons(RenderGameOverlayEvent.Pre e, EntityPlayer player, ScaledResolution res, Minecraft mc, IPlayerData data) {
        ResourceLocation img;
        int level;
        ArmorBase head = player.field_71071_by.func_70301_a(39).func_77973_b() instanceof ArmorBase ? (ArmorBase)player.field_71071_by.func_70301_a(39).func_77973_b() : null;
        ArmorBase body = player.field_71071_by.func_70301_a(38).func_77973_b() instanceof ArmorBase ? (ArmorBase)player.field_71071_by.func_70301_a(38).func_77973_b() : null;
        int width = res.func_78326_a();
        int height = res.func_78328_b();
        int left = width / 2 + 93;
        int top = height - 19;
        int offset = 0;
        if (head != null) {
            level = head.armorLevel().getArmorLevel();
            ItemStack headS = player.field_71071_by.func_70301_a(39);
            img = head.armorLevel().getIcon(true, level, ClientEvents.getDamageLevel(headS));
            ImageUtil.drawCustomSizedImage(mc, img, left + offset, top, 16.0, 16.0, true);
            offset += 17;
        }
        if (body != null) {
            level = body.armorLevel().getArmorLevel();
            ItemStack bodyS = player.field_71071_by.func_70301_a(38);
            img = body.armorLevel().getIcon(false, level, ClientEvents.getDamageLevel(bodyS));
            ImageUtil.drawCustomSizedImage(mc, img, left + offset, top, 16.0, 16.0, true);
            offset += 17;
        }
        if (data.getBackpackLevel() > 0) {
            level = data.getBackpackLevel() - 1;
            ImageUtil.drawCustomSizedImage(mc, BACKPACK_OVERLAY[level], left + offset, top, 16.0, 16.0, true);
            offset += 17;
        }
        if (data.getEquippedNV()) {
            int i = data.isUsingNV() ? 1 : 0;
            ImageUtil.drawCustomSizedImage(mc, NIGHT_VISION_OVERLAY[i], left + offset, top, 16.0, 16.0, true);
        }
    }

    private static int getDamageLevel(ItemStack stack) {
        double val = (double)stack.func_77952_i() / (double)stack.func_77958_k();
        return val < 0.2 ? 0 : (val > 0.7 ? 2 : 1);
    }

    private static void renderVehicleOverlay(EntityPlayer player, Minecraft mc, ScaledResolution res, RenderGameOverlayEvent.Post e) {
        if (e.getType() == RenderGameOverlayEvent.ElementType.TEXT && player.func_184187_bx() instanceof EntityVehicle) {
            EntityVehicle car = (EntityVehicle)player.func_184187_bx();
            mc.field_71466_p.func_175063_a("Speed: " + DECIMAL.format((double)Math.abs(car.currentSpeed) * 48.5) + "km/h", 15.0f, (float)(res.func_78328_b() - 60), 0xFFFFFF);
        } else if (e.getType() == RenderGameOverlayEvent.ElementType.ALL && player.func_184187_bx() instanceof EntityVehicle) {
            EntityVehicle car = (EntityVehicle)player.func_184187_bx();
            double health = car.health / car.maxHealth * 100.0f;
            ImageUtil.drawImageWithUV(mc, VEHICLE, 15, res.func_78328_b() - 40, (double)car.fuel * 1.2, 5.0, 0.0, 0.25, 1.0, 0.375, false);
            ImageUtil.drawImageWithUV(mc, VEHICLE, 15, res.func_78328_b() - 40, 120.0, 5.0, 0.0, 0.375, 1.0, 0.5, true);
            ImageUtil.drawImageWithUV(mc, VEHICLE, 15, res.func_78328_b() - 50, 120.0, 5.0, 0.0, 0.125, 1.0, 0.25, false);
            ImageUtil.drawImageWithUV(mc, VEHICLE, 15, res.func_78328_b() - 50, health * 1.2, 5.0, 0.0, 0.0, 1.0, 0.125, false);
        }
    }

    private static void drawItemUseOverlay(EntityPlayer player, Minecraft mc, ScaledResolution res, RenderGameOverlayEvent.Pre e, ItemStack stack) {
        DecimalFormat f = new DecimalFormat("#,#0.0");
        float useTime = player.func_184605_cv();
        FontRenderer font = mc.field_71466_p;
        int width = res.func_78326_a();
        int height = res.func_78328_b();
        int left = width / 2;
        int top = height / 2;
        font.func_175063_a(f.format(useTime / 20.0f), (float)(left - 6), (float)(top + 3), 0xFFFFFF);
    }

    public void renderPlayerPost(RenderPlayerEvent.Post e) {
        EntityPlayer player = e.getEntityPlayer();
        ItemStack stack = player.func_184582_a(EntityEquipmentSlot.LEGS);
        if (stack.func_77973_b() instanceof ItemGhillie) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)0.2, (double)0.2, (double)0.2);
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)-10.0f, (float)0.0f);
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public void drawNameTags(RenderLivingEvent.Specials.Pre e) {
        if (e.getEntity() instanceof EntityPlayer && e.isCancelable() && !ConfigPMC.common.player.renderNames) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void renderOverlayPost(RenderGameOverlayEvent.Post e) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP sp = mc.field_71439_g;
        ScaledResolution res = new ScaledResolution(mc);
        IPlayerData data = (IPlayerData)sp.getCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null);
        if (!e.isCancelable() && e.getType() == RenderGameOverlayEvent.ElementType.TEXT && !sp.field_71075_bZ.field_75098_d && !sp.func_175149_v() && ConfigPMC.client.overlays.imageBoostOverlay == CFGEnumOverlayStyle.TEXT && data.getBoost() > 0.0f) {
            mc.field_71460_t.func_78478_c();
            int width = res.func_78326_a();
            int height = res.func_78328_b();
            int left = width / 2 + 45;
            int top = height - 49;
            int color = 0;
            if (data.getBoost() >= 50.0f) {
                color = 14651904;
            }
            if (data.getBoost() < 50.0f) {
                color = 14664960;
            }
            if (data.getBoost() > 9.0f) {
                left -= 5;
            }
            mc.field_71466_p.func_175063_a(data.getBoost() + " / 100", (float)(left + ConfigPMC.client.overlays.textBoostOverlayPos.x), (float)(top + ConfigPMC.client.overlays.textBoostOverlayPos.y), color);
        }
        if (!e.isCancelable() && e.getType() == RenderGameOverlayEvent.ElementType.TEXT && sp.func_184614_ca().func_77973_b() instanceof GunBase) {
            ItemStack weaponStack = sp.func_184614_ca();
            GunBase gun = (GunBase)weaponStack.func_77973_b();
            mc.field_71460_t.func_78478_c();
            int x = 15;
            int y = e.getResolution().func_78328_b() - 15;
            int totalCount = 0;
            for (int i = 0; i < sp.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = sp.field_71071_by.func_70301_a(i);
                if (!(stack.func_77973_b() instanceof ItemAmmo)) continue;
                ItemAmmo ammo = (ItemAmmo)stack.func_77973_b();
                if (ammo.type != gun.getAmmoType()) continue;
                totalCount += stack.func_190916_E();
            }
            if (weaponStack.func_77942_o()) {
                int ammo = weaponStack.func_77978_p().func_74762_e("ammo");
                mc.field_71466_p.func_175063_a(gun.func_77653_i(new ItemStack((Item)gun)) + ": " + (Object)((Object)gun.getFiremode()), (float)x, (float)(y - 9), 0xFFFFFF);
                mc.field_71466_p.func_175063_a(TextFormatting.BOLD + "" + ammo + TextFormatting.RESET + " | " + totalCount, (float)x, (float)y, 0xFFFFFF);
            }
        }
        ClientEvents.renderVehicleOverlay((EntityPlayer)sp, mc, res, e);
    }

    @SubscribeEvent
    public void renderOverlayPre(RenderGameOverlayEvent.Pre e) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP sp = mc.field_71439_g;
        ScaledResolution res = new ScaledResolution(mc);
        ItemStack stack = sp.func_184614_ca();
        IPlayerData data = (IPlayerData)sp.getCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null);
        int width = res.func_78326_a();
        int height = res.func_78328_b();
        if (e.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS && stack.func_77973_b() instanceof GunBase) {
            e.setCanceled(true);
        }
        if (ConfigPMC.client.overlays.imageBoostOverlay == CFGEnumOverlayStyle.IMAGE && e.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE && ConfigPMC.client.overlays.imgBoostOverlayPos.x == 0 && ConfigPMC.client.overlays.imgBoostOverlayPos.y == 0 && data.getBoost() > 0.0f) {
            e.setCanceled(true);
        }
        if (e.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            if (data.isUsingNV()) {
                ImageUtil.drawFullScreenImage(mc, res, NV, true);
            }
            if (!sp.field_71075_bZ.field_75098_d && !sp.func_175149_v() && data.getBoost() > 0.0f) {
                ClientEvents.renderBoost(data);
            }
            if (stack.func_77973_b() instanceof GunBase) {
                GunBase gun = (GunBase)stack.func_77973_b();
                if (data.isAiming() && mc.field_71474_y.field_74320_O == 0) {
                    if (stack.func_77973_b() == PMCRegistry.PMCItems.VSS) {
                        ImageUtil.drawFullScreenImage(mc, res, ScopeVSS, true);
                    }
                    if (stack.func_77942_o()) {
                        int halfX = res.func_78326_a() / 2;
                        int halfY = res.func_78328_b() / 2;
                        int left = halfX - 8;
                        int top = halfY - 8;
                        if (stack.func_77978_p().func_74762_e("scope") == 1 && this.aimingTicks >= 10) {
                            ImageUtil.drawCustomSizedImage(mc, SCOPES.get(ClientEvents.getScopeTypeID(data.getScopeType(), data.getScopeColor())), left, top, 17.0, 17.0, true);
                        } else if (stack.func_77978_p().func_74762_e("scope") == 2 && this.aimingTicks >= 10) {
                            ImageUtil.drawCustomSizedImage(mc, HOLOS.get(ClientEvents.getHoloID(data.getScopeColor())), left, top, 17.0, 17.0, true);
                        } else if (stack.func_77978_p().func_74762_e("scope") == 3) {
                            ImageUtil.drawFullScreenImage(mc, res, Scope2X, true);
                        } else if (stack.func_77978_p().func_74762_e("scope") == 4) {
                            ImageUtil.drawFullScreenImage(mc, res, Scope4X[ClientEvents.get4xIDFromGun(gun)], true);
                        } else if (stack.func_77978_p().func_74762_e("scope") == 5) {
                            ImageUtil.drawFullScreenImage(mc, res, Scope8X, true);
                        } else if (stack.func_77978_p().func_74762_e("scope") == 6) {
                            ImageUtil.drawFullScreenImage(mc, res, Scope15X, true);
                        }
                    }
                }
            }
            if (ConfigPMC.client.overlays.renderArmorIcons && !sp.func_175149_v()) {
                ClientEvents.renderArmorIcons(e, (EntityPlayer)sp, res, mc, data);
            }
            if ((stack.func_77973_b() instanceof ItemHealing || stack.func_77973_b() instanceof ItemFuelCan) && sp.func_184587_cr()) {
                ClientEvents.drawItemUseOverlay((EntityPlayer)sp, mc, res, e, stack);
            }
        }
    }

    @SubscribeEvent
    public void onKeyPressed(InputEvent.KeyInputEvent event) {
        IPlayerData data;
        EntityPlayerSP sp = Minecraft.func_71410_x().field_71439_g;
        if (KeyBinds.CHANGE_SCOPETYPE.func_151468_f() && this.canSwitchType(sp.func_184614_ca()) && sp.hasCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null)) {
            this.switchScopeType((IPlayerData)sp.getCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null));
        }
        if (KeyBinds.CHANGE_SCOPECOLOR.func_151468_f() && sp.hasCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null)) {
            this.switchScopeColor((IPlayerData)sp.getCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null));
        }
        if (KeyBinds.PRONE.func_151468_f() && (data = IPlayerData.PlayerData.get((EntityPlayer)sp)) != null) {
            data.setProning(!data.isProning());
            if (data.isAiming()) {
                this.setAiming(data, false);
            }
            if (data.isReloading()) {
                this.setReloading(data, false);
            }
            PacketHandler.sendToServer(new PacketProne(data.isProning()));
        }
        if (ConfigPMC.common.world.gunsEnabled) {
            GunBase item;
            data = (IPlayerData)sp.getCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null);
            if (KeyBinds.ATTACHMENT.func_151468_f()) {
                if (sp.func_184614_ca().func_77973_b() instanceof GunBase) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketOpenGui(GuiHandler.GUI_ATTACHMENTS));
                } else {
                    sp.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "You must hold gun in your hand!"), true);
                }
            }
            if (KeyBinds.RELOAD.func_151468_f()) {
                if (data.isReloading()) {
                    return;
                }
                if (sp.func_184614_ca().func_77973_b() instanceof GunBase) {
                    GunBase gun = (GunBase)sp.func_184614_ca().func_77973_b();
                    if (sp.func_184614_ca().func_77942_o()) {
                        int ammo = sp.func_184614_ca().func_77978_p().func_74762_e("ammo");
                        if (!data.isReloading() && ammo < gun.getWeaponAmmoLimit(sp.func_184614_ca())) {
                            data.setReloading(true);
                            data.setReloadingTime(0);
                            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketReloading(true));
                            this.reloadingSlot = sp.field_71071_by.field_70461_c;
                            if (data.isAiming()) {
                                data.setAiming(false);
                                PacketHandler.sendToServer(new PacketServerAction(false, PacketServerAction.ServerAction.AIM));
                                Minecraft.func_71410_x().field_71474_y.field_74341_c = mouseSens;
                            }
                        }
                    }
                }
            }
            if (KeyBinds.NV.func_151468_f() && data.getEquippedNV()) {
                data.setNV(!data.isUsingNV());
                PacketHandler.sendToServer(new PacketServerAction(data.isUsingNV(), PacketServerAction.ServerAction.NIGHT_VISION));
            }
            if (KeyBinds.FIREMODE.func_151468_f() && sp.func_184614_ca().func_77973_b() instanceof GunBase && (item = (GunBase)sp.func_184614_ca().func_77973_b()).getCanSwitchFiremode()) {
                item.getNextFiremode((EntityPlayer)sp);
            }
        }
    }

    @SubscribeEvent
    public void onMouseInput(InputEvent.MouseInputEvent e) {
        ItemStack stack;
        GameSettings gs = Minecraft.func_71410_x().field_71474_y;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        CooldownTracker tracker = player.func_184811_cZ();
        if (player != null && !player.func_175149_v() && (stack = player.func_184614_ca()).func_77973_b() instanceof GunBase) {
            GunBase gun = (GunBase)stack.func_77973_b();
            IPlayerData data = (IPlayerData)player.getCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null);
            if (gs.field_74312_F.func_151468_f()) {
                if (ConfigPMC.common.world.gunsEnabled) {
                    if (gun.getFiremode() == GunBase.Firemode.SINGLE && !tracker.func_185141_a((Item)gun) && !data.isReloading()) {
                        if (gun.hasAmmo(stack)) {
                            recoilTicks = 10;
                            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketShoot());
                            if (gun.getAction() != null) {
                                Pubgmc.proxy.playMCDelayedSound(gun.getAction().get(), player.field_70165_t, player.field_70163_u, player.field_70161_v, 1.0f, 20);
                            }
                            this.applyRecoil((EntityPlayer)player, stack);
                        } else {
                            player.func_184185_a(PMCSounds.gun_noammo, 4.0f, 1.0f);
                        }
                    }
                } else {
                    ClientEvents.sendWarningToPlayer((EntityPlayer)player, "Guns are disabled!");
                }
                if (gun.getFiremode() == GunBase.Firemode.BURST) {
                    if (ConfigPMC.common.world.gunsEnabled) {
                        if (!(tracker.func_185141_a((Item)gun) || this.shooting || data.isReloading())) {
                            if (gun.hasAmmo(stack)) {
                                this.shooting = true;
                                this.shotsFired = 0;
                            } else {
                                player.func_184185_a(PMCSounds.gun_noammo, 4.0f, 1.0f);
                            }
                        }
                    } else {
                        ClientEvents.sendWarningToPlayer((EntityPlayer)player, "Guns are disabled!");
                    }
                }
            }
            if (gs.field_74313_G.func_151468_f()) {
                if (!data.isAiming() && !player.func_70051_ag()) {
                    this.aimingTicks = 0;
                    this.aimSlot = player.field_71071_by.field_70461_c;
                    data.setAiming(true);
                    PacketHandler.sendToServer(new PacketServerAction(true, PacketServerAction.ServerAction.AIM));
                    int scopeID = stack.func_77978_p().func_74762_e("scope");
                    switch (scopeID) {
                        case 1: 
                        case 2: {
                            gs.field_74341_c *= 0.95f;
                            break;
                        }
                        case 3: {
                            gs.field_74341_c *= 0.85f;
                            break;
                        }
                        case 4: {
                            gs.field_74341_c *= 0.65f;
                            break;
                        }
                        case 5: {
                            gs.field_74341_c *= 0.4f;
                            break;
                        }
                        case 6: {
                            gs.field_74341_c *= 0.01f;
                            break;
                        }
                    }
                } else {
                    data.setAiming(false);
                    PacketHandler.sendToServer(new PacketServerAction(false, PacketServerAction.ServerAction.AIM));
                    gs.field_74341_c = mouseSens;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onClientTick(TickEvent.ClientTickEvent ev) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        GameSettings gs = Minecraft.func_71410_x().field_71474_y;
        if (recoilTicks > 0) {
            --recoilTicks;
        }
        if (player != null && player.hasCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null)) {
            IPlayerData data = (IPlayerData)player.getCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null);
            if (ev.phase == TickEvent.Phase.END) {
                this.handleVehicleControls(gs.field_74351_w.func_151470_d(), gs.field_74368_y.func_151470_d(), gs.field_74366_z.func_151470_d(), gs.field_74370_x.func_151470_d(), (EntityPlayer)player);
                this.handleParachuteControls(gs.field_74351_w.func_151470_d(), gs.field_74368_y.func_151470_d(), gs.field_74366_z.func_151470_d(), gs.field_74370_x.func_151470_d(), (EntityPlayer)player);
            }
            if (ConfigPMC.other().useDynamicBobbing && player.func_184614_ca().func_77973_b() instanceof GunBase) {
                Minecraft.func_71410_x().field_71474_y.field_74336_f = player.func_70051_ag();
            }
            if (gs.field_74312_F.func_151470_d() && ev.phase == TickEvent.Phase.END && !player.func_175149_v() && player.func_184614_ca().func_77973_b() instanceof GunBase) {
                if (ConfigPMC.common.world.gunsEnabled) {
                    GunBase gun = (GunBase)player.func_184614_ca().func_77973_b();
                    CooldownTracker tracker = player.func_184811_cZ();
                    if (gun.getFiremode() == GunBase.Firemode.AUTO && !tracker.func_185141_a((Item)gun) && !data.isReloading()) {
                        if (gun.hasAmmo(player.func_184614_ca())) {
                            recoilTicks = 10;
                            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketShoot());
                            this.applyRecoil((EntityPlayer)player, player.func_184614_ca());
                        } else {
                            player.func_184185_a(PMCSounds.gun_noammo, 4.0f, 1.0f);
                        }
                    }
                } else {
                    ClientEvents.sendWarningToPlayer((EntityPlayer)player, "Guns are disabled!");
                }
            }
            if (player.func_184614_ca().func_77973_b() instanceof GunBase && !player.func_175149_v()) {
                ItemStack stack = player.func_184614_ca();
                GunBase gun = (GunBase)player.func_184614_ca().func_77973_b();
                CooldownTracker tracker = player.func_184811_cZ();
                int maxRounds = gun.isHasTwoRoundBurst() ? 3 : 6;
                if (stack.func_77942_o() && gun.hasAmmo(stack)) {
                    if (this.shooting && gun.getFiremode() == GunBase.Firemode.BURST && ConfigPMC.common.world.gunsEnabled) {
                        ++this.shootingTimer;
                        if (this.shootingTimer >= gun.getFireRate() && this.shotsFired < maxRounds) {
                            recoilTicks = 10;
                            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketShoot());
                            this.applyRecoil((EntityPlayer)player, stack);
                            ++this.shotsFired;
                            this.shootingTimer = 0;
                        }
                        if (this.shotsFired >= maxRounds || !gun.hasAmmo(stack)) {
                            this.shooting = false;
                            this.shootingTimer = 0;
                            this.shotsFired = 0;
                        }
                    } else {
                        this.shooting = false;
                        this.shootingTimer = 0;
                        this.shotsFired = 0;
                    }
                } else if (this.shooting) {
                    this.shooting = false;
                    this.shootingTimer = 0;
                    this.shotsFired = 0;
                }
            }
            if (data.isAiming()) {
                if (this.aimingTicks < 10) {
                    ++this.aimingTicks;
                }
                if (this.aimSlot != player.field_71071_by.field_70461_c) {
                    this.setAiming(data, false);
                    gs.field_74341_c = mouseSens;
                }
                if (ConfigPMC.client.aimType == CFGAimType.HOLD && !gs.field_74313_G.func_151470_d()) {
                    this.setAiming(data, false);
                    gs.field_74341_c = mouseSens;
                }
            }
            if (player.func_70051_ag() && data.isAiming()) {
                this.setAiming(data, false);
                gs.field_74341_c = mouseSens;
            }
            if (!(player.func_184614_ca().func_77973_b() instanceof GunBase) && data.isAiming()) {
                this.setAiming(data, false);
                gs.field_74341_c = mouseSens;
            }
            if (data.getBoost() > 100.0f) {
                data.setBoost(100.0f);
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketUpdateBoostValue(100.0f));
            }
            if (!data.isAiming() && gs.field_74341_c != (mouseSens = gs.field_74341_c)) {
                gs.field_74341_c = mouseSens;
            }
            if (this.timer++ >= 80 && data.getBoost() > 0.0f) {
                this.timer = 0;
                data.removeBoost(1.0f);
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketUpdateBoostValue(data.getBoost()));
            }
            if (data.isReloading() && this.reloadingSlot != player.field_71071_by.field_70461_c) {
                this.setReloading(data, true);
            }
        }
        if (ev.phase == TickEvent.Phase.END && player != null && player.hasCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null)) {
            float bright;
            ItemStack itemstack = player.func_184614_ca();
            Item item = itemstack.func_77973_b();
            IPlayerData data = (IPlayerData)player.getCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null);
            if (player.func_184187_bx() instanceof EntityParachute && !player.field_71075_bZ.field_75098_d && Minecraft.func_71410_x().field_71474_y.field_74320_O != 1) {
                Minecraft.func_71410_x().field_71474_y.field_74320_O = 1;
            }
            if (!(ConfigPMC.player().tppAllowed || Minecraft.func_71410_x().field_71474_y.field_74320_O == 0 || player.field_71075_bZ.field_75098_d || player.func_184187_bx() instanceof EntityParachute)) {
                Minecraft.func_71410_x().field_71474_y.field_74320_O = 0;
            }
            if (ConfigPMC.player().brightnessForced && (bright = Minecraft.func_71410_x().field_71474_y.field_74333_Y) != (float)ConfigPMC.player().brightnessValue) {
                Minecraft.func_71410_x().field_71474_y.field_74333_Y = ConfigPMC.player().brightnessValue;
            }
            if (data.isReloading()) {
                if (player.func_184614_ca().func_77973_b() instanceof GunBase && player.func_184614_ca().func_77978_p().func_74767_n("isValidWeapon")) {
                    GunBase gun = (GunBase)player.func_184614_ca().func_77973_b();
                    data.setReloadingTime(data.getReloadingTime() + 1);
                    for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                        ItemStack stack = player.field_71071_by.func_70301_a(i);
                        if (!(stack.func_77973_b() instanceof ItemAmmo) || !player.field_70170_p.field_72995_K) continue;
                        ItemAmmo ammo = (ItemAmmo)stack.func_77973_b();
                        if (ammo.type == gun.getAmmoType()) {
                            this.hasAmmo = true;
                        }
                        if (gun.getReloadType() == GunBase.ReloadType.MAGAZINE) {
                            if (!((double)data.getReloadingTime() >= gun.getReloadTime(itemstack))) continue;
                            data.setReloadingTime(0);
                            this.hasAmmo = false;
                            this.setReloading(data, false);
                            PacketHandler.sendToServer(new PacketServerAction(false, PacketServerAction.ServerAction.RELOAD));
                            continue;
                        }
                        if (gun.getReloadType() == GunBase.ReloadType.SINGLE) {
                            if (!((double)data.getReloadingTime() >= gun.getReloadTime(itemstack))) continue;
                            data.setReloadingTime(0);
                            this.hasAmmo = false;
                            PacketHandler.sendToServer(new PacketServerAction(false, PacketServerAction.ServerAction.RELOAD));
                            continue;
                        }
                        if (gun.getReloadType() != GunBase.ReloadType.KAR98K || !itemstack.func_77942_o()) continue;
                        if (itemstack.func_77978_p().func_74762_e("ammo") == 0) {
                            if (!((double)data.getReloadingTime() >= gun.getReloadTime(itemstack))) continue;
                            data.setReloadingTime(0);
                            this.hasAmmo = false;
                            PacketHandler.sendToServer(new PacketServerAction(false, PacketServerAction.ServerAction.RELOAD));
                            continue;
                        }
                        if (data.getReloadingTime() < 18) continue;
                        data.setReloadingTime(0);
                        this.hasAmmo = false;
                        PacketHandler.sendToServer(new PacketServerAction(false, PacketServerAction.ServerAction.RELOAD));
                    }
                    if (data.getReloadingTime() == 1 && data.isReloading()) {
                        if (gun.getReloadType() == GunBase.ReloadType.MAGAZINE && this.hasAmmo) {
                            player.func_184185_a(gun.getWeaponReloadSound(), 1.0f, 1.0f);
                            this.hasAmmo = false;
                        } else if (gun.getReloadType() == GunBase.ReloadType.SINGLE) {
                            if (itemstack.func_77942_o() && itemstack.func_77978_p().func_74762_e("ammo") < gun.getWeaponAmmoLimit(itemstack) && this.hasAmmo) {
                                player.func_184185_a(gun.getWeaponReloadSound(), 1.0f, 1.0f);
                                this.hasAmmo = false;
                            }
                        } else if (gun.getReloadType() == GunBase.ReloadType.KAR98K && itemstack.func_77942_o()) {
                            if (itemstack.func_77978_p().func_74762_e("ammo") == 0 && this.hasAmmo) {
                                player.func_184185_a(PMCSounds.reload_kar98k, 1.0f, 1.0f);
                                this.hasAmmo = false;
                            } else if (itemstack.func_77978_p().func_74762_e("ammo") < gun.getWeaponAmmoLimit(itemstack) && this.hasAmmo) {
                                player.func_184185_a(PMCSounds.reload_kar98k_single, 1.0f, 1.0f);
                                this.hasAmmo = false;
                            }
                        }
                    }
                } else {
                    data.setReloadingTime(0);
                    this.setReloading(data, false);
                    this.hasAmmo = false;
                }
                if (player.func_70051_ag()) {
                    player.func_70031_b(false);
                }
                if (data.isAiming()) {
                    this.setAiming(data, false);
                }
                if (player.func_184614_ca().func_77973_b() instanceof GunBase && !player.field_71071_by.func_70431_c(((GunBase)player.func_184614_ca().func_77973_b()).getAmmoType().ammoStack())) {
                    this.setReloading(data, false);
                }
            } else if (this.hasAmmo) {
                this.hasAmmo = false;
            }
        }
    }

    private void applyRecoil(EntityPlayer player, ItemStack gun) {
        float gripModifier = 1.0f;
        float angledGrip = 1.0f;
        float stockMod = 1.0f;
        if (gun.func_77973_b() instanceof GunBase) {
            if (gun.func_77942_o()) {
                if (gun.func_77978_p().func_74762_e("stock") == 2) {
                    stockMod = 0.9f;
                }
                if (gun.func_77978_p().func_74762_e("grip") == 1) {
                    gripModifier = 0.8f;
                } else if (gun.func_77978_p().func_74762_e("grip") == 2) {
                    angledGrip = 0.8f;
                } else {
                    gripModifier = 1.0f;
                    angledGrip = 1.0f;
                }
            } else {
                throw new IllegalArgumentException("No valid NBT found. Report this to PUBGMC author!");
            }
            GunBase wep = (GunBase)gun.func_77973_b();
            if (player.func_70093_af()) {
                if (gun.func_77942_o()) {
                    player.field_70125_A = gun.func_77978_p().func_74762_e("barrel") == 2 ? (player.field_70125_A -= wep.getVerticalRecoil(gun) * wep.getConfigurableStats().recoilVerticalMultiplier * 0.8f * gripModifier * stockMod * (float)this.rand.nextDouble() * 1.5f * 0.9f) : (player.field_70125_A -= wep.getVerticalRecoil(gun) * wep.getConfigurableStats().recoilVerticalMultiplier * gripModifier * stockMod * (float)this.rand.nextDouble() * 1.5f * 0.9f);
                }
            } else if (gun.func_77942_o()) {
                player.field_70125_A = gun.func_77978_p().func_74762_e("barrel") == 2 ? (player.field_70125_A -= wep.getVerticalRecoil(gun) * wep.getConfigurableStats().recoilVerticalMultiplier * 0.8f * gripModifier * stockMod * (float)this.rand.nextDouble() * 1.5f) : (player.field_70125_A -= wep.getVerticalRecoil(gun) * wep.getConfigurableStats().recoilVerticalMultiplier * gripModifier * stockMod * (float)this.rand.nextDouble() * 1.5f);
            }
            if (Math.random() * 100.0 <= 50.0) {
                if (gun.func_77942_o()) {
                    player.field_70177_z = gun.func_77978_p().func_74762_e("barrel") == 2 ? (player.field_70177_z -= wep.getHorizontalRecoil(gun) * wep.getConfigurableStats().recoilHorizontalMultiplier * 0.8f * angledGrip * stockMod * (float)this.rand.nextDouble() * 1.5f) : (player.field_70177_z -= wep.getHorizontalRecoil(gun) * wep.getConfigurableStats().recoilHorizontalMultiplier * angledGrip * stockMod * (float)this.rand.nextDouble() * 1.5f);
                }
            } else if (gun.func_77942_o()) {
                player.field_70177_z = gun.func_77978_p().func_74762_e("barrel") == 2 ? (player.field_70177_z += wep.getHorizontalRecoil(gun) * wep.getConfigurableStats().recoilHorizontalMultiplier * 0.8f * angledGrip * stockMod * (float)this.rand.nextDouble() * 1.5f) : (player.field_70177_z += wep.getHorizontalRecoil(gun) * wep.getConfigurableStats().recoilHorizontalMultiplier * angledGrip * stockMod * (float)this.rand.nextDouble() * 1.5f);
            }
        }
    }

    private void setReloading(IPlayerData data, boolean reload) {
        data.setReloading(reload);
        PacketHandler.sendToServer(new PacketReloading(reload));
    }

    private void setAiming(IPlayerData data, boolean aim) {
        data.setAiming(aim);
        PacketHandler.sendToServer(new PacketServerAction(aim, PacketServerAction.ServerAction.AIM));
    }

    private void switchScopeType(IPlayerData data) {
        this.currentType = this.currentType < 2 ? ++this.currentType : 0;
        data.setScopeType(this.currentType);
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSetScopeVariants(this.currentType, this.currentColor));
    }

    private void switchScopeColor(IPlayerData data) {
        this.currentColor = this.currentColor < 3 ? ++this.currentColor : 0;
        data.setScopeColor(this.currentColor);
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSetScopeVariants(this.currentType, this.currentColor));
    }

    private boolean canSwitchType(ItemStack heldStack) {
        return heldStack.func_77942_o() && heldStack.func_77978_p().func_74762_e("scope") == 1;
    }

    private void handleVehicleControls(boolean forward, boolean back, boolean right, boolean left, EntityPlayer player) {
        if (player.func_184187_bx() instanceof EntityVehicle) {
            EntityVehicle vehicle = (EntityVehicle)player.func_184187_bx();
            vehicle.handleInputs(forward, back, right, left, player);
            PacketHandler.sendToServer(new PacketHandleVehicleInput(forward, back, right, left, vehicle.func_145782_y()));
        }
    }

    private void handleParachuteControls(boolean down, boolean up, boolean right, boolean left, EntityPlayer player) {
        if (player.func_184187_bx() instanceof EntityParachute) {
            EntityParachute chute = (EntityParachute)player.func_184187_bx();
            chute.handleInputs(down, up, right, left);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketHandleParachuteInputs(up, down, right, left));
        }
    }

    static {
        SCOPES.clear();
        HOLOS.clear();
        SCOPES.add(new ResourceLocation("pubgmc:textures/overlay/scope_dot_red.png"));
        SCOPES.add(new ResourceLocation("pubgmc:textures/overlay/scope_dot_green.png"));
        SCOPES.add(new ResourceLocation("pubgmc:textures/overlay/scope_dot_yellow.png"));
        SCOPES.add(new ResourceLocation("pubgmc:textures/overlay/scope_dot_blue.png"));
        SCOPES.add(new ResourceLocation("pubgmc:textures/overlay/scope_arrow_red.png"));
        SCOPES.add(new ResourceLocation("pubgmc:textures/overlay/scope_arrow_green.png"));
        SCOPES.add(new ResourceLocation("pubgmc:textures/overlay/scope_arrow_yellow.png"));
        SCOPES.add(new ResourceLocation("pubgmc:textures/overlay/scope_arrow_blue.png"));
        SCOPES.add(new ResourceLocation("pubgmc:textures/overlay/scope_crosshair_red.png"));
        SCOPES.add(new ResourceLocation("pubgmc:textures/overlay/scope_crosshair_green.png"));
        SCOPES.add(new ResourceLocation("pubgmc:textures/overlay/scope_crosshair_yellow.png"));
        SCOPES.add(new ResourceLocation("pubgmc:textures/overlay/scope_crosshair_blue.png"));
        HOLOS.add(new ResourceLocation("pubgmc:textures/overlay/holo_red.png"));
        HOLOS.add(new ResourceLocation("pubgmc:textures/overlay/holo_green.png"));
        HOLOS.add(new ResourceLocation("pubgmc:textures/overlay/holo_yellow.png"));
        HOLOS.add(new ResourceLocation("pubgmc:textures/overlay/holo_blue.png"));
    }
}

