/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.client;

import com.toma.pubgmc.Pubgmc;
import com.toma.pubgmc.common.capability.IGameData;
import com.toma.pubgmc.util.helper.ImageUtil;
import com.toma.pubgmc.util.math.ZonePos;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Minimap {
    private static final Minimap INSTANCE = new Minimap();
    private final ResourceLocation MAP_ICONS = null;
    private ResourceLocation resourceLocation;
    private DynamicTexture texture;
    public IGameData mapData;

    public static Minimap getMinimap() {
        return INSTANCE;
    }

    public void createMinimap(IGameData gameData, World world) {
        this.mapData = gameData;
        int size = gameData.getMapSize();
        this.texture = new DynamicTexture(size * 2, size * 2);
        int[] data = this.texture.func_110565_c();
        BlockPos center = this.mapData.getMapCenter();
        ZonePos start = new ZonePos(center.func_177958_n() - size, center.func_177952_p() - size);
        Pubgmc.logger.info("Generating new minimap");
        long startTime = System.currentTimeMillis();
        for (int x = 0; x < size * 2; ++x) {
            for (int z = 0; z < size * 2; ++z) {
                int color;
                BlockPos pos = world.func_175672_r(new BlockPos(start.x + (double)x, 256.0, start.z + (double)z));
                IBlockState state = world.func_180495_p(pos.func_177977_b());
                this.texture.func_110565_c()[x * size + z] = color = state.func_177230_c().func_180659_g((IBlockState)state, (IBlockAccess)world, (BlockPos)pos).field_76291_p;
            }
        }
        this.texture.func_110564_a();
        this.resourceLocation = Minecraft.func_71410_x().func_110434_K().func_110578_a("pubgmc/map/game_map", this.texture);
        Pubgmc.logger.info("Minimap generated, took {} ms", (Object)(System.currentTimeMillis() - startTime));
    }

    public void renderMinimap(Minecraft mc, ScaledResolution resolution) {
        if (this.mapData == null) {
            return;
        }
        ImageUtil.drawFullScreenImage(mc, resolution, this.resourceLocation, false);
    }

    public void renderIcon(Minecraft mc, BlockPos pos, IconType iconType) {
        ImageUtil.drawImageWithUV(mc, this.MAP_ICONS, 0, 0, 16.0, 16.0, 0.0, this.getOffset(true, iconType), 1.0, this.getOffset(false, iconType), true);
    }

    public ResourceLocation getMap() {
        return this.resourceLocation;
    }

    private double getOffset(boolean start, IconType iconType) {
        return start ? (double)(iconType.ordinal() * 16) / ((double)IconType.values().length * 16.0) : (double)((iconType.ordinal() + 1) * 16) / ((double)IconType.values().length * 16.0);
    }

    private static enum IconType {
        PLAYER,
        DROP,
        FLARE;

    }
}

