/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.client;

import com.toma.pubgmc.animation.HeldAnimation;
import com.toma.pubgmc.api.Game;
import com.toma.pubgmc.client.layers.LayerGhillie;
import com.toma.pubgmc.common.capability.IGameData;
import com.toma.pubgmc.common.capability.IPlayerData;
import com.toma.pubgmc.common.entity.bot.EntityAIPlayer;
import com.toma.pubgmc.common.items.guns.GunBase;
import com.toma.pubgmc.config.ConfigPMC;
import com.toma.pubgmc.event.client.RenderItemInHandEvent;
import com.toma.pubgmc.event.client.SetupAnglesEvent;
import com.toma.pubgmc.init.PMCRegistry;
import com.toma.pubgmc.world.BlueZone;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RenderHandler {
    private static List<UUID> playersWithAddedRenderLayer = new ArrayList<UUID>();

    private double interpolate(double current, double previous, double partial) {
        return previous + (current - previous) * partial;
    }

    private void resetModelOffset(ModelBiped modelBiped) {
        this.resetModelRendererOffset(modelBiped.field_78116_c);
        this.resetModelRendererOffset(modelBiped.field_178720_f);
        this.resetModelRendererOffset(modelBiped.field_78115_e);
        this.resetModelRendererOffset(modelBiped.field_178723_h);
        this.resetModelRendererOffset(modelBiped.field_178724_i);
        this.resetModelRendererOffset(modelBiped.field_178721_j);
        this.resetModelRendererOffset(modelBiped.field_178722_k);
    }

    private void resetModelRendererOffset(ModelRenderer renderer) {
        renderer.field_82906_o = 0.0f;
        renderer.field_82908_p = 0.0f;
        renderer.field_82907_q = 0.0f;
    }

    private void setThirdPersonAnimations(ModelBiped model, EntityPlayer player, IPlayerData playerData) {
        if (player.func_184614_ca().func_77973_b() instanceof GunBase) {
            boolean smallWeapon;
            boolean bl = smallWeapon = ((GunBase)player.func_184614_ca().func_77973_b()).getWeaponModel().heldAnimation.getHeldStyle() == HeldAnimation.HeldStyle.SMALL;
            if (smallWeapon) {
                if (player.func_70051_ag()) {
                    model.field_178723_h.field_78795_f = (float)Math.toRadians(-110.0);
                } else {
                    boolean aimFlag = playerData.isAiming();
                    model.field_178723_h.field_78795_f = (float)Math.toRadians(aimFlag ? -95.0 : -60.0);
                    model.field_178723_h.field_78796_g = (float)Math.toRadians(-20.0);
                    if (aimFlag) {
                        model.field_178723_h.field_78808_h = (float)Math.toRadians(25.0);
                        model.field_178724_i.field_78795_f = (float)Math.toRadians(-90.0);
                        model.field_178724_i.field_78796_g = (float)Math.toRadians(40.0);
                    }
                }
                return;
            }
            if (player.func_70051_ag()) {
                model.field_178723_h.field_78795_f = (float)Math.toRadians(-50.0);
                model.field_178723_h.field_78796_g = (float)Math.toRadians(-30.0);
                model.field_178723_h.field_78808_h = (float)Math.toRadians(-15.0);
                model.field_178724_i.field_78795_f = (float)Math.toRadians(-50.0);
                model.field_178724_i.field_78796_g = (float)Math.toRadians(40.0);
                return;
            }
            if (playerData.isAiming()) {
                model.field_178723_h.field_78795_f = (float)Math.toRadians(-90.0);
                model.field_178723_h.field_78796_g = (float)Math.toRadians(-15.0);
                model.field_178723_h.field_78808_h = (float)Math.toRadians(20.0);
                model.field_178724_i.field_78795_f = (float)Math.toRadians(-90.0);
                model.field_178724_i.field_78796_g = (float)Math.toRadians(45.0);
                return;
            }
            model.field_178723_h.field_78795_f = (float)Math.toRadians(-70.0);
            model.field_178723_h.field_78796_g = (float)Math.toRadians(-30.0);
            model.field_178724_i.field_78795_f = model.field_178723_h.field_78795_f;
            model.field_178724_i.field_78796_g = (float)Math.toRadians(45.0);
        }
    }

    private void setProne(ModelBiped model) {
        model.field_78116_c.field_82908_p = 1.45f;
        model.field_78115_e.field_78795_f = (float)Math.toRadians(90.0);
        model.field_78115_e.field_82908_p = 1.35f;
        float rotationAngleX = model.field_178723_h.field_78795_f;
        model.field_178724_i.field_78795_f = model.field_178723_h.field_78795_f = -model.field_78115_e.field_78795_f;
        model.field_178723_h.field_78796_g = rotationAngleX * 0.6f + 0.3f;
        model.field_178724_i.field_78796_g = -model.field_178723_h.field_78796_g;
        model.field_178723_h.field_82908_p = 1.2f;
        model.field_178724_i.field_82908_p = 1.2f;
        model.field_178722_k.field_78795_f = model.field_78115_e.field_78795_f;
        model.field_178721_j.field_78795_f = model.field_78115_e.field_78795_f;
        model.field_178722_k.field_82908_p = 0.6f;
        model.field_178721_j.field_82908_p = 0.6f;
        model.field_178721_j.field_82907_q = 0.7f;
        model.field_178722_k.field_82907_q = 0.7f;
        model.field_178722_k.field_78796_g = model.field_178723_h.field_78796_g * 0.4f;
        model.field_178721_j.field_78796_g = -model.field_178723_h.field_78796_g * 0.4f;
    }

    @SubscribeEvent
    public void onSetupAngles(SetupAnglesEvent e) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity entity = e.getEntity();
        ModelBiped model = e.getModel();
        if (entity instanceof EntityAIPlayer) {
            if (((EntityAIPlayer)entity).func_184614_ca().func_77973_b() instanceof GunBase) {
                model.field_178723_h.field_78795_f = -1.55f;
                model.field_178724_i.field_78795_f = -1.55f;
                model.field_178723_h.field_78796_g = -0.35f;
                model.field_178724_i.field_78796_g = 0.8f;
            }
            return;
        }
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        this.resetModelOffset(model);
        ItemStack stack = player.func_184614_ca();
        int perspective = mc.field_71474_y.field_74320_O;
        IPlayerData playerData = IPlayerData.PlayerData.get(player);
        boolean isProne = playerData.isProning();
        if (isProne && (mc.func_175606_aa() != player || perspective > 0)) {
            this.setProne(model);
            return;
        }
        this.setThirdPersonAnimations(model, player, playerData);
    }

    @SubscribeEvent
    public void onRenderItemInHand(RenderItemInHandEvent e) {
        boolean prone;
        if (e.entity instanceof EntityPlayer && (prone = IPlayerData.PlayerData.get((EntityPlayer)e.entity).isProning())) {
            GlStateManager.func_179109_b((float)0.0f, (float)-1.15f, (float)0.0f);
        }
    }

    @SubscribeEvent
    public void onFOVChanged(FOVUpdateEvent e) {
        EntityPlayer player = e.getEntity();
        IPlayerData data = (IPlayerData)player.getCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null);
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        if (data.isAiming()) {
            ItemStack stack = player.func_184614_ca();
            if (stack.func_77973_b() instanceof GunBase) {
                int scope = stack.func_77973_b() == PMCRegistry.PMCItems.VSS ? 4 : (stack.func_77942_o() ? stack.func_77978_p().func_74762_e("scope") : 0);
                switch (scope) {
                    case 1: 
                    case 2: {
                        settings.field_74334_X = 45.0f;
                        break;
                    }
                    case 3: {
                        settings.field_74334_X = 35.0f;
                        break;
                    }
                    case 4: {
                        settings.field_74334_X = 25.0f;
                        break;
                    }
                    case 5: {
                        settings.field_74334_X = 10.0f;
                        break;
                    }
                    case 6: {
                        settings.field_74334_X = 3.0f;
                    }
                }
            }
        } else if (settings.field_74334_X < 70.0f) {
            settings.field_74334_X = 70.0f;
        }
    }

    @SubscribeEvent
    public void renderBlueZone(RenderWorldLastEvent e) {
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        IGameData gameData = (IGameData)world.getCapability(IGameData.GameDataProvider.GAMEDATA, null);
        Game game = gameData.getCurrentGame();
        if (!gameData.isPlaying() || gameData.isInactiveGame()) {
            return;
        }
        BlueZone zone = game.zone;
        if (zone == null) {
            return;
        }
        EntityPlayerSP player = mc.field_71439_g;
        double maxClientRenderDist = mc.field_71474_y.field_151451_c * 16;
        if (this.isCloseToBorder(player, zone, maxClientRenderDist)) {
            double partialTicks = e.getPartialTicks();
            double interpolatedPlayerX = this.interpolate(player.field_70165_t, player.field_70142_S, partialTicks);
            double interpolatedPlayerY = this.interpolate(player.field_70163_u, player.field_70137_T, partialTicks);
            double interpolatedPlayerZ = this.interpolate(player.field_70161_v, player.field_70136_U, partialTicks);
            int clientZoneColor = ConfigPMC.client.other.zoneColor;
            float a = 0.25f;
            float r = (float)(clientZoneColor >> 16 & 0xFF) / 255.0f;
            float g = (float)(clientZoneColor >> 8 & 0xFF) / 255.0f;
            float b = (float)(clientZoneColor & 0xFF) / 255.0f;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferBuilder = tessellator.func_178180_c();
            GlStateManager.func_179147_l();
            GlStateManager.func_179090_x();
            GlStateManager.func_179129_p();
            bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            bufferBuilder.func_178969_c(-interpolatedPlayerX, -interpolatedPlayerY, -interpolatedPlayerZ);
            double minRenderPosZ = Math.max(Math.floor(interpolatedPlayerZ - maxClientRenderDist), zone.minZ(partialTicks));
            double maxRenderPosZ = Math.min(Math.ceil(interpolatedPlayerZ + maxClientRenderDist), zone.maxZ(partialTicks));
            double minRenderPosX = Math.max(Math.floor(interpolatedPlayerX - maxClientRenderDist), zone.minX(partialTicks));
            double maxRenderPosX = Math.min(Math.ceil(interpolatedPlayerX + maxClientRenderDist), zone.maxX(partialTicks));
            if (interpolatedPlayerX > zone.maxX(partialTicks) - maxClientRenderDist) {
                bufferBuilder.func_181662_b(zone.maxX(partialTicks), 256.0, minRenderPosZ).func_181666_a(r, g, b, a).func_181675_d();
                bufferBuilder.func_181662_b(zone.maxX(partialTicks), 256.0, maxRenderPosZ).func_181666_a(r, g, b, a).func_181675_d();
                bufferBuilder.func_181662_b(zone.maxX(partialTicks), 0.0, maxRenderPosZ).func_181666_a(r, g, b, a).func_181675_d();
                bufferBuilder.func_181662_b(zone.maxX(partialTicks), 0.0, minRenderPosZ).func_181666_a(r, g, b, a).func_181675_d();
            }
            if (interpolatedPlayerX < zone.minX(partialTicks) + maxClientRenderDist) {
                bufferBuilder.func_181662_b(zone.minX(partialTicks), 256.0, minRenderPosZ).func_181666_a(r, g, b, a).func_181675_d();
                bufferBuilder.func_181662_b(zone.minX(partialTicks), 256.0, maxRenderPosZ).func_181666_a(r, g, b, a).func_181675_d();
                bufferBuilder.func_181662_b(zone.minX(partialTicks), 0.0, maxRenderPosZ).func_181666_a(r, g, b, a).func_181675_d();
                bufferBuilder.func_181662_b(zone.minX(partialTicks), 0.0, minRenderPosZ).func_181666_a(r, g, b, a).func_181675_d();
            }
            if (interpolatedPlayerZ > zone.maxZ(partialTicks) - maxClientRenderDist) {
                bufferBuilder.func_181662_b(minRenderPosX, 256.0, zone.maxZ(partialTicks)).func_181666_a(r, g, b, a).func_181675_d();
                bufferBuilder.func_181662_b(maxRenderPosX, 256.0, zone.maxZ(partialTicks)).func_181666_a(r, g, b, a).func_181675_d();
                bufferBuilder.func_181662_b(maxRenderPosX, 0.0, zone.maxZ(partialTicks)).func_181666_a(r, g, b, a).func_181675_d();
                bufferBuilder.func_181662_b(minRenderPosX, 0.0, zone.maxZ(partialTicks)).func_181666_a(r, g, b, a).func_181675_d();
            }
            if (interpolatedPlayerZ < zone.minZ(partialTicks) + maxClientRenderDist) {
                bufferBuilder.func_181662_b(minRenderPosX, 256.0, zone.minZ(partialTicks)).func_181666_a(r, g, b, a).func_181675_d();
                bufferBuilder.func_181662_b(maxRenderPosX, 256.0, zone.minZ(partialTicks)).func_181666_a(r, g, b, a).func_181675_d();
                bufferBuilder.func_181662_b(maxRenderPosX, 0.0, zone.minZ(partialTicks)).func_181666_a(r, g, b, a).func_181675_d();
                bufferBuilder.func_181662_b(minRenderPosX, 0.0, zone.minZ(partialTicks)).func_181666_a(r, g, b, a).func_181675_d();
            }
            tessellator.func_78381_a();
            bufferBuilder.func_178969_c(0.0, 0.0, 0.0);
            GlStateManager.func_179098_w();
            GlStateManager.func_179089_o();
            GlStateManager.func_179084_k();
        }
    }

    @SubscribeEvent
    public void onPlayerRenderPost(RenderPlayerEvent.Post e) {
        EntityPlayer player = e.getEntityPlayer();
        if (playersWithAddedRenderLayer.contains(player.func_110124_au())) {
            return;
        }
        playersWithAddedRenderLayer.add(player.func_110124_au());
        e.getRenderer().func_177094_a((LayerRenderer)new LayerGhillie((RenderLivingBase<?>)e.getRenderer()));
    }

    public void renderHand(RenderHandEvent e) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        ItemStack stack = player.func_184614_ca();
        if (!(stack.func_77973_b() instanceof GunBase)) {
            IPlayerData data = (IPlayerData)player.getCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null);
            boolean aim = data.isAiming();
            RenderManager manager = mc.func_175598_ae();
            Render abstractClientPlayerRender = manager.func_78713_a((Entity)player);
            RenderPlayer renderPlayer = (RenderPlayer)abstractClientPlayerRender;
            GlStateManager.func_179094_E();
            GlStateManager.func_179129_p();
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)92.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)41.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)-0.3f, (float)-1.1f, (float)0.45f);
            renderPlayer.func_177139_c((AbstractClientPlayer)mc.field_71439_g);
            GlStateManager.func_179089_o();
            GlStateManager.func_179121_F();
        }
    }

    public void renderHand() {
    }

    public float prepareScale(EntityPlayer player, float partial) {
        GlStateManager.func_179091_B();
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)1.9f, (float)1.9f, (float)1.9f);
        GlStateManager.func_179109_b((float)0.0f, (float)-1.5f, (float)0.0f);
        return 0.0625f;
    }

    public float normalizeAndInterpolateRotation(float prev, float current, float partial) {
        float f;
        for (f = current - prev; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return prev + partial * f;
    }

    public boolean isCloseToBorder(EntityPlayerSP player, BlueZone zone, double maxDist) {
        return player.field_70165_t >= zone.maxX(1.0) - maxDist || player.field_70165_t <= zone.minX(1.0) + maxDist || player.field_70161_v >= zone.maxZ(1.0) - maxDist || player.field_70161_v <= zone.minZ(1.0) + maxDist;
    }
}

