/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.client.gui;

import com.toma.pubgmc.client.util.PageButton;
import com.toma.pubgmc.client.util.RecipeButton;
import com.toma.pubgmc.common.container.ContainerGunWorkbench;
import com.toma.pubgmc.common.tileentity.TileEntityGunWorkbench;
import com.toma.pubgmc.network.PacketHandler;
import com.toma.pubgmc.network.server.PacketCraft;
import com.toma.pubgmc.network.server.PacketUpdateWorkbench;
import com.toma.pubgmc.util.recipes.PMCRecipe;
import com.toma.pubgmc.util.recipes.RecipeRegistry;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;

public class GuiGunWorkbench
extends GuiContainer {
    private static final ResourceLocation TEXTURES = new ResourceLocation("pubgmc:textures/gui/gun_workbench.png");
    private final InventoryPlayer player;
    private final TileEntityGunWorkbench tileentity;
    private int timeSinceCraft;

    public GuiGunWorkbench(TileEntityGunWorkbench te, InventoryPlayer playerInv) {
        super((Container)new ContainerGunWorkbench(te, playerInv));
        this.tileentity = te;
        this.player = playerInv;
        this.field_146999_f = 176;
        this.field_147000_g = 193;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.updateButtons();
    }

    public void updateButtons() {
        List<PMCRecipe> list = TileEntityGunWorkbench.RECIPES.get(this.tileentity.selectedCat.ordinal());
        this.field_146292_n.clear();
        this.field_146292_n.add(this.createPageButton(0, this.field_147003_i + 8, this.field_147009_r + 85, false));
        this.field_146292_n.add(this.createPageButton(1, this.field_147003_i + 90, this.field_147009_r + 85, true));
        this.field_146292_n.add(this.createPageButton(2, this.field_147003_i + 120, this.field_147009_r + 85, false, list));
        this.field_146292_n.add(this.createPageButton(3, this.field_147003_i + 150, this.field_147009_r + 85, true, list));
        int index = 3;
        for (int i = this.tileentity.selectedIndex * 4 + 3; i >= this.tileentity.selectedIndex * 4; --i) {
            if (i >= list.size()) continue;
            this.field_146292_n.add(new RecipeButton(this.field_146292_n.size(), this.field_147003_i + 45, this.field_147009_r + index * 18 + 8, list.get(i), this.tileentity));
            --index;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.field_146297_k.field_71466_p.func_78276_b(this.tileentity.selectedCat.getCategoryName(), this.field_147003_i + 26, this.field_147009_r + 90, 0x404040);
        this.func_191948_b(mouseX, mouseY);
        if (this.timeSinceCraft > 0) {
            --this.timeSinceCraft;
            if (this.timeSinceCraft == 0) {
                this.updateButtons();
            }
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURES);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button instanceof RecipeButton) {
            RecipeButton btn = (RecipeButton)button;
            PMCRecipe recipe = btn.recipe;
            if (btn.active && this.timeSinceCraft == 0) {
                PacketHandler.sendToServer(new PacketCraft(this.tileentity.func_174877_v(), RecipeRegistry.RECIPES.indexOf(recipe)));
                this.updateButtons();
                this.timeSinceCraft = Minecraft.func_175610_ah();
            }
        } else if (button instanceof PageButton) {
            PageButton btn = (PageButton)button;
            switch (btn.field_146127_k) {
                case 0: 
                case 1: {
                    PMCRecipe.CraftingCategory cat = btn.isRight ? PMCRecipe.CraftingCategory.getNextCategory(this.tileentity.selectedCat) : PMCRecipe.CraftingCategory.getPrevCategory(this.tileentity.selectedCat);
                    int page = 0;
                    this.update(page, cat);
                    this.updateButtons();
                    break;
                }
                case 2: 
                case 3: {
                    List<PMCRecipe> list = TileEntityGunWorkbench.RECIPES.get(this.tileentity.selectedCat.ordinal());
                    int currentPage = btn.field_146125_m ? (btn.isRight ? this.tileentity.selectedIndex + 1 : this.tileentity.selectedIndex - 1) : this.tileentity.selectedIndex;
                    this.update(currentPage, this.tileentity.selectedCat);
                    this.updateButtons();
                    break;
                }
            }
            if (btn.field_146125_m) {
                btn.func_146113_a(this.field_146297_k.func_147118_V());
            }
        }
    }

    public List<GuiButton> getButtonList() {
        return this.field_146292_n;
    }

    private PageButton createPageButton(int index, int x, int y, boolean right, List<PMCRecipe> recipeCollection) {
        boolean flag;
        PageButton button = new PageButton(index, x, y, right);
        int i = this.tileentity.selectedIndex + 1;
        button.field_146125_m = flag = right ? recipeCollection.size() > i * 4 : this.tileentity.selectedIndex > 0;
        return button;
    }

    private PageButton createPageButton(int index, int x, int y, boolean right) {
        PageButton button = new PageButton(index, x, y, right);
        button.field_146125_m = true;
        return button;
    }

    private void update(int page, PMCRecipe.CraftingCategory category) {
        PacketHandler.sendToServer(new PacketUpdateWorkbench(this.tileentity, category, page));
        this.tileentity.selectedIndex = page;
        this.tileentity.selectedCat = category;
    }
}

