/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.client.gui;

import com.toma.pubgmc.client.gui.GuiScreenCentered;
import com.toma.pubgmc.common.capability.IWorldData;
import com.toma.pubgmc.common.items.guns.GunBase;
import com.toma.pubgmc.network.PacketHandler;
import com.toma.pubgmc.network.server.PacketUpdateLootData;
import com.toma.pubgmc.util.helper.ImageUtil;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class GuiLootSetup
extends GuiScreenCentered {
    private static final ResourceLocation TEXTURE = new ResourceLocation("pubgmc:textures/gui/lootsetup.png");
    private final DecimalFormat decFormat = new DecimalFormat("##,##0.00");
    private IWorldData data;
    private ChanceLabel label;

    public GuiLootSetup(IWorldData lootData) {
        this.field_146297_k = Minecraft.func_71410_x();
        if (lootData == null) {
            this.field_146297_k.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Couldn't receive world data for gui"));
            this.field_146297_k.func_147108_a(null);
            return;
        }
        if (this.field_146297_k.field_71439_g.func_184840_I() < 2) {
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You don't have permission to edit loot data"));
            return;
        }
        this.data = lootData;
    }

    public void func_73866_w_() {
        this.setDimension(176, 221).calculateGuiPosition();
        this.field_146292_n.add(new BTNLootBool(0, this.guiLeft + 90, this.guiTop + 10, 75, 20, this.data.hasAirdropWeapons()));
        this.field_146292_n.add(new BTNLootBool(1, this.guiLeft + 90, this.guiTop + 35, 75, 20, this.data.isAmmoLootEnabled()));
        this.field_146292_n.add(new BTNLootBool(2, this.guiLeft + 90, this.guiTop + 60, 75, 20, this.data.isRandomAmmoCountEnabled()));
        this.field_146292_n.add(new ChanceModifierButton(this.data, 3, true, this.guiLeft + 90, this.guiTop + 85));
        this.field_146292_n.add(new ChanceModifierButton(this.data, 4, false, this.guiLeft + 145, this.guiTop + 85));
        this.label = new ChanceLabel(this, this.guiLeft + 110, this.guiTop + 85, 35, 20);
        int j = 0;
        for (int i = 0; i < GunBase.GunType.values().length; ++i) {
            GunBase.GunType type = GunBase.GunType.values()[i];
            if (type == GunBase.GunType.LMG) continue;
            this.field_146292_n.add(new BTNWeaponType(this, type, j % 2 == 0 ? this.guiLeft + 10 : this.guiLeft + 90, this.guiTop + 125 + j / 2 * 25 + 10));
            ++j;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.getGuiWidth(), this.getGuiHeight());
        this.field_146297_k.field_71466_p.func_78276_b("Airdrop guns", this.guiLeft + 10, this.guiTop + 15, 0x3F3F3F);
        this.field_146297_k.field_71466_p.func_78276_b("Ammo", this.guiLeft + 10, this.guiTop + 40, 0x3F3F3F);
        this.field_146297_k.field_71466_p.func_78276_b("Random ammo", this.guiLeft + 10, this.guiTop + 65, 0x3F3F3F);
        this.field_146297_k.field_71466_p.func_78276_b("Chance", this.guiLeft + 10, this.guiTop + 90, 0x3F3F3F);
        this.field_146297_k.field_71466_p.func_78276_b("Weapon classes:", this.guiLeft + 10, this.guiTop + 115, 0x3F3F3F);
        this.label.draw(this.field_146297_k, mouseX, mouseY);
        String chanceAmount = this.decFormat.format(this.data.getLootChanceMultiplier());
        int chancePosModified = (this.label.width - this.field_146297_k.field_71466_p.func_78256_a(chanceAmount)) / 2;
        this.field_146297_k.field_71466_p.func_78276_b(chanceAmount, this.guiLeft + 111 + chancePosModified, this.guiTop + 91, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof BTNWeaponType) {
            ((BTNWeaponType)button).buttonClicked();
        } else if (button instanceof BTNLootBool) {
            ((BTNLootBool)button).buttonClicked();
            switch (button.field_146127_k) {
                case 0: {
                    this.data.toggleAirdropWeapons(!this.data.hasAirdropWeapons());
                    break;
                }
                case 1: {
                    this.data.toggleAmmoLoot(!this.data.isAmmoLootEnabled());
                    break;
                }
                case 2: {
                    this.data.toggleRandomAmmoCount(!this.data.isRandomAmmoCountEnabled());
                }
            }
        } else if (button instanceof BTNClickable) {
            ((BTNClickable)button).buttonClicked();
        }
    }

    public void func_146281_b() {
        PacketHandler.sendToServer(new PacketUpdateLootData((NBTTagCompound)this.data.serializeNBT()));
    }

    private static interface BTNClickable {
        public void buttonClicked();
    }

    private class BTNWeaponType
    extends BTNLootBool {
        private final GunBase.GunType weaponType;
        private final GuiLootSetup parent;

        public BTNWeaponType(GuiLootSetup parent, GunBase.GunType type, int x, int y) {
            super(type.ordinal(), x, y, 75, 20, parent.data.getWeaponList().contains((Object)type));
            this.weaponType = type;
            this.parent = parent;
            this.field_146126_j = type.name().toUpperCase();
        }

        @Override
        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                FontRenderer fontrenderer = mc.field_71466_p;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                ImageUtil.drawImageWithUV(mc, TEXTURE, this.field_146128_h, this.field_146129_i, this.field_146120_f, this.field_146121_g, 0.6875, this.field_146123_n ? 0.078125 : 0.0, 0.98046875, this.field_146123_n ? 0.15625 : 0.078125, true);
                int color = this.buttonState ? 39680 : 0xC20000;
                this.func_73732_a(fontrenderer, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, color);
            }
        }

        @Override
        public void buttonClicked() {
            List<GunBase.GunType> wepList = this.parent.data.getWeaponList();
            if (wepList.contains((Object)this.weaponType)) {
                this.parent.data.getWeaponList().remove((Object)this.weaponType);
            } else {
                this.parent.data.getWeaponList().add(this.weaponType);
            }
            this.buttonState = this.parent.data.getWeaponList().contains((Object)this.weaponType);
        }

        public GunBase.GunType getWeaponType() {
            return this.weaponType;
        }
    }

    private class BTNLootBool
    extends GuiButton
    implements BTNClickable {
        protected boolean buttonState;

        public BTNLootBool(int index, int x, int y, int width, int height, boolean initialVal) {
            super(index, x, y, width, height, "");
            this.buttonState = initialVal;
            this.field_146126_j = initialVal ? "enabled" : "disabled";
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                FontRenderer fontrenderer = mc.field_71466_p;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                ImageUtil.drawImageWithUV(mc, TEXTURE, this.field_146128_h, this.field_146129_i, this.field_146120_f, this.field_146121_g, 0.6875, this.field_146123_n ? 0.078125 : 0.0, 0.98046875, this.field_146123_n ? 0.15625 : 0.078125, true);
                int color = this.buttonState ? 39680 : 0xC20000;
                this.func_73732_a(fontrenderer, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, color);
            }
        }

        @Override
        public void buttonClicked() {
            this.buttonState = !this.buttonState;
            this.field_146126_j = this.buttonState ? "enabled" : "disabled";
        }

        public boolean getButtonState() {
            return this.buttonState;
        }
    }

    private class ChanceModifierButton
    extends GuiButton
    implements BTNClickable {
        private final boolean isLeft;
        private final IWorldData ins;

        public ChanceModifierButton(IWorldData instance, int index, boolean left, int x, int y) {
            super(index, x, y, 20, 20, "");
            this.isLeft = left;
            this.ins = instance;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                FontRenderer fontrenderer = mc.field_71466_p;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                ImageUtil.drawImageWithUV(mc, TEXTURE, this.field_146128_h, this.field_146129_i, this.field_146120_f, this.field_146121_g, this.isLeft ? 0.6875 : 0.90234375, this.field_146123_n ? 0.234375 : 0.15625, this.isLeft ? 0.765625 : 0.98046875, this.field_146123_n ? 0.3125 : 0.234375, true);
            }
        }

        @Override
        public void buttonClicked() {
            double amount;
            double d = GuiScreen.func_146272_n() ? 0.25 : (amount = GuiScreen.func_146271_m() ? 0.1 : 1.0);
            if (this.isLeft) {
                this.ins.setLootChanceMultiplier(this.decrease(amount));
            } else {
                this.ins.setLootChanceMultiplier(this.increase(amount));
            }
        }

        private double decrease(double amount) {
            if (this.ins.getLootChanceMultiplier() - amount < 0.0) {
                return 0.0;
            }
            return this.ins.getLootChanceMultiplier() - amount;
        }

        private double increase(double amount) {
            if (this.ins.getLootChanceMultiplier() + amount > 99.99) {
                return 99.99;
            }
            return this.ins.getLootChanceMultiplier() + amount;
        }
    }

    private class ChanceLabel {
        private int x;
        private int y;
        private int width;
        private int height;
        private boolean hovered;
        private int hoverTime;
        private int fpsCounter;
        private GuiLootSetup parent;

        public ChanceLabel(GuiLootSetup parent, int x, int y, int width, int height) {
            this.parent = parent;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.hoverTime = 0;
            this.fpsCounter = Minecraft.func_175610_ah();
        }

        public void draw(Minecraft mc, int mouseX, int mouseY) {
            this.hovered = mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= this.y && mouseY <= this.y + this.height;
            this.updateCounters();
            ImageUtil.drawImageWithUV(mc, TEXTURE, this.x, this.y, this.width, this.height, 0.765625, this.hovered ? 0.234375 : 0.15625, 0.90234375, this.hovered ? 0.3125 : 0.234375, false);
            if (this.hovered && this.hoverTime < 15) {
                this.drawHoveredText(mc, mouseX, mouseY);
            }
        }

        private void drawHoveredText(Minecraft mc, int mouseX, int mouseY) {
            int x = mouseX + 243 > this.parent.field_146294_l ? mouseX - 243 : mouseX + 3;
            FontRenderer font = mc.field_71466_p;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
            ImageUtil.drawImageWithUV(mc, TEXTURE, x, mouseY + 3, 240.0, 86.0, 0.6875, 0.3125, 0.98046875, 0.390625, false);
            mc.field_71466_p.func_78276_b("Weapon spawn chances (tier 1/tier 2/tier 3)", x + 3, mouseY + 8, 0xFFFFFF);
            mc.field_71466_p.func_78276_b(this.getGunDescSpawnChanceString("Flare gun", 0.5), x + 3, mouseY + 18, 0xFFFFFF);
            mc.field_71466_p.func_78276_b(this.getGunDescSpawnChanceString("Snipers", 2.0), x + 3, mouseY + 28, 0xFFFFFF);
            mc.field_71466_p.func_78276_b(this.getGunDescSpawnChanceString("DMRs", 3.0), x + 3, mouseY + 38, 0xFFFFFF);
            mc.field_71466_p.func_78276_b(this.getGunDescSpawnChanceString("Assault rifles", 15.0), x + 3, mouseY + 48, 0xFFFFFF);
            mc.field_71466_p.func_78276_b(this.getGunDescSpawnChanceString("Sub-machine guns", 20.0), x + 3, mouseY + 58, 0xFFFFFF);
            mc.field_71466_p.func_78276_b(this.getGunDescSpawnChanceString("Shotguns", 35.0), x + 3, mouseY + 68, 0xFFFFFF);
            mc.field_71466_p.func_78276_b(this.getGunDescSpawnChanceString("Pistols", 25.0), x + 3, mouseY + 78, 0xFFFFFF);
            GlStateManager.func_179121_F();
        }

        private String getGunDescSpawnChanceString(String className, double baseAmount) {
            double d = this.parent.data.getLootChanceMultiplier();
            return className + ": " + TextFormatting.RED + GuiLootSetup.this.decFormat.format(baseAmount * d) + "%" + TextFormatting.WHITE + "/" + TextFormatting.YELLOW + GuiLootSetup.this.decFormat.format(baseAmount * (double)1.4f * d) + "%" + TextFormatting.WHITE + "/" + TextFormatting.GREEN + GuiLootSetup.this.decFormat.format(baseAmount * 2.0 * d) + "%";
        }

        private void updateCounters() {
            if (this.hovered) {
                --this.fpsCounter;
                if (this.fpsCounter <= 0) {
                    ++this.hoverTime;
                    this.fpsCounter = Minecraft.func_175610_ah();
                }
            } else {
                this.fpsCounter = Minecraft.func_175610_ah();
                this.hoverTime = 0;
            }
        }
    }
}

