/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.client.renderer.entity;

import com.toma.pubgmc.client.models.vehicles.ModelVehicle;
import com.toma.pubgmc.common.entity.EntityVehicle;
import com.toma.pubgmc.util.PUBGMCUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

public abstract class RenderVehicle<V extends EntityVehicle>
extends Render<V> {
    protected static final Random RNG = new Random();
    protected final List<ResourceLocation> textures = new ArrayList<ResourceLocation>();
    private ModelVehicle vehicleModel;
    private float[] scaling = new float[]{1.0f, 1.0f, 1.0f};
    private double[] translation = new double[]{0.0, 0.0, 0.0};
    private ResourceLocation currentTexture;

    public RenderVehicle(RenderManager manager) {
        super(manager);
        this.initializeModelRendering(this.getVehicleModel());
    }

    public abstract ModelVehicle getVehicleModel();

    public void scaleModel(float scale) {
        for (int i = 0; i < this.scaling.length; ++i) {
            this.scaling[i] = scale;
        }
    }

    public void scaleModel(float x, float y, float z) {
        this.scaling[0] = x;
        this.scaling[1] = y;
        this.scaling[2] = z;
    }

    public void translateModel(double x, double y, double z) {
        this.translation[0] = x;
        this.translation[1] = y;
        this.translation[2] = z;
    }

    protected ResourceLocation getEntityTexture(V entity) {
        if (this.currentTexture == null) {
            this.initTexture(entity);
        }
        return this.currentTexture;
    }

    public void doRender(V entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (!this.isModelReady()) {
            this.initializeModelRendering(this.getVehicleModel());
        }
        if (this.textures.isEmpty()) {
            this.initTextures(entity);
        }
        GlStateManager.func_179094_E();
        this.func_180548_c((Entity)entity);
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)this.scaling[0], (float)this.scaling[1], (float)this.scaling[2]);
        GlStateManager.func_179137_b((double)this.translation[0], (double)this.translation[1], (double)this.translation[2]);
        float f0 = PUBGMCUtil.interpolate(((EntityVehicle)((Object)entity)).field_70126_B, ((EntityVehicle)((Object)entity)).field_70177_z, partialTicks);
        GlStateManager.func_179114_b((float)f0, (float)0.0f, (float)1.0f, (float)0.0f);
        this.getVehicleModel().render(((EntityVehicle)((Object)entity)).turnModifier);
        GlStateManager.func_179121_F();
        super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
    }

    protected ResourceLocation defaultTexture() {
        return new ResourceLocation("");
    }

    private boolean isModelReady() {
        return this.vehicleModel != null;
    }

    private void initializeModelRendering(ModelVehicle modelToRender) {
        this.vehicleModel = modelToRender;
    }

    private void initTexture(V entity) {
        if (this.textures.isEmpty()) {
            this.initTextures(entity);
        }
        this.currentTexture = this.textures.get(((EntityVehicle)((Object)entity)).getColorVariantIndex());
    }

    protected void initTextures(V entity) {
        this.textures.clear();
        String prefix = "pubgmc:textures/vehicle/";
        if (((EntityVehicle)((Object)entity)).getTextureVariants() != null) {
            for (int i = 0; i < ((EntityVehicle)((Object)entity)).getTextureVariants().length; ++i) {
                this.tryToAdd(new ResourceLocation("pubgmc:textures/vehicle/" + ((EntityVehicle)((Object)entity)).getTextureVariants()[i] + ".png"));
            }
        } else {
            this.tryToAdd(this.defaultTexture());
        }
    }

    private void tryToAdd(ResourceLocation loc) {
        if (!this.textures.contains(loc)) {
            this.textures.add(loc);
        }
    }
}

