/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.client.renderer.throwable;

import com.toma.pubgmc.common.entity.throwables.EntityThrowableExplodeable;
import com.toma.pubgmc.common.items.ItemExplodeable;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class RenderThrowable<E extends EntityThrowableExplodeable, I extends ItemExplodeable>
extends Render<E> {
    private final I item;
    private final ItemStack stack;
    @Nullable
    private final IRenderAction<E, I> renderAction;

    public RenderThrowable(RenderManager manager, I item) {
        this(manager, item, null);
    }

    public RenderThrowable(RenderManager manager, I item, @Nullable IRenderAction action) {
        super(manager);
        this.item = item;
        this.renderAction = action;
        this.stack = new ItemStack(this.item);
    }

    public void doRender(E entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (entity.func_82150_aj()) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        if (this.renderAction != null) {
            this.renderAction.onRender(entity, this.item, x, y, z, partialTicks);
        }
        GlStateManager.func_179152_a((float)0.6f, (float)0.6f, (float)0.6f);
        GlStateManager.func_179109_b((float)-0.5f, (float)0.0f, (float)-0.5f);
        float rotationProgress = ((EntityThrowableExplodeable)((Object)entity)).lastRotation + (((EntityThrowableExplodeable)((Object)entity)).rotation - ((EntityThrowableExplodeable)((Object)entity)).lastRotation) * partialTicks;
        GlStateManager.func_179114_b((float)rotationProgress, (float)1.0f, (float)0.5f, (float)1.0f);
        this.func_110776_a(TextureMap.field_110575_b);
        GlStateManager.func_179140_f();
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(this.stack);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (EnumFacing facing : EnumFacing.values()) {
            RenderThrowable.renderQuads(bufferBuilder, model.func_188616_a(null, facing, 0L));
        }
        RenderThrowable.renderQuads(bufferBuilder, model.func_188616_a(null, null, 0L));
        tessellator.func_78381_a();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
        super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
    }

    @Nullable
    protected ResourceLocation getEntityTexture(E entity) {
        return null;
    }

    protected static void renderQuads(BufferBuilder buffer, List<BakedQuad> quads) {
        int j = quads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad quad = quads.get(i);
            LightUtil.renderQuadColor((BufferBuilder)buffer, (BakedQuad)quad, (int)-1);
        }
    }

    @FunctionalInterface
    public static interface IRenderAction<E extends EntityThrowableExplodeable, I extends ItemExplodeable> {
        public void onRender(E var1, I var2, double var3, double var5, double var7, float var9);
    }
}

