/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.common;

import com.toma.pubgmc.common.blocks.PMCBlock;
import com.toma.pubgmc.util.IBuilder;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBuilder
implements IBuilder<PMCBlock> {
    protected String name;
    protected Material blockMaterial;
    protected SoundType soundType;
    protected BlockRenderLayer renderLayer;
    protected MapColor mapColor;
    protected boolean opaque;
    protected boolean fullCube;
    protected float lightValue = 0.0f;
    protected AxisAlignedBB[] boxes;
    protected boolean isGlass = false;
    protected String[] description = null;

    protected BlockBuilder() {
    }

    public static BlockBuilder create(String name, Material material) {
        BlockBuilder builder = new BlockBuilder();
        builder.name = name;
        builder.blockMaterial = material;
        builder.initialize();
        return builder;
    }

    private void initialize() {
        this.mapColor = this.blockMaterial.func_151565_r();
        this.renderLayer = BlockRenderLayer.SOLID;
        this.opaque = true;
        this.fullCube = true;
        this.boxes = new AxisAlignedBB[]{Block.field_185505_j, Block.field_185505_j};
    }

    public BlockBuilder renderType(BlockRenderLayer layerRender) {
        this.renderLayer = layerRender;
        return this;
    }

    public BlockBuilder mapColor(MapColor color) {
        this.mapColor = color;
        return this;
    }

    public BlockBuilder transparency(boolean opaque, boolean fullCube) {
        this.opaque = opaque;
        this.fullCube = fullCube;
        return this;
    }

    public BlockBuilder light(float light) {
        this.lightValue = light;
        return this;
    }

    public BlockBuilder aabb(AxisAlignedBB aabb) {
        this.boxes = new AxisAlignedBB[]{aabb, aabb};
        return this;
    }

    public BlockBuilder aabb(AxisAlignedBB bounding, AxisAlignedBB collision) {
        this.boxes = new AxisAlignedBB[]{bounding, collision};
        return this;
    }

    public BlockBuilder soundType(SoundType type) {
        this.soundType = type;
        return this;
    }

    public BlockBuilder setTransparent() {
        this.opaque = false;
        this.fullCube = false;
        return this;
    }

    public BlockBuilder setGlass() {
        this.setTransparent();
        this.renderLayer = BlockRenderLayer.TRANSLUCENT;
        this.isGlass = true;
        return this;
    }

    public BlockBuilder description(String ... strings) {
        this.description = strings;
        return this;
    }

    @Override
    public PMCBlock build() {
        this.checkFloat(this.lightValue, 0.0f, 1.0f);
        this.checkNotNull(this.soundType);
        PMCBlock builtBlock = new PMCBlock(this.name, this.blockMaterial){

            public boolean func_149662_c(IBlockState state) {
                return BlockBuilder.this.opaque;
            }

            public boolean func_149686_d(IBlockState state) {
                return BlockBuilder.this.fullCube;
            }

            public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
                return BlockBuilder.this.mapColor;
            }

            public BlockRenderLayer func_180664_k() {
                return BlockBuilder.this.renderLayer;
            }

            public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
                return BlockBuilder.this.boxes[0];
            }

            public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
                return BlockBuilder.this.boxes[1];
            }

            public SoundType getSoundType(IBlockState state, World world, BlockPos pos, Entity entity) {
                return BlockBuilder.this.soundType;
            }

            public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
                return BlockBuilder.this.isGlass ? (blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() == this ? false : super.func_176225_a(blockState, blockAccess, pos, side)) : super.func_176225_a(blockState, blockAccess, pos, side);
            }

            @Override
            public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
                if (BlockBuilder.this.description != null) {
                    tooltip.addAll(Arrays.asList(BlockBuilder.this.description));
                }
            }
        };
        builtBlock.func_149715_a(this.lightValue);
        return builtBlock;
    }
}

