/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.common;

import com.toma.pubgmc.common.capability.IGameData;
import com.toma.pubgmc.common.capability.IPlayerData;
import com.toma.pubgmc.common.capability.IWorldData;
import com.toma.pubgmc.common.entity.EntityVehicle;
import com.toma.pubgmc.common.entity.throwables.EntityThrowableExplodeable;
import com.toma.pubgmc.common.items.ItemExplodeable;
import com.toma.pubgmc.common.items.guns.GunBase;
import com.toma.pubgmc.config.ConfigPMC;
import com.toma.pubgmc.event.LandmineExplodeEvent;
import com.toma.pubgmc.init.PMCRegistry;
import com.toma.pubgmc.network.PacketHandler;
import com.toma.pubgmc.network.sp.PacketGetConfigFromServer;
import com.toma.pubgmc.network.sp.PacketLoadConfig;
import com.toma.pubgmc.util.PUBGMCUtil;
import com.toma.pubgmc.util.handlers.CustomDateEvents;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class CommonEvents {
    private double prevDiameter = 0.0;
    public static final HashMap<UUID, NBTTagCompound> CONFIGS = new HashMap();

    private static void handleUpdateResults(ForgeVersion.CheckResult result, EntityPlayer player) {
        switch (result.status) {
            case AHEAD: {
                CommonEvents.sendMessage(player, "[PUBGMC] It appears you're using unofficial version, expect bugs ;)", TextFormatting.AQUA);
                break;
            }
            case UP_TO_DATE: {
                CommonEvents.sendMessage(player, "You have the newest version of PUBGMC!", TextFormatting.GREEN);
                TextComponentString discordNotification = new TextComponentString(TextFormatting.GREEN + "Join my official " + TextFormatting.AQUA + "DISCORD" + TextFormatting.GREEN + ". Click HERE");
                discordNotification.func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://discord.gg/WmdUKZz")));
                player.func_145747_a((ITextComponent)discordNotification);
                break;
            }
            case FAILED: {
                CommonEvents.sendMessage(player, "[PUBGMC] Update check failed! Check your internet connection", TextFormatting.RED);
                break;
            }
            case OUTDATED: {
                CommonEvents.sendMessage(player, "[PUBGMC] You are using old version! Get a new one.", TextFormatting.YELLOW);
                TextComponentString comp = new TextComponentString(TextFormatting.YELLOW + "New version is available! You can get it " + TextFormatting.ITALIC + "HERE");
                comp.func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/pubgmc-mod/files")));
                player.func_145747_a((ITextComponent)comp);
                break;
            }
            case PENDING: {
                CommonEvents.sendMessage(player, "[PUBGMC] Unable to check new version, check took too long!", TextFormatting.BLUE);
                break;
            }
        }
        CustomDateEvents.handleDates(player);
    }

    private static void sendMessage(EntityPlayer player, String message, TextFormatting color) {
        player.func_145747_a((ITextComponent)new TextComponentString(color + message));
    }

    @SubscribeEvent
    public void landmineExploded(LandmineExplodeEvent e) {
        for (Entity entity : e.getAffectedEntities()) {
            if (!(entity instanceof EntityVehicle)) continue;
            EntityVehicle car = (EntityVehicle)entity;
            double d0 = PUBGMCUtil.getDistanceToBlockPos3D(car.func_180425_c(), e.getExplosionPosition());
            float damage = 200.0f * (float)(1.0 - d0 / 10.0);
            car.health -= damage;
        }
    }

    @SubscribeEvent
    public void onKnockback(LivingKnockBackEvent e) {
        if (ConfigPMC.common.player.knockbackEnabled) {
            return;
        }
        e.setCanceled(true);
    }

    @SubscribeEvent
    public void attachWorldCapability(AttachCapabilitiesEvent<World> e) {
        e.addCapability(new ResourceLocation("pubgmc:worldData"), (ICapabilityProvider)new IWorldData.WorldDataProvider());
        e.addCapability(new ResourceLocation("pubgmc:gameData"), (ICapabilityProvider)new IGameData.GameDataProvider());
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent ev) {
        EntityPlayer player = ev.player;
        IPlayerData data = (IPlayerData)player.getCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null);
        player.eyeHeight = player.getDefaultEyeHeight();
        if (data.isProning()) {
            AxisAlignedBB proneBB = new AxisAlignedBB(player.field_70165_t - 0.6, player.field_70163_u, player.field_70161_v - 0.6, player.field_70165_t + 0.6, player.field_70163_u + 0.8, player.field_70161_v + 0.6);
            player.func_174826_a(proneBB);
            player.field_70131_O = 0.9f;
            player.eyeHeight = 0.6f;
        }
        if (ev.phase == TickEvent.Phase.START && (!player.field_70122_E || player.func_70051_ag() || player.func_70093_af()) && data.isProning() && !player.field_70170_p.field_72995_K) {
            data.setProning(false);
            data.sync(player);
        }
        if (ev.phase == TickEvent.Phase.START && !player.field_70170_p.field_72995_K) {
            if (player.func_184592_cb().func_77973_b() instanceof GunBase) {
                EntityItem item = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v, player.func_184592_cb());
                Vec3d vec = player.func_70040_Z();
                item.func_70016_h(vec.field_72450_a * 0.3, vec.field_72448_b * 0.3, vec.field_72449_c * 0.3);
                item.func_174867_a(30);
                player.field_70170_p.func_72838_d((Entity)item);
                player.field_71071_by.field_184439_c.set(0, (Object)ItemStack.field_190927_a);
            }
            if (ConfigPMC.common.player.inventoryLimit) {
                EntityItem ent;
                ItemStack stack;
                int i;
                for (i = 9; i < 36; ++i) {
                    stack = player.field_71071_by.func_70301_a(i);
                    if (data.getBackpackLevel() != 0 || player.field_71075_bZ.field_75098_d || stack.func_77973_b() == PMCRegistry.PMCItems.IBLOCK) continue;
                    player.field_71071_by.func_70299_a(i, new ItemStack(PMCRegistry.PMCItems.IBLOCK));
                }
                for (i = 9; i < 27; ++i) {
                    stack = player.field_71071_by.func_70301_a(i);
                    if (data.getBackpackLevel() != 1 || player.field_71075_bZ.field_75098_d || stack.func_77973_b() == PMCRegistry.PMCItems.IBLOCK) continue;
                    if (!player.field_70170_p.field_72995_K && !stack.func_190926_b()) {
                        ent = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, stack);
                        ent.func_174867_a(50);
                        player.field_70170_p.func_72838_d((Entity)ent);
                    }
                    player.field_71071_by.func_70299_a(i, new ItemStack(PMCRegistry.PMCItems.IBLOCK));
                }
                for (i = 9; i < 18; ++i) {
                    stack = player.field_71071_by.func_70301_a(i);
                    if (data.getBackpackLevel() != 2 || player.field_71075_bZ.field_75098_d || stack.func_77973_b() == PMCRegistry.PMCItems.IBLOCK) continue;
                    if (!player.field_70170_p.field_72995_K && !stack.func_190926_b()) {
                        ent = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, stack);
                        ent.func_174867_a(50);
                        player.field_70170_p.func_72838_d((Entity)ent);
                    }
                    player.field_71071_by.func_70299_a(i, new ItemStack(PMCRegistry.PMCItems.IBLOCK));
                }
                for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    stack = player.field_71071_by.func_70301_a(i);
                    if (stack.func_77973_b() != PMCRegistry.PMCItems.IBLOCK || data.getBackpackLevel() != 3) continue;
                    player.field_71071_by.func_174925_a(PMCRegistry.PMCItems.IBLOCK, 0, player.field_71071_by.func_70302_i_() * 64, null);
                }
            }
            if (player != null && player.getCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null) != null) {
                if (data.getBoost() >= 50.0f) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 10, 0, false, false));
                }
                if (data.getBoost() > 0.0f) {
                    if (data.getTimer() <= 0) {
                        if (data.getBoost() >= 50.0f) {
                            player.func_70691_i(2.0f);
                        } else {
                            player.func_70691_i(1.0f);
                        }
                        data.setTimer(400);
                    }
                    data.setTimer(data.getTimer() - 1);
                } else if (data.getTimer() > 0) {
                    data.setTimer(0);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent e) {
        EntityPlayerMP player;
        if (ConfigPMC.client.other.messagesOnJoin && e.player instanceof EntityPlayer) {
            ForgeVersion.CheckResult version = ForgeVersion.getResult((ModContainer)Loader.instance().activeModContainer());
            CommonEvents.handleUpdateResults(version, e.player);
        }
        if (e.player instanceof EntityPlayerMP && (player = (EntityPlayerMP)e.player) != null && !player.field_70170_p.field_72995_K) {
            PacketHandler.sendToClient(new PacketGetConfigFromServer(ConfigPMC.common.serializeNBT()), player);
            player.getCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null);
            IPlayerData data = (IPlayerData)player.getCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null);
            PacketHandler.syncPlayerDataToClient(data, player);
            IGameData gameData = (IGameData)player.field_70170_p.getCapability(IGameData.GameDataProvider.GAMEDATA, null);
            if (gameData != null) {
                gameData.getCurrentGame().updateDataToClient(player.field_70170_p, player);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent e) {
        if (e.player instanceof EntityPlayerMP) {
            PacketHandler.sendToClient(new PacketLoadConfig(CONFIGS.get(e.player.func_110124_au())), (EntityPlayerMP)e.player);
            CONFIGS.remove(e.player.func_110124_au());
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e.getEntity();
            IPlayerData data = (IPlayerData)player.getCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null);
            AttributeModifier modifier = new AttributeModifier(UUID.fromString("42b68862-2bdc-4df4-9fbe-4ad597cda211"), "Speed", data.isProning() ? -0.07 : 0.0, 0);
            player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(modifier);
            if (!player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_180374_a(modifier)) {
                player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(modifier);
            }
            if (data.getEquippedNV()) {
                if (data.isUsingNV() && !data.getEquippedNV()) {
                    data.setNV(false);
                }
                if (data.isUsingNV()) {
                    if (!player.field_70170_p.field_72995_K) {
                        player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 220, 0, false, false));
                    }
                } else if (!player.field_70170_p.field_72995_K && player.func_70644_a(MobEffects.field_76439_r)) {
                    player.func_184589_d(MobEffects.field_76439_r);
                }
            }
        }
    }

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent e) {
        EntityPlayer player = e.getPlayer();
        ItemStack heldStack = player.func_184614_ca();
        if (heldStack.func_77973_b() instanceof GunBase || heldStack.func_77973_b() instanceof ItemExplodeable) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onItemDrop(ItemTossEvent e) {
        ItemStack stack;
        ItemExplodeable explodeable;
        EntityPlayer player = e.getPlayer();
        EntityItem itemEntity = e.getEntityItem();
        if (itemEntity.func_92059_d().func_77973_b() == PMCRegistry.PMCItems.IBLOCK) {
            if (!player.field_71075_bZ.field_75098_d) {
                e.setCanceled(true);
            }
        } else if (itemEntity.func_92059_d().func_77973_b() instanceof GunBase) {
            ItemStack stack2 = itemEntity.func_92059_d();
            if (stack2.func_77942_o() && !player.field_71075_bZ.field_75098_d) {
                GunBase gun = (GunBase)stack2.func_77973_b();
                int ammo = stack2.func_77978_p().func_74762_e("ammo");
                player.func_191521_c(new ItemStack(gun.getAmmoType().ammo(), ammo));
                stack2.func_77978_p().func_74768_a("ammo", 0);
            }
        } else if (itemEntity.func_92059_d().func_77973_b() instanceof ItemExplodeable && (explodeable = (ItemExplodeable)(stack = itemEntity.func_92059_d()).func_77973_b()).isCooking(stack)) {
            e.setCanceled(true);
            explodeable.getExplodeableItemAction().onRemoveFromInventory(stack, player.field_70170_p, player, explodeable.getMaxFuse() - explodeable.getFuseTime(stack), EntityThrowableExplodeable.EnumEntityThrowState.SHORT);
        }
    }

    private boolean isZoneShrinking(WorldBorder border) {
        return border.func_177741_h() != this.prevDiameter;
    }
}

