/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.common;

import com.toma.pubgmc.common.blocks.PMCBlockHorizontal;
import com.toma.pubgmc.util.IBuilder;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class HorizontalBlockBuilder
implements IBuilder<PMCBlockHorizontal> {
    private String name;
    private Material material;
    private SoundType soundType;
    private BlockRenderLayer renderLayer;
    private MapColor mapColor;
    private boolean opaque;
    private boolean fullCube;
    private float lightValue;
    private AxisAlignedBB[] boxes = new AxisAlignedBB[]{Block.field_185505_j};
    private AxisAlignedBB[] coll_boxes = new AxisAlignedBB[]{Block.field_185505_j};
    private BlockFaceShape faceShape;
    private String[] desc;

    private HorizontalBlockBuilder() {
    }

    public static HorizontalBlockBuilder create(String name, Material material) {
        HorizontalBlockBuilder builder = new HorizontalBlockBuilder();
        builder.name = name;
        builder.material = material;
        builder.initialize();
        return builder;
    }

    private void initialize() {
        this.renderLayer = BlockRenderLayer.SOLID;
        this.opaque = true;
        this.fullCube = true;
        this.boxes = new AxisAlignedBB[]{Block.field_185505_j, Block.field_185505_j};
        this.faceShape = BlockFaceShape.UNDEFINED;
        this.lightValue = 0.0f;
    }

    public HorizontalBlockBuilder renderType(BlockRenderLayer layerRender) {
        this.renderLayer = layerRender;
        return this;
    }

    public HorizontalBlockBuilder mapColor(MapColor color) {
        this.mapColor = color;
        return this;
    }

    public HorizontalBlockBuilder transparency(boolean opaque, boolean fullCube) {
        this.opaque = opaque;
        this.fullCube = fullCube;
        return this;
    }

    public HorizontalBlockBuilder light(float light) {
        this.lightValue = light;
        return this;
    }

    public HorizontalBlockBuilder aabb(AxisAlignedBB aabb) {
        this.boxes = new AxisAlignedBB[]{aabb};
        this.coll_boxes = new AxisAlignedBB[]{aabb};
        return this;
    }

    public HorizontalBlockBuilder aabb(AxisAlignedBB bounding, AxisAlignedBB collision) {
        this.boxes = new AxisAlignedBB[]{bounding};
        this.coll_boxes = new AxisAlignedBB[]{collision};
        return this;
    }

    public HorizontalBlockBuilder aabb(AxisAlignedBB ... horizontalBoxes) {
        this.boxes = horizontalBoxes;
        this.coll_boxes = horizontalBoxes;
        return this;
    }

    public HorizontalBlockBuilder nullAABB() {
        this.coll_boxes = new AxisAlignedBB[]{Block.field_185506_k};
        return this;
    }

    public HorizontalBlockBuilder soundType(SoundType type) {
        this.soundType = type;
        return this;
    }

    public HorizontalBlockBuilder faceShape(BlockFaceShape shape) {
        this.faceShape = shape;
        return this;
    }

    public HorizontalBlockBuilder setTransparent() {
        this.opaque = false;
        this.fullCube = false;
        return this;
    }

    public HorizontalBlockBuilder setProp() {
        this.aabb(Block.field_185505_j, Block.field_185506_k);
        this.setTransparent();
        this.renderLayer = BlockRenderLayer.CUTOUT;
        return this;
    }

    public HorizontalBlockBuilder setPassable() {
        this.aabb(Block.field_185505_j, Block.field_185506_k);
        return this;
    }

    public HorizontalBlockBuilder description(String ... strings) {
        this.desc = strings;
        return this;
    }

    @Override
    public PMCBlockHorizontal build() {
        this.checkNotNull(this.material);
        this.checkFloat(this.lightValue, 0.0f, 1.0f);
        this.checkNotNull(this.soundType);
        PMCBlockHorizontal builtBlock = new PMCBlockHorizontal(this.name, this.material){

            public boolean func_149662_c(IBlockState state) {
                return HorizontalBlockBuilder.this.opaque;
            }

            public boolean func_149686_d(IBlockState state) {
                return HorizontalBlockBuilder.this.fullCube;
            }

            public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
                return HorizontalBlockBuilder.this.mapColor;
            }

            public BlockRenderLayer func_180664_k() {
                return HorizontalBlockBuilder.this.renderLayer;
            }

            public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
                return HorizontalBlockBuilder.this.boxes.length == 4 ? HorizontalBlockBuilder.this.boxes[1.getBoundingBoxFromRotation(state)] : HorizontalBlockBuilder.this.boxes[0];
            }

            public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
                return HorizontalBlockBuilder.this.coll_boxes.length == 4 ? HorizontalBlockBuilder.this.coll_boxes[1.getBoundingBoxFromRotation(state)] : HorizontalBlockBuilder.this.coll_boxes[0];
            }

            public SoundType getSoundType(IBlockState state, World world, BlockPos pos, Entity entity) {
                return HorizontalBlockBuilder.this.soundType;
            }

            public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
                return HorizontalBlockBuilder.this.faceShape;
            }

            @Override
            public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
                if (HorizontalBlockBuilder.this.desc != null) {
                    for (String s : HorizontalBlockBuilder.this.desc) {
                        tooltip.add(s);
                    }
                }
            }
        };
        builtBlock.func_149715_a(this.lightValue);
        return builtBlock;
    }
}

