/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.common.blocks;

import com.toma.pubgmc.Pubgmc;
import com.toma.pubgmc.common.blocks.PMCBlock;
import com.toma.pubgmc.common.tileentity.TileEntityLootGenerator;
import com.toma.pubgmc.config.ConfigPMC;
import com.toma.pubgmc.util.handlers.GuiHandler;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockLootSpawner
extends PMCBlock {
    public static final PropertyInteger LOOT = PropertyInteger.func_177719_a((String)"loot", (int)0, (int)2);
    private static final AxisAlignedBB BB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
    private MapColor color;
    private Random rand = new Random();

    public BlockLootSpawner(String name, Material material, SoundType sound, MapColor color) {
        super(name, material);
        this.func_149672_a(sound);
        this.func_149722_s();
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LOOT, (Comparable)Integer.valueOf(0)));
        this.color = color;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K && !playerIn.func_70093_af()) {
            playerIn.openGui((Object)Pubgmc.instance, GuiHandler.LOOT_SPAWNER, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        } else if (playerIn.func_70093_af() && playerIn.field_71075_bZ.field_75098_d) {
            this.updateBlockState(worldIn, pos, state);
            Vec3d rgb = LootType.getTypeFromState(worldIn.func_180495_p(pos)).getRGB();
            worldIn.func_175688_a(EnumParticleTypes.REDSTONE, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, rgb.field_72450_a, rgb.field_72448_b, rgb.field_72449_c, new int[0]);
        }
        return true;
    }

    public void updateBlockState(World world, BlockPos pos, IBlockState state) {
        int i = (Integer)state.func_177229_b((IProperty)LOOT) + 1 < 3 ? (Integer)state.func_177229_b((IProperty)LOOT) + 1 : 0;
        world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)LOOT, (Comparable)Integer.valueOf(i)), 3);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return ConfigPMC.client.other.lootRenderStyle.ordinal() < 2 ? BlockRenderLayer.CUTOUT : BlockRenderLayer.SOLID;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BB;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return BB;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityLootGenerator();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LOOT, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LOOT);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LOOT});
    }

    @Override
    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.BOLD + "Shift-Right Click in Creative mode to change tier:");
        tooltip.add(TextFormatting.RED + "COMMON, multiplier x1");
        tooltip.add(TextFormatting.YELLOW + "RARE, multiplier x1.4");
        tooltip.add(TextFormatting.GREEN + "VERY RARE, multiplier x2");
        tooltip.add(TextFormatting.ITALIC + "Loot can be generated using the " + TextFormatting.UNDERLINE + "/loot generate");
    }

    public static enum LootType {
        COMMON(1.0, 0.0, 0.0, 1.0f, false),
        RARE(0.0, 1.0, 0.0, 1.4f, false),
        VERY_RARE(0.2, 1.0, 0.0, 2.0f, false),
        AIRDROP(0.0, 0.0, 0.0, 1.0f, true);

        private final Vec3d rgb;
        private final float multiplier;

        private LootType(double r, double g, double b, float multiplier, boolean allowSpecialWeapons) {
            this.rgb = new Vec3d(r, g, b);
            this.multiplier = multiplier;
        }

        public static LootType getTypeFromState(IBlockState state) {
            return LootType.values()[(Integer)state.func_177229_b((IProperty)LOOT)];
        }

        public Vec3d getRGB() {
            return this.rgb;
        }

        public float getLootMultiplier() {
            return this.multiplier;
        }

        public LootType switchMode() {
            return this.ordinal() + 1 < 3 ? LootType.values()[this.ordinal() + 1] : LootType.values()[0];
        }
    }
}

