/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.common.blocks;

import com.google.common.base.Predicate;
import com.toma.pubgmc.common.blocks.IBulletReaction;
import com.toma.pubgmc.common.blocks.PMCBlock;
import com.toma.pubgmc.common.entity.EntityBullet;
import com.toma.pubgmc.init.PMCRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class BlockTarget
extends PMCBlock
implements IBulletReaction {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool UPPER = PropertyBool.func_177716_a((String)"upper");
    public static final PropertyBool FEEDBACK = PropertyBool.func_177716_a((String)"feedback");

    public BlockTarget(String name) {
        super(name, Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)FEEDBACK, (Comparable)Boolean.valueOf(false)));
        this.addDescription("Right-Click to enable hit information");
    }

    @Override
    public void onHit(EntityBullet bullet, Vec3d hit) {
        if (bullet.getShooter() != null && bullet.getShooter() instanceof EntityPlayerMP) {
            EntityPlayer player = (EntityPlayer)bullet.getShooter();
            IBlockState state = bullet.field_70170_p.func_180495_p(new BlockPos(hit));
            double delta = hit.field_72448_b - (double)((int)hit.field_72448_b);
            boolean headShot = state.func_177230_c() == PMCRegistry.PMCBlocks.TARGET && (Boolean)state.func_177229_b((IProperty)UPPER) != false && delta > 0.5;
            player.func_146105_b((ITextComponent)new TextComponentString(headShot ? TextFormatting.RED + "Headshot! Damage: " + (double)bullet.getDamage() * 2.5 : "Damage: " + bullet.getDamage()), true);
        }
    }

    @Override
    public boolean canReceiveFeedBack(World world, BlockPos pos, IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)FEEDBACK);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && super.func_176196_c(worldIn, pos.func_177984_a());
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        EnumFacing facing = (Boolean)state.func_177229_b((IProperty)UPPER) != false ? EnumFacing.DOWN : EnumFacing.UP;
        worldIn.func_175655_b(pos.func_177972_a(facing), false);
        super.func_180663_b(worldIn, pos, state);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!((Boolean)state.func_177229_b((IProperty)UPPER)).booleanValue()) {
            worldIn.func_175656_a(pos.func_177984_a(), state.func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(true)));
        }
        super.func_176213_c(worldIn, pos, state);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            boolean b = (Boolean)state.func_177229_b((IProperty)FEEDBACK) == false;
            EnumFacing facing1 = (Boolean)state.func_177229_b((IProperty)UPPER) != false ? EnumFacing.DOWN : EnumFacing.UP;
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)FEEDBACK, (Comparable)Boolean.valueOf(b)));
            worldIn.func_175656_a(pos.func_177972_a(facing1), worldIn.func_180495_p(pos.func_177972_a(facing1)).func_177226_a((IProperty)FEEDBACK, (Comparable)Boolean.valueOf(b)));
            playerIn.func_146105_b((ITextComponent)new TextComponentString(b ? "Hit information enabled" : "Hit information disabled"), true);
        }
        return true;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() | ((Boolean)state.func_177229_b((IProperty)UPPER) != false ? 4 : 0) | ((Boolean)state.func_177229_b((IProperty)FEEDBACK) != false ? 8 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta)).func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf((meta & 4) != 0)).func_177226_a((IProperty)FEEDBACK, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, UPPER, FEEDBACK});
    }
}

