/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.common.blocks;

import com.toma.pubgmc.common.blocks.PMCBlock;
import com.toma.pubgmc.common.tileentity.TileEntityWindow;
import com.toma.pubgmc.network.PacketHandler;
import com.toma.pubgmc.network.sp.PacketParticle;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockWindow
extends PMCBlock {
    public static final PropertyEnum<EnumWindowAxis> AXIS = PropertyEnum.func_177709_a((String)"axis", EnumWindowAxis.class);
    public static final PropertyEnum<EnumWindowPart> PART = PropertyEnum.func_177709_a((String)"part", EnumWindowPart.class);
    public static final PropertyBool BROKEN = PropertyBool.func_177716_a((String)"broken");
    private static final AxisAlignedBB[] BOUNDING_BOX = new AxisAlignedBB[]{new AxisAlignedBB(0.35, 0.0, 0.0, 0.65, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.35, 1.0, 1.0, 0.65)};
    private static final AxisAlignedBB[] COLLISION_BOX = new AxisAlignedBB[]{new AxisAlignedBB(0.4, 0.0, 0.0, 0.6, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.4, 1.0, 1.0, 0.6)};
    private final WindowType windowType;

    public BlockWindow(String name, WindowType windowType) {
        super(name, Material.field_151575_d);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149711_c(0.75f);
        this.windowType = windowType;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BROKEN, (Comparable)Boolean.valueOf(false)).func_177226_a(AXIS, (Comparable)((Object)EnumWindowAxis.NS)).func_177226_a(PART, (Comparable)((Object)EnumWindowPart.LOWER_LEFT)));
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        boolean b = blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() == this;
        return !b && super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public void neighborBroken(EnumFacing side, World world, BlockPos pos, IBlockState state) {
        if (!((Boolean)state.func_177229_b((IProperty)BROKEN)).booleanValue()) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)BROKEN, (Comparable)Boolean.valueOf(true)));
            this.notifyNeighboringWindows(pos, world);
            if (!world.field_72995_K && ((EnumWindowPart)((Object)state.func_177229_b(PART))).ordinal() < 2) {
                int axis = ((EnumWindowAxis)((Object)state.func_177229_b(AXIS))).ordinal();
                PacketParticle packet = new PacketParticle(EnumParticleTypes.BLOCK_CRACK, 15, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), this, PacketParticle.ParticleAction.CREATE_LINE, axis);
                PacketHandler.sendToAllClients(packet);
            }
        }
    }

    public void breakWindow(IBlockState state, BlockPos pos, World world) {
        if (!((Boolean)state.func_177229_b((IProperty)BROKEN)).booleanValue()) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)BROKEN, (Comparable)Boolean.valueOf(true)));
            this.notifyNeighboringWindows(pos, world);
            world.func_184133_a(null, pos, SoundEvents.field_187561_bM, SoundCategory.BLOCKS, 3.0f, 1.0f);
        }
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        this.breakWindow(state, pos, worldIn);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX[((EnumWindowAxis)((Object)state.func_177229_b(AXIS))).ordinal()];
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        if (((Boolean)blockState.func_177229_b((IProperty)BROKEN)).booleanValue()) {
            return field_185506_k;
        }
        return COLLISION_BOX[((EnumWindowAxis)((Object)blockState.func_177229_b(AXIS))).ordinal()];
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityWindow();
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)BROKEN)).booleanValue()) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)BROKEN, (Comparable)Boolean.valueOf(false)));
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        switch (this.windowType) {
            case WINDOW_1X2: {
                EnumWindowPart part = (EnumWindowPart)((Object)state.func_177229_b(PART));
                if (part.ordinal() > 1) {
                    worldIn.func_175698_g(pos.func_177984_a());
                } else {
                    worldIn.func_175698_g(pos.func_177977_b());
                }
                super.func_180663_b(worldIn, pos, state);
                break;
            }
            case WINDOW_2X1: {
                if (state.func_177229_b(AXIS) == EnumWindowAxis.WE) {
                    EnumFacing offset = state.func_177229_b(PART) == EnumWindowPart.LOWER_LEFT ? EnumFacing.WEST : EnumFacing.EAST;
                    IBlockState state1 = worldIn.func_180495_p(pos.func_177972_a(offset));
                    if (state1.func_177230_c() instanceof BlockWindow) {
                        worldIn.func_175698_g(pos.func_177972_a(offset));
                    }
                } else {
                    EnumFacing offset = state.func_177229_b(PART) == EnumWindowPart.LOWER_LEFT ? EnumFacing.SOUTH : EnumFacing.NORTH;
                    IBlockState state1 = worldIn.func_180495_p(pos.func_177972_a(offset));
                    if (state1.func_177230_c() instanceof BlockWindow) {
                        worldIn.func_175698_g(pos.func_177972_a(offset));
                    }
                }
                super.func_180663_b(worldIn, pos, state);
                break;
            }
            case WINDOW_2X2: {
                if (((EnumWindowPart)((Object)state.func_177229_b(PART))).isLower()) {
                    worldIn.func_175698_g(pos.func_177984_a());
                    if (state.func_177229_b(AXIS) == EnumWindowAxis.NS) {
                        EnumFacing offset = state.func_177229_b(PART) == EnumWindowPart.LOWER_LEFT ? EnumFacing.SOUTH : EnumFacing.NORTH;
                        IBlockState state1 = worldIn.func_180495_p(pos.func_177972_a(offset));
                        if (state1.func_177230_c() instanceof BlockWindow) {
                            worldIn.func_175698_g(pos.func_177972_a(offset));
                            worldIn.func_175698_g(pos.func_177972_a(offset).func_177984_a());
                        }
                    } else {
                        EnumFacing offset = state.func_177229_b(PART) == EnumWindowPart.LOWER_LEFT ? EnumFacing.WEST : EnumFacing.EAST;
                        IBlockState state1 = worldIn.func_180495_p(pos.func_177972_a(offset));
                        if (state1.func_177230_c() instanceof BlockWindow) {
                            worldIn.func_175698_g(pos.func_177972_a(offset));
                            worldIn.func_175698_g(pos.func_177972_a(offset).func_177984_a());
                        }
                    }
                } else {
                    worldIn.func_175698_g(pos.func_177977_b());
                    if (state.func_177229_b(AXIS) == EnumWindowAxis.NS) {
                        EnumFacing offset = state.func_177229_b(PART) == EnumWindowPart.LOWER_LEFT ? EnumFacing.SOUTH : EnumFacing.NORTH;
                        IBlockState state1 = worldIn.func_180495_p(pos.func_177972_a(offset));
                        if (state1.func_177230_c() instanceof BlockWindow) {
                            worldIn.func_175698_g(pos.func_177972_a(offset));
                            worldIn.func_175698_g(pos.func_177972_a(offset).func_177977_b());
                        }
                    } else {
                        EnumFacing offset = state.func_177229_b(PART) == EnumWindowPart.LOWER_LEFT ? EnumFacing.WEST : EnumFacing.EAST;
                        IBlockState state1 = worldIn.func_180495_p(pos.func_177972_a(offset));
                        if (state1.func_177230_c() instanceof BlockWindow) {
                            worldIn.func_175698_g(pos.func_177972_a(offset));
                            worldIn.func_175698_g(pos.func_177972_a(offset).func_177977_b());
                        }
                    }
                }
                super.func_180663_b(worldIn, pos, state);
                break;
            }
            default: {
                super.func_180663_b(worldIn, pos, state);
            }
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing f = placer.func_174811_aO();
        boolean flag = f == EnumFacing.NORTH || f == EnumFacing.WEST;
        IBlockState iBlockState = super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a(AXIS, (Comparable)((Object)EnumWindowAxis.getAxisFromFacing(f))).func_177226_a(PART, (Comparable)((Object)(flag ? EnumWindowPart.LOWER_RIGHT : EnumWindowPart.LOWER_LEFT)));
        switch (this.windowType) {
            case WINDOW_1X1: {
                return iBlockState;
            }
            case WINDOW_1X2: {
                if (world.func_180495_p(pos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177984_a())) {
                    world.func_175656_a(pos.func_177984_a(), iBlockState.func_177226_a(PART, (Comparable)((Object)(flag ? EnumWindowPart.UPPER_RIGHT : EnumWindowPart.UPPER_LEFT))));
                    return iBlockState;
                }
                return Blocks.field_150350_a.func_176223_P();
            }
            case WINDOW_2X1: {
                BlockPos neighbor = pos.func_177972_a(f.func_176746_e());
                if (world.func_180495_p(neighbor).func_177230_c().func_176200_f((IBlockAccess)world, neighbor)) {
                    world.func_175656_a(neighbor, iBlockState.func_177226_a(PART, (Comparable)((Object)(flag ? EnumWindowPart.LOWER_LEFT : EnumWindowPart.LOWER_RIGHT))));
                    return iBlockState;
                }
                return Blocks.field_150350_a.func_176223_P();
            }
            case WINDOW_2X2: {
                BlockPos neighbor = pos.func_177972_a(f.func_176746_e());
                IBlockState lr = world.func_180495_p(neighbor);
                IBlockState ul = world.func_180495_p(pos.func_177984_a());
                IBlockState ur = world.func_180495_p(neighbor.func_177984_a());
                if (world.func_180495_p(pos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177984_a()) && world.func_180495_p(neighbor).func_177230_c().func_176200_f((IBlockAccess)world, neighbor) && world.func_180495_p(neighbor.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)world, neighbor.func_177984_a())) {
                    world.func_175656_a(pos.func_177984_a(), iBlockState.func_177226_a(PART, (Comparable)((Object)(flag ? EnumWindowPart.UPPER_RIGHT : EnumWindowPart.UPPER_LEFT))));
                    world.func_175656_a(neighbor, iBlockState.func_177226_a(PART, (Comparable)((Object)(flag ? EnumWindowPart.LOWER_LEFT : EnumWindowPart.LOWER_RIGHT))));
                    world.func_175656_a(neighbor.func_177984_a(), iBlockState.func_177226_a(PART, (Comparable)((Object)(flag ? EnumWindowPart.UPPER_LEFT : EnumWindowPart.UPPER_RIGHT))));
                    return iBlockState;
                }
                return Blocks.field_150350_a.func_176223_P();
            }
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((EnumWindowPart)((Object)state.func_177229_b(PART))).ordinal();
        meta = (Boolean)state.func_177229_b((IProperty)BROKEN) != false ? meta | 4 : meta;
        return meta |= ((EnumWindowAxis)((Object)state.func_177229_b(AXIS))).ordinal() << 3;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(PART, (Comparable)((Object)EnumWindowPart.values()[meta % 4])).func_177226_a((IProperty)BROKEN, (Comparable)Boolean.valueOf((meta & 4) > 0)).func_177226_a(AXIS, (Comparable)((Object)EnumWindowAxis.values()[meta >> 3]));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PART, AXIS, BROKEN});
    }

    private void notifyNeighboringWindows(BlockPos pos, World world) {
        for (EnumFacing facing : EnumFacing.values()) {
            BlockPos neighborPos = pos.func_177972_a(facing);
            IBlockState neighbor = world.func_180495_p(neighborPos);
            if (!(neighbor.func_177230_c() instanceof BlockWindow)) continue;
            this.neighborBroken(facing, world, neighborPos, neighbor);
        }
    }

    public static enum EnumWindowPart implements IStringSerializable
    {
        UPPER_RIGHT,
        UPPER_LEFT,
        LOWER_RIGHT,
        LOWER_LEFT;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public boolean isLower() {
            return this.ordinal() > 1;
        }

        public EnumWindowPart getOpposite() {
            return EnumWindowPart.getOpposite(this);
        }

        public static EnumWindowPart getOpposite(EnumWindowPart part) {
            switch (part) {
                case LOWER_LEFT: {
                    return LOWER_RIGHT;
                }
                default: {
                    return LOWER_LEFT;
                }
                case UPPER_LEFT: {
                    return UPPER_RIGHT;
                }
                case UPPER_RIGHT: 
            }
            return UPPER_LEFT;
        }
    }

    public static enum EnumWindowAxis implements IStringSerializable
    {
        NS,
        WE;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public static EnumWindowAxis getAxisFromFacing(EnumFacing facing) {
            switch (facing) {
                case EAST: 
                case WEST: {
                    return NS;
                }
            }
            return WE;
        }
    }

    public static enum WindowType {
        WINDOW_1X1,
        WINDOW_1X2,
        WINDOW_2X1,
        WINDOW_2X2;

    }
}

