/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.common.capability;

import com.toma.pubgmc.Pubgmc;
import com.toma.pubgmc.api.Game;
import com.toma.pubgmc.api.Lobby;
import com.toma.pubgmc.init.GameRegistry;
import com.toma.pubgmc.util.PUBGMCUtil;
import com.toma.pubgmc.world.MapLocation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;

public interface IGameData
extends INBTSerializable<NBTTagCompound> {
    public boolean isPlaying();

    public void setPlaying(boolean var1);

    public void addSpawnLocation(MapLocation var1);

    public boolean removeSpawnLocation(String var1);

    public List<MapLocation> getSpawnLocations();

    public void setMapCenter(double var1, double var3, int var5);

    public BlockPos getMapCenter();

    public int getMapSize();

    public String getGameID();

    public void setGameID(String var1);

    public void createGameID();

    public void setGame(Game var1);

    public Game getCurrentGame();

    public void setLobby(Lobby var1);

    public Lobby getLobby();

    public boolean isInactiveGame();

    public static class GameDataProvider
    implements ICapabilitySerializable<NBTBase> {
        @CapabilityInject(value=IGameData.class)
        public static final Capability<IGameData> GAMEDATA = null;
        private IGameData instance = (IGameData)GAMEDATA.getDefaultInstance();

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == GAMEDATA;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(capability == GAMEDATA ? GAMEDATA.cast((Object)this.instance) : null);
        }

        public NBTBase serializeNBT() {
            return GAMEDATA.getStorage().writeNBT(GAMEDATA, (Object)this.instance, null);
        }

        public void deserializeNBT(NBTBase nbt) {
            GAMEDATA.getStorage().readNBT(GAMEDATA, (Object)this.instance, null, nbt);
        }
    }

    public static class GameData
    implements IGameData {
        boolean isPlaying;
        List<MapLocation> locations = new ArrayList<MapLocation>();
        List<String> names = new ArrayList<String>();
        BlockPos gameZoneCenter;
        int mapSize;
        String gameHash = "null";
        Game game;
        Lobby lobby;

        @Override
        public boolean isPlaying() {
            return this.isPlaying;
        }

        @Override
        public void setPlaying(boolean play) {
            this.isPlaying = play;
        }

        @Override
        public void addSpawnLocation(MapLocation location) {
            this.locations.add(location);
        }

        @Override
        public boolean removeSpawnLocation(String name) {
            MapLocation location = this.findLocationByName(name);
            if (location == null) {
                Pubgmc.logger.error("Attempted to remove location with name {} which doesn't exist!", (Object)name);
                return false;
            }
            this.locations.remove(location);
            return true;
        }

        @Override
        public List<MapLocation> getSpawnLocations() {
            return this.locations;
        }

        @Override
        public void setMapCenter(double x, double z, int size) {
            this.gameZoneCenter = new BlockPos(x, 0.0, z);
            this.mapSize = size;
        }

        @Override
        public BlockPos getMapCenter() {
            return this.gameZoneCenter;
        }

        @Override
        public int getMapSize() {
            return this.mapSize;
        }

        @Override
        public String getGameID() {
            return this.gameHash == null || this.gameHash.isEmpty() ? "undefined" : this.gameHash;
        }

        @Override
        public void setGameID(String id) {
            this.gameHash = id;
        }

        @Override
        public void createGameID() {
            this.gameHash = PUBGMCUtil.generateID(16);
        }

        @Override
        public void setGame(Game game) {
            this.game = game;
        }

        @Override
        public Game getCurrentGame() {
            if (this.game == null) {
                this.setGame(GameRegistry.findGameInRegistry("inactive"));
            }
            return this.game;
        }

        @Override
        public void setLobby(Lobby lobby) {
            this.lobby = lobby;
        }

        @Override
        public Lobby getLobby() {
            return this.lobby;
        }

        @Override
        public boolean isInactiveGame() {
            return this.game.registryName.equals("inactive");
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound c = new NBTTagCompound();
            NBTTagList positions = new NBTTagList();
            if (this.gameZoneCenter == null) {
                this.setMapCenter(0.0, 0.0, 0);
            }
            c.func_74757_a("isPlaying", this.isPlaying);
            c.func_74768_a("mapCenterX", this.gameZoneCenter.func_177958_n());
            c.func_74768_a("mapCenterZ", this.gameZoneCenter.func_177952_p());
            c.func_74768_a("mapSize", this.mapSize);
            NBTTagList locationsList = new NBTTagList();
            for (int i = 0; i < this.locations.size(); ++i) {
                locationsList.func_74742_a((NBTBase)this.locations.get(i).serializeNBT());
            }
            c.func_74782_a("list", (NBTBase)locationsList);
            c.func_74778_a("gameID", this.gameHash);
            c.func_74782_a("lobby", (NBTBase)Lobby.toNBT(this.lobby));
            c.func_74778_a("gameMode", this.getCurrentGame().registryName);
            c.func_74782_a("game", (NBTBase)this.getCurrentGame().writeToNBT());
            return c;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.isPlaying = nbt.func_74767_n("isPlaying");
            this.gameZoneCenter = new BlockPos(nbt.func_74762_e("mapCenterX"), 0, nbt.func_74762_e("mapCenterZ"));
            this.mapSize = nbt.func_74762_e("mapSize");
            NBTTagList locList = nbt.func_150295_c("list", 10);
            for (int i = 0; i < locList.func_74745_c(); ++i) {
                MapLocation location = new MapLocation(null, null);
                location.deserializeNBT(locList.func_150305_b(i));
                this.addSpawnLocation(location);
            }
            this.gameHash = nbt.func_74779_i("gameID");
            this.lobby = Lobby.fromNBT(nbt.func_74775_l("lobby"));
            this.setGame(GameRegistry.findGameInRegistry(nbt.func_74779_i("gameMode")));
            this.getCurrentGame().readFromNBT(nbt.func_74775_l("game"));
        }

        private MapLocation findLocationByName(String name) {
            for (MapLocation mapLocation : this.locations) {
                if (!mapLocation.name().equalsIgnoreCase(name)) continue;
                return mapLocation;
            }
            return null;
        }
    }

    public static class GameDataStorage
    implements Capability.IStorage<IGameData> {
        public void readNBT(Capability<IGameData> capability, IGameData instance, EnumFacing side, NBTBase nbt) {
            instance.deserializeNBT((NBTBase)(nbt instanceof NBTTagCompound ? (NBTTagCompound)nbt : new NBTTagCompound()));
        }

        public NBTBase writeNBT(Capability<IGameData> capability, IGameData instance, EnumFacing side) {
            return instance.serializeNBT();
        }
    }
}

