/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.common.capability;

import com.toma.pubgmc.network.PacketHandler;
import com.toma.pubgmc.network.sp.PacketClientCapabilitySync;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public interface IPlayerData
extends INBTSerializable<NBTTagCompound> {
    public boolean isReloading();

    public void setReloading(boolean var1);

    public boolean isAiming();

    public void setAiming(boolean var1);

    public void setNV(boolean var1);

    public boolean isUsingNV();

    public int getReloadingTime();

    public void setReloadingTime(int var1);

    public int getTimer();

    public void setTimer(int var1);

    public void addBoost(float var1);

    public void removeBoost(float var1);

    public float getBoost();

    public void setBoost(float var1);

    public void setBackpackLevel(int var1);

    public int getBackpackLevel();

    public void hasEquippedNV(boolean var1);

    public boolean getEquippedNV();

    public boolean isProning();

    public void setProning(boolean var1);

    public int getScopeType();

    public void setScopeType(int var1);

    public int getScopeColor();

    public void setScopeColor(int var1);

    public double getDistance();

    public void setDistance(double var1);

    public void sync(EntityPlayer var1);

    public NBTTagCompound serializePacketNBT();

    public void deserializePacketNBT(NBTTagCompound var1);

    @Mod.EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void attach(AttachCapabilitiesEvent<Entity> e) {
            if (e.getObject() instanceof EntityPlayer) {
                e.addCapability(new ResourceLocation("pubgmc", "playerdata"), (ICapabilityProvider)new PlayerDataProvider());
            }
        }

        @SubscribeEvent
        public static void onRespawn(PlayerEvent.PlayerRespawnEvent e) {
            Events.getCap(e.player).sync(e.player);
        }

        @SubscribeEvent
        public static void clone(PlayerEvent.Clone e) {
            Capability.IStorage storage = PlayerDataProvider.PLAYER_DATA.getStorage();
            IPlayerData oldData = Events.getCap(e.getOriginal());
            IPlayerData newData = Events.getCap(e.getEntityPlayer());
            NBTTagCompound nbt = (NBTTagCompound)storage.writeNBT(PlayerDataProvider.PLAYER_DATA, (Object)oldData, null);
            storage.readNBT(PlayerDataProvider.PLAYER_DATA, (Object)newData, null, (NBTBase)nbt);
            Events.getCap(e.getEntityPlayer()).sync(e.getEntityPlayer());
        }

        @SubscribeEvent
        public static void onDimensionChanged(PlayerEvent.PlayerChangedDimensionEvent e) {
            Events.getCap(e.player).sync(e.player);
        }

        @SubscribeEvent
        public static void onStartTracking(PlayerEvent.StartTracking event) {
            if (event.getTarget() instanceof EntityPlayerMP) {
                EntityPlayer player = (EntityPlayer)event.getTarget();
                PacketHandler.sendToClient(new PacketClientCapabilitySync(player, (NBTTagCompound)PlayerData.get(player).serializeNBT()), (EntityPlayerMP)event.getEntityPlayer());
            }
        }

        public static IPlayerData getCap(EntityPlayer p) {
            if (p.hasCapability(PlayerDataProvider.PLAYER_DATA, null)) {
                return (IPlayerData)p.getCapability(PlayerDataProvider.PLAYER_DATA, null);
            }
            throw new IllegalStateException("[PUBGMC] Couldn't get player data for " + p.func_70005_c_());
        }
    }

    public static class PlayerDataProvider
    implements ICapabilitySerializable<NBTBase> {
        @CapabilityInject(value=IPlayerData.class)
        public static final Capability<IPlayerData> PLAYER_DATA = null;
        private IPlayerData instance = (IPlayerData)PLAYER_DATA.getDefaultInstance();

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == PLAYER_DATA;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(capability == PLAYER_DATA ? PLAYER_DATA.cast((Object)this.instance) : null);
        }

        public NBTBase serializeNBT() {
            return PLAYER_DATA.getStorage().writeNBT(PLAYER_DATA, (Object)this.instance, null);
        }

        public void deserializeNBT(NBTBase nbt) {
            PLAYER_DATA.getStorage().readNBT(PLAYER_DATA, (Object)this.instance, null, nbt);
        }
    }

    public static class PlayerData
    implements IPlayerData {
        private boolean reloading;
        private boolean aiming;
        private boolean nv;
        private int reloading_time;
        private int timer;
        private float boost;
        private boolean isProne;
        private int level;
        private boolean eqNV;
        private int scopetype;
        private int scopecolor;
        private double dist;

        public static IPlayerData get(EntityPlayer player) {
            if (player.hasCapability(PlayerDataProvider.PLAYER_DATA, null)) {
                return (IPlayerData)player.getCapability(PlayerDataProvider.PLAYER_DATA, null);
            }
            return null;
        }

        @Override
        public void setBackpackLevel(int level) {
            this.level = level;
        }

        @Override
        public int getBackpackLevel() {
            return this.level;
        }

        @Override
        public void hasEquippedNV(boolean nv) {
            this.eqNV = nv;
        }

        @Override
        public boolean getEquippedNV() {
            return this.eqNV;
        }

        @Override
        public boolean isReloading() {
            return this.reloading;
        }

        @Override
        public void setReloading(boolean reloading) {
            this.reloading = reloading;
        }

        @Override
        public boolean isAiming() {
            return this.aiming;
        }

        @Override
        public void setAiming(boolean aiming) {
            this.aiming = aiming;
        }

        @Override
        public boolean isUsingNV() {
            return this.nv;
        }

        @Override
        public int getReloadingTime() {
            return this.reloading_time;
        }

        @Override
        public void setReloadingTime(int rt) {
            this.reloading_time = rt;
        }

        @Override
        public int getTimer() {
            return this.timer;
        }

        @Override
        public void setTimer(int t) {
            this.timer = t;
        }

        @Override
        public float getBoost() {
            return this.boost;
        }

        @Override
        public void setBoost(float boost) {
            this.boost = boost;
        }

        @Override
        public void setNV(boolean nv) {
            this.nv = nv;
        }

        @Override
        public void addBoost(float boost) {
            this.boost += boost;
        }

        @Override
        public void removeBoost(float boost) {
            this.boost -= boost;
        }

        @Override
        public int getScopeType() {
            return this.scopetype;
        }

        @Override
        public void setScopeType(int type) {
            this.scopetype = type;
        }

        @Override
        public int getScopeColor() {
            return this.scopecolor;
        }

        @Override
        public void setScopeColor(int color) {
            this.scopecolor = color;
        }

        @Override
        public double getDistance() {
            return this.dist;
        }

        @Override
        public void setDistance(double dist) {
            this.dist = dist;
        }

        @Override
        public boolean isProning() {
            return this.isProne;
        }

        @Override
        public void setProning(boolean proning) {
            this.isProne = proning;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound c = new NBTTagCompound();
            c.func_74776_a("boost", this.boost);
            c.func_74768_a("level", this.level);
            c.func_74757_a("eqnv", this.eqNV);
            c.func_74768_a("scopetype", this.scopetype);
            c.func_74768_a("scopecolor", this.scopecolor);
            return c;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.boost = nbt.func_74760_g("boost");
            this.level = nbt.func_74762_e("level");
            this.eqNV = nbt.func_74767_n("eqnv");
            this.scopetype = nbt.func_74762_e("scopetype");
            this.scopecolor = nbt.func_74762_e("scopecolor");
        }

        @Override
        public NBTTagCompound serializePacketNBT() {
            NBTTagCompound nbt = this.serializeNBT();
            nbt.func_74757_a("aim", this.aiming);
            nbt.func_74757_a("reload", this.reloading);
            nbt.func_74757_a("prone", this.isProne);
            return nbt;
        }

        @Override
        public void deserializePacketNBT(NBTTagCompound nbt) {
            this.deserializeNBT(nbt);
            this.aiming = nbt.func_74767_n("aim");
            this.reloading = nbt.func_74767_n("reload");
            this.isProne = nbt.func_74767_n("prone");
        }

        @Override
        public void sync(EntityPlayer player) {
            PacketHandler.sendToAllClients(new PacketClientCapabilitySync(player, this.serializePacketNBT()));
        }
    }

    public static class PlayerDataStorage
    implements Capability.IStorage<IPlayerData> {
        public NBTBase writeNBT(Capability<IPlayerData> capability, IPlayerData instance, EnumFacing side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<IPlayerData> capability, IPlayerData instance, EnumFacing side, NBTBase nbt) {
            instance.deserializeNBT((NBTBase)(nbt instanceof NBTTagCompound ? (NBTTagCompound)nbt : new NBTTagCompound()));
        }
    }
}

