/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.common.capability;

import com.toma.pubgmc.common.items.guns.GunBase;
import com.toma.pubgmc.config.ConfigPMC;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;

public interface IWorldData
extends INBTSerializable<NBTTagCompound> {
    public void toggleAirdropWeapons(boolean var1);

    public boolean hasAirdropWeapons();

    public void toggleAmmoLoot(boolean var1);

    public boolean isAmmoLootEnabled();

    public void toggleRandomAmmoCount(boolean var1);

    public boolean isRandomAmmoCountEnabled();

    public double getLootChanceMultiplier();

    public void setLootChanceMultiplier(double var1);

    public void addWeaponTypeToLootGeneration(GunBase.GunType var1);

    public void removeWeaponTypeFromLootGeneration(GunBase.GunType var1);

    public List<GunBase.GunType> getWeaponList();

    public void setWeaponList(int[] var1);

    public void resetWeaponLootGeneration();

    public void setGhillieSuitsColorVariants(List<Integer> var1);

    public List<Integer> getGhillieSuitsColorVariants();

    public void addColorVariant(int var1);

    public void removeColorVariant(int var1);

    public static class WorldDataProvider
    implements ICapabilitySerializable<NBTBase> {
        @CapabilityInject(value=IWorldData.class)
        public static final Capability<IWorldData> WORLD_DATA = null;
        private IWorldData instance = (IWorldData)WORLD_DATA.getDefaultInstance();

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == WORLD_DATA;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(capability == WORLD_DATA ? WORLD_DATA.cast((Object)this.instance) : null);
        }

        public NBTBase serializeNBT() {
            return WORLD_DATA.getStorage().writeNBT(WORLD_DATA, (Object)this.instance, null);
        }

        public void deserializeNBT(NBTBase nbt) {
            WORLD_DATA.getStorage().readNBT(WORLD_DATA, (Object)this.instance, null, nbt);
        }
    }

    public static class WorldData
    implements IWorldData {
        private boolean airdropWep = false;
        private boolean ammoLoot = true;
        private boolean randomAmmoCount = false;
        private double chance = 1.0;
        private List<GunBase.GunType> weaponTypes = new ArrayList<GunBase.GunType>(GunBase.GunType.toCollection());
        private List<Integer> ghillieColors = new ArrayList<Integer>();

        public WorldData() {
            for (int i : ConfigPMC.world().defaultGhillieColors) {
                this.ghillieColors.add(i);
            }
        }

        @Override
        public void toggleAirdropWeapons(boolean enable) {
            this.airdropWep = enable;
        }

        @Override
        public boolean hasAirdropWeapons() {
            return this.airdropWep;
        }

        @Override
        public void toggleAmmoLoot(boolean enableAmmo) {
            this.ammoLoot = enableAmmo;
        }

        @Override
        public boolean isAmmoLootEnabled() {
            return this.ammoLoot;
        }

        @Override
        public void toggleRandomAmmoCount(boolean randomAmmo) {
            this.randomAmmoCount = randomAmmo;
        }

        @Override
        public boolean isRandomAmmoCountEnabled() {
            return this.randomAmmoCount;
        }

        @Override
        public double getLootChanceMultiplier() {
            return this.chance;
        }

        @Override
        public void setLootChanceMultiplier(double chance) {
            this.chance = chance;
        }

        @Override
        public void addWeaponTypeToLootGeneration(GunBase.GunType typeToAdd) {
            if (!this.weaponTypes.contains((Object)typeToAdd) && typeToAdd != GunBase.GunType.LMG) {
                this.weaponTypes.add(typeToAdd);
            }
        }

        @Override
        public void removeWeaponTypeFromLootGeneration(GunBase.GunType typeToRemove) {
            if (this.weaponTypes.contains((Object)typeToRemove)) {
                this.weaponTypes.remove((Object)typeToRemove);
            }
        }

        @Override
        public List<GunBase.GunType> getWeaponList() {
            return this.weaponTypes;
        }

        @Override
        public void setWeaponList(int[] enumIDs) {
            if (this.weaponTypes != null && !this.weaponTypes.isEmpty()) {
                this.weaponTypes.clear();
                for (int i = 0; i < enumIDs.length; ++i) {
                    GunBase.GunType type = GunBase.GunType.values()[i];
                    if (this.weaponTypes.contains((Object)type)) continue;
                    this.weaponTypes.add(type);
                }
            }
        }

        @Override
        public void resetWeaponLootGeneration() {
            this.weaponTypes.clear();
            for (int i = 0; i < GunBase.GunType.values().length; ++i) {
                this.weaponTypes.add(GunBase.GunType.values()[i]);
            }
            if (this.weaponTypes.contains((Object)GunBase.GunType.LMG)) {
                this.removeWeaponTypeFromLootGeneration(GunBase.GunType.LMG);
            }
        }

        @Override
        public void setGhillieSuitsColorVariants(List<Integer> list) {
            this.ghillieColors = list;
        }

        @Override
        public List<Integer> getGhillieSuitsColorVariants() {
            if (this.ghillieColors.isEmpty() && ConfigPMC.world().defaultGhillieColors.length > 0) {
                for (int i = 0; i < ConfigPMC.world().defaultGhillieColors.length; ++i) {
                    this.ghillieColors.add(ConfigPMC.world().defaultGhillieColors[i]);
                }
            }
            return this.ghillieColors;
        }

        @Override
        public void addColorVariant(int color) {
            this.ghillieColors.add(color);
        }

        @Override
        public void removeColorVariant(int color) {
            this.ghillieColors.remove(color);
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound c = new NBTTagCompound();
            c.func_74757_a("airdropWeapons", this.airdropWep);
            c.func_74757_a("ammoLoot", this.ammoLoot);
            c.func_74757_a("randomAmmo", this.randomAmmoCount);
            c.func_74780_a("chance", this.chance);
            NBTTagList weaponlist = new NBTTagList();
            for (int i = 0; i < this.weaponTypes.size(); ++i) {
                weaponlist.func_74742_a((NBTBase)new NBTTagInt(this.weaponTypes.get(i).ordinal()));
            }
            NBTTagList colors = new NBTTagList();
            for (int i = 0; i < this.ghillieColors.size(); ++i) {
                colors.func_74742_a((NBTBase)new NBTTagInt(this.ghillieColors.get(i).intValue()));
            }
            c.func_74782_a("list", (NBTBase)weaponlist);
            c.func_74782_a("colors", (NBTBase)colors);
            return c;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.weaponTypes.clear();
            this.airdropWep = nbt.func_74767_n("airdropWeapons");
            this.ammoLoot = nbt.func_74767_n("ammoLoot");
            this.randomAmmoCount = nbt.func_74767_n("randomAmmo");
            this.chance = nbt.func_74769_h("chance");
            NBTTagList list = nbt.func_150295_c("list", 3);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                this.weaponTypes.add(GunBase.GunType.values()[list.func_186858_c(i)]);
            }
            NBTTagList colors = nbt.func_150295_c("colors", 3);
            this.ghillieColors = new ArrayList<Integer>();
            for (int i = 0; i < colors.func_74745_c(); ++i) {
                this.ghillieColors.add(colors.func_186858_c(i));
            }
        }
    }

    public static class WorldDataStorage
    implements Capability.IStorage<IWorldData> {
        public NBTBase writeNBT(Capability<IWorldData> cap, IWorldData i, EnumFacing side) {
            return i.serializeNBT();
        }

        public void readNBT(Capability<IWorldData> capability, IWorldData instance, EnumFacing side, NBTBase nbt) {
            instance.deserializeNBT((NBTBase)(nbt instanceof NBTTagCompound ? (NBTTagCompound)nbt : new NBTTagCompound()));
        }
    }
}

