/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.common.commands;

import com.toma.pubgmc.api.Game;
import com.toma.pubgmc.api.Lobby;
import com.toma.pubgmc.common.capability.IGameData;
import com.toma.pubgmc.init.GameRegistry;
import com.toma.pubgmc.world.MapLocation;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class CommandGame
extends CommandBase {
    private static final String[] completions = new String[]{"start", "stop", "help", "info", "mode", "map", "lobby", "location"};

    public String func_71517_b() {
        return "game";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/game";
    }

    public int func_82362_a() {
        return 2;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length > 1) {
            if (args[0].equalsIgnoreCase("mode")) {
                return GameRegistry.getValuesPaths();
            }
            if (args[0].equalsIgnoreCase("location")) {
                return CommandGame.func_71530_a((String[])args, (String[])new String[]{"add", "remove", "list"});
            }
            if (args.length >= 2) {
                String[] arr = ((IGameData)sender.func_130014_f_().getCapability(IGameData.GameDataProvider.GAMEDATA, null)).getCurrentGame().getCommandAutoCompletions(args.length - 2, args[args.length - 1]);
                return CommandGame.func_71530_a((String[])args, (String[])arr);
            }
        }
        return args.length == 1 ? CommandGame.func_71530_a((String[])args, (String[])completions) : Collections.EMPTY_LIST;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        IGameData gameData = (IGameData)sender.func_130014_f_().getCapability(IGameData.GameDataProvider.GAMEDATA, null);
        if (gameData == null) {
            throw new CommandException("Unable to get game data!", new Object[0]);
        }
        if (args.length == 0) {
            throw new WrongUsageException("Unknown argument! Execute '/game help' for more info.", new Object[0]);
        }
        block13 : switch (args[0]) {
            case "start": {
                CommandException exception;
                String[] addtionalArgs;
                if (gameData.getMapSize() <= 0) {
                    throw new CommandException("You must setup your map first! Use /game map [centerX] [centerZ] [size]", new Object[0]);
                }
                if (gameData.getLobby() == null) {
                    throw new CommandException("You must create lobby first! Add it using the '/game lobby' command", new Object[0]);
                }
                if (gameData.isPlaying()) {
                    throw new CommandException("There is already one active game!", new Object[0]);
                }
                Game game = gameData.getCurrentGame();
                if (game == null) {
                    throw new CommandException("Unknown game mode! Select one - /game mode [game]", new Object[0]);
                }
                if (gameData.isInactiveGame()) {
                    throw new CommandException("Cannot start this type of game! Select new mode: /game mode [mode]", new Object[0]);
                }
                String[] stringArray = addtionalArgs = args.length == 1 ? new String[]{} : new String[args.length - 1];
                if (addtionalArgs.length > 0) {
                    for (int i = 1; i < args.length; ++i) {
                        addtionalArgs[i - 1] = args[i];
                    }
                }
                if ((exception = game.onGameStartCommandExecuted(sender, server, addtionalArgs)) != null) {
                    throw exception;
                }
                if (!game.startGame(sender.func_130014_f_())) {
                    throw new CommandException("Error occured when launching game! Check logs and contact GAME AUTHOR about this issue!", new Object[0]);
                }
                gameData.setPlaying(true);
                game.updateDataToClients(sender.func_130014_f_());
                this.sendCommandFeedback(sender, "Started game");
                break;
            }
            case "stop": {
                if (!gameData.isPlaying() || gameData.isInactiveGame() || gameData.getLobby() == null) {
                    throw new CommandException("There is no active game!", new Object[0]);
                }
                gameData.getCurrentGame().stopGame(sender.func_130014_f_());
                this.sendCommandFeedback(sender, "Stopped game");
                gameData.getCurrentGame().updateDataToClients(sender.func_130014_f_());
                break;
            }
            case "help": {
                if (!(sender instanceof EntityPlayer)) {
                    throw new WrongUsageException("Only players can execute this command!", new Object[0]);
                }
                EntityPlayer player = (EntityPlayer)sender;
                this.sendMessage(player, "Commands:");
                this.sendMessage(player, "start -> starts game");
                this.sendMessage(player, "stop -> stops game");
                this.sendMessage(player, "info -> information about current game settings");
                this.sendMessage(player, "mode [name: String] -> binds the game mode to this world");
                this.sendMessage(player, "map [x: int, z: int, size: int] -> creates map border");
                this.sendMessage(player, "lobby [x: int, y: int, z: int, radius: int] -> creates lobby for this world");
                this.sendMessage(player, "");
                this.sendMessage(player, "Available game modes:");
                for (String location : GameRegistry.getValuesPaths()) {
                    this.sendMessage(player, "- " + location);
                }
                break;
            }
            case "info": {
                if (!(sender instanceof EntityPlayer)) {
                    throw new WrongUsageException("Only players can execute this command!", new Object[0]);
                }
                EntityPlayer player = (EntityPlayer)sender;
                this.sendMessage(player, "=====[ Game information ]=====");
                this.sendMessage(player, "Active: " + (gameData.isPlaying() ? "yes" : "no"));
                this.sendMessage(player, "Map: [" + gameData.getMapCenter().func_177958_n() + ", " + gameData.getMapCenter().func_177952_p() + "]; Size: " + gameData.getMapSize() + " blocks");
                this.sendMessage(player, "Locations: " + gameData.getSpawnLocations().size());
                Game game = gameData.getCurrentGame();
                this.sendMessage(player, "Game: " + (gameData.isInactiveGame() ? "none" : game.registryName));
                if (gameData.isInactiveGame()) break;
                this.sendMessage(player, "Alive players: " + game.onlinePlayers);
                this.sendMessage(player, "Time: " + game.getGameTimer() / 20 + "s");
                this.sendMessage(player, "Mode: " + game.registryName.toUpperCase());
                String[] data = game.getGameInformation().gameInformation;
                if (data == null) break;
                this.sendMessage(player, "Game mode author: " + game.getGameInformation().author);
                for (int i = 0; i < data.length; ++i) {
                    this.sendMessage(player, data[i]);
                }
                break;
            }
            case "mode": {
                if (args.length < 2) {
                    throw new WrongUsageException("You must specify game mode! For all game modes use /game help", new Object[0]);
                }
                Game game = GameRegistry.findGameInRegistry(args[1]);
                if (game == null) {
                    throw new CommandException("Unknown game!", new Object[0]);
                }
                gameData.setGame(game);
                this.sendCommandFeedback(sender, "Successfully selected game " + game.registryName);
                break;
            }
            case "map": {
                int size;
                int z;
                int x;
                if (args.length < 4) {
                    throw new WrongUsageException("You must specify X, Z position and map size!", new Object[0]);
                }
                try {
                    x = Integer.parseInt(args[1]);
                    z = Integer.parseInt(args[2]);
                    size = Integer.parseInt(args[3]);
                }
                catch (NumberFormatException e) {
                    throw new CommandException("Invalid number!", new Object[0]);
                }
                gameData.setMapCenter(x, z, size);
                this.sendCommandFeedback(sender, "Successfully created game map");
                break;
            }
            case "lobby": {
                int radius;
                int z;
                int y;
                int x;
                if (args.length < 5) {
                    throw new WrongUsageException("You must specify X,Y,Z position and radius!", new Object[0]);
                }
                try {
                    x = Integer.parseInt(args[1]);
                    y = Integer.parseInt(args[2]);
                    z = Integer.parseInt(args[3]);
                    radius = Integer.parseInt(args[4]);
                }
                catch (NumberFormatException e) {
                    throw new CommandException("Invalid number!", new Object[0]);
                }
                Lobby lobby = new Lobby(new BlockPos(x, y, z), radius);
                gameData.setLobby(lobby);
                this.sendCommandFeedback(sender, "Created new game lobby. Now you can use '/leave' to get there");
                break;
            }
            case "location": {
                if (args.length < 2) {
                    throw new CommandException("Unknown operation! Use /game location [add;remove;list]", new Object[0]);
                }
                switch (args[1]) {
                    case "add": {
                        int z;
                        int y;
                        int x;
                        if (args.length < 6) {
                            throw new WrongUsageException("Unknown arguments! Use /game location add [x] [y] [z] [name]", new Object[0]);
                        }
                        try {
                            x = Integer.parseInt(args[2]);
                            y = Integer.parseInt(args[3]);
                            z = Integer.parseInt(args[4]);
                        }
                        catch (NumberFormatException e) {
                            throw new CommandException("Invalid number!", new Object[0]);
                        }
                        String name = args[5];
                        gameData.addSpawnLocation(new MapLocation(name, new BlockPos(x, y, z)));
                        this.sendCommandFeedback(sender, "Added new map location into this world");
                        break block13;
                    }
                    case "remove": {
                        if (args.length < 3) {
                            throw new WrongUsageException("Unknown arguments! Use /game location remove [locationName]", new Object[0]);
                        }
                        String locName = args[2];
                        MapLocation location = MapLocation.findLocation(locName, gameData);
                        if (location == null) {
                            throw new CommandException("There is no such location with name " + locName, new Object[0]);
                        }
                        gameData.getSpawnLocations().remove(location);
                        this.sendCommandFeedback(sender, "Removed map location: " + location.toString());
                        break block13;
                    }
                    case "list": {
                        for (int i = 0; i < gameData.getSpawnLocations().size(); ++i) {
                            MapLocation location = gameData.getSpawnLocations().get(i);
                            sender.func_145747_a((ITextComponent)new TextComponentString("- " + location.toString()));
                        }
                        break block13;
                    }
                    default: {
                        throw new WrongUsageException("Unknown argument! Use /game location [add;remove;list]", new Object[0]);
                    }
                }
            }
            default: {
                throw new WrongUsageException("Unknown argument! Execute '/game help' for more info.", new Object[0]);
            }
        }
    }

    private void sendMessage(EntityPlayer player, String text) {
        player.func_145747_a((ITextComponent)new TextComponentString(text));
    }

    private void sendCommandFeedback(ICommandSender sender, String feedback) {
        if (sender.func_174792_t_()) {
            sender.func_145747_a((ITextComponent)new TextComponentString(feedback));
        }
    }
}

