/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.common.commands;

import com.toma.pubgmc.common.blocks.BlockLootSpawner;
import com.toma.pubgmc.common.capability.IGameData;
import com.toma.pubgmc.common.capability.IWorldData;
import com.toma.pubgmc.common.items.guns.GunBase;
import com.toma.pubgmc.common.tileentity.TileEntityLootGenerator;
import com.toma.pubgmc.network.PacketHandler;
import com.toma.pubgmc.network.sp.PacketDisplayLootSetupGui;
import com.toma.pubgmc.util.PUBGMCUtil;
import com.toma.pubgmc.util.TileEntityUtil;
import com.toma.pubgmc.util.game.loot.ILootSpawner;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;

public class CommandLootGenerate
extends CommandBase {
    public String func_71517_b() {
        return "loot";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/loot";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        IWorldData worldData = null;
        if (sender.func_130014_f_().hasCapability(IWorldData.WorldDataProvider.WORLD_DATA, null)) {
            worldData = (IWorldData)sender.func_130014_f_().getCapability(IWorldData.WorldDataProvider.WORLD_DATA, null);
        }
        if (args.length == 0) {
            throw new WrongUsageException("You must specify operation. Use /loot help", new Object[0]);
        }
        if (args.length > 0) {
            this.executeBasic(server, sender, args, worldData);
        }
    }

    private void executeBasic(MinecraftServer server, ICommandSender sender, String[] args, IWorldData data) {
        World world = sender.func_130014_f_();
        if (args[0].equalsIgnoreCase("help")) {
            String[] messages = new String[]{"- generate [Blockpos, range] >> will generate loot with current command settings", "- clear >> clear all loaded loot spawners", "- show >> fills all loaded loot spawners with loot to make it easier for spotting", "- info >> info about current loot setting", "- reset >> reset all current setting to default", "- setup >> here you can setup multiple things for loot generation", "- delete >> delete all loaded loot spawners", "- count >> Total count of all loaded loot spawners"};
            for (int i = 0; i < messages.length; ++i) {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + messages[i]));
            }
        } else if (args[0].equalsIgnoreCase("info")) {
            sender.func_145747_a((ITextComponent)new TextComponentString(this.getDefaultInfoFormat("Airdrop Weapons: ") + this.getTextColorFormatting(data.hasAirdropWeapons())));
            sender.func_145747_a((ITextComponent)new TextComponentString(this.getDefaultInfoFormat("Ammo Loot: ") + this.getTextColorFormatting(data.isAmmoLootEnabled())));
            sender.func_145747_a((ITextComponent)new TextComponentString(this.getDefaultInfoFormat("Random Ammo Count: ") + this.getTextColorFormatting(data.isRandomAmmoCountEnabled())));
            sender.func_145747_a((ITextComponent)new TextComponentString(this.getDefaultInfoFormat("Weapons: ") + this.getColorBasedOnList(data.getWeaponList())));
            sender.func_145747_a((ITextComponent)new TextComponentString(this.getDefaultInfoFormat("Chance Multiplier: ") + this.getNumberFormatting(data.getLootChanceMultiplier()) + "x"));
        } else if (args[0].equalsIgnoreCase("reset")) {
            data.toggleAirdropWeapons(false);
            data.toggleAmmoLoot(true);
            data.toggleRandomAmmoCount(false);
            this.resetWeapons(data);
            data.setLootChanceMultiplier(1.0);
            if (this.shouldSendCommandFeedback(world.func_82736_K())) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Reseting all values..."));
            }
        } else if (args[0].equalsIgnoreCase("generate")) {
            IGameData game = (IGameData)world.getCapability(IGameData.GameDataProvider.GAMEDATA, null);
            int count = 0;
            if (args.length == 5 && this.isValidNumber(args[1]) && this.isValidNumber(args[2]) && this.isValidNumber(args[3]) && this.isValidNumber(args[4])) {
                BlockPos gen = new BlockPos(Double.parseDouble(args[1]), Double.parseDouble(args[2]), Double.parseDouble(args[3]));
                int range = Integer.parseInt(args[4]);
                if (world.func_175667_e(gen)) {
                    for (TileEntity te : world.field_147482_g) {
                        BlockPos lootPos;
                        double totalRange;
                        if (!(te instanceof ILootSpawner) || !((totalRange = PUBGMCUtil.getDistanceToBlockPos3D(lootPos = te.func_174877_v(), gen)) <= (double)range)) continue;
                        ++count;
                        ((ILootSpawner)te).setGameHash(game.getGameID());
                        ((ILootSpawner)te).onLoaded();
                        TileEntityUtil.syncToClient(te);
                    }
                }
            } else {
                for (TileEntity te : sender.func_130014_f_().field_147482_g) {
                    if (!(te instanceof ILootSpawner)) continue;
                    ++count;
                    ((ILootSpawner)te).setGameHash(game.getGameID());
                    ((ILootSpawner)te).onLoaded();
                    TileEntityUtil.syncToClient(te);
                }
            }
            if (this.shouldSendCommandFeedback(world.func_82736_K())) {
                if (!data.getWeaponList().isEmpty() && data.getLootChanceMultiplier() > 0.0) {
                    if (count == 0) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Couldn't locate any loot spawners, try again."));
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Generated loot inside " + TextFormatting.YELLOW + count + TextFormatting.GREEN + " loot spawners"));
                    }
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Attempted to generate loot, but weapons are disabled. Execute '/loot reset' to fix that"));
                }
            }
        } else if (args[0].equalsIgnoreCase("clear")) {
            for (TileEntity te : sender.func_130014_f_().field_147482_g) {
                if (!(te instanceof TileEntityLootGenerator)) continue;
                ((TileEntityLootGenerator)te).func_174888_l();
                TileEntityUtil.syncToClient(te);
            }
            if (this.shouldSendCommandFeedback(world.func_82736_K())) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Cleared loot inside all loaded loot spawners"));
            }
        } else if (args[0].equalsIgnoreCase("show")) {
            int counter = 0;
            ItemStack[] stack = new ItemStack[]{new ItemStack(Items.field_151100_aR, 1, 1), new ItemStack(Items.field_151100_aR, 1, 11), new ItemStack(Items.field_151100_aR, 1, 10)};
            for (TileEntity te : sender.func_130014_f_().field_147482_g) {
                if (!(te instanceof TileEntityLootGenerator)) continue;
                ++counter;
                int tier = (Integer)world.func_180495_p(te.func_174877_v()).func_177229_b((IProperty)BlockLootSpawner.LOOT);
                for (int i = 0; i < ((TileEntityLootGenerator)te).func_70302_i_(); ++i) {
                    ((TileEntityLootGenerator)te).func_70299_a(i, stack[tier].func_77946_l());
                    TileEntityUtil.syncToClient(te);
                }
            }
            if (this.shouldSendCommandFeedback(world.func_82736_K())) {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Currently showing " + TextFormatting.YELLOW + counter + TextFormatting.GREEN + " loot spawners"));
            }
        } else if (args[0].equalsIgnoreCase("setup")) {
            if (sender instanceof EntityPlayerMP) {
                PacketHandler.sendToClient(new PacketDisplayLootSetupGui((NBTTagCompound)data.serializeNBT()), (EntityPlayerMP)sender);
            }
        } else if (args[0].equalsIgnoreCase("count")) {
            int total = 0;
            for (TileEntity te : world.field_147482_g) {
                if (!(te instanceof TileEntityLootGenerator)) continue;
                ++total;
            }
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Loaded loot spawners: " + TextFormatting.YELLOW + total + TextFormatting.GREEN + "."));
        } else if (args[0].equalsIgnoreCase("delete")) {
            int count = 0;
            Iterator iterator = world.field_147482_g.iterator();
            while (iterator.hasNext()) {
                TileEntity tileEntity = (TileEntity)iterator.next();
                if (!(tileEntity instanceof ILootSpawner) || !((ILootSpawner)tileEntity).generateLootOnCommand()) continue;
                iterator.remove();
                world.func_175655_b(tileEntity.func_174877_v(), false);
                ++count;
            }
            if (this.shouldSendCommandFeedback(world.func_82736_K())) {
                if (count == 0) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "There are no loaded loot spawners!"));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Removed " + TextFormatting.YELLOW + count + TextFormatting.GREEN + " loot spawners!"));
                }
            }
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Unknown operation, try /loot help"));
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1) {
            return CommandLootGenerate.func_71530_a((String[])args, (String[])new String[]{"help", "info", "clear", "generate", "setup", "reset", "count", "delete", "show"});
        }
        return Collections.EMPTY_LIST;
    }

    private boolean isStringDouble(String text) {
        char[] c = text.toCharArray();
        boolean valid = true;
        boolean alreadyUsedDot = false;
        for (char value : c) {
            if (Character.isDigit(value) || value == '.') {
                if (alreadyUsedDot && value == '.') {
                    valid = false;
                }
                if (value != '.' || alreadyUsedDot) continue;
                alreadyUsedDot = true;
                continue;
            }
            valid = false;
        }
        return valid;
    }

    private boolean isValidNumber(String s) {
        char[] num = s.toCharArray();
        boolean valid = true;
        if (num[0] == '-' || Character.isDigit(num[0])) {
            for (int i = 1; i < num.length; ++i) {
                if (Character.isDigit(num[i])) continue;
                return false;
            }
        }
        return true;
    }

    private void resetWeapons(IWorldData data) {
        data.resetWeaponLootGeneration();
    }

    private boolean shouldSendCommandFeedback(GameRules rules) {
        return rules.func_82766_b("sendCommandFeedback");
    }

    private String getTextColorFormatting(boolean input) {
        return input ? TextFormatting.GREEN + "" + input : TextFormatting.RED + "" + input;
    }

    private String getNumberFormatting(double input) {
        if (input <= 0.0) {
            return TextFormatting.RED + "" + input;
        }
        if (input > 0.0 && input < 1.5) {
            return TextFormatting.YELLOW + "" + input;
        }
        if (input >= 1.5 && input < 5.0) {
            return TextFormatting.GREEN + "" + input;
        }
        return TextFormatting.DARK_GREEN + "" + input;
    }

    private String getColorBasedOnList(List<GunBase.GunType> list) {
        switch (list.size()) {
            case 0: {
                return TextFormatting.DARK_RED + "" + list;
            }
            case 1: {
                return TextFormatting.RED + "" + list;
            }
            case 2: {
                return TextFormatting.GOLD + "" + list;
            }
            case 3: {
                return TextFormatting.YELLOW + "" + list;
            }
            case 4: {
                return TextFormatting.GREEN + "" + list;
            }
        }
        return TextFormatting.DARK_GREEN + "" + list;
    }

    private String getDefaultInfoFormat(String textToShow) {
        return TextFormatting.GRAY + textToShow;
    }
}

