/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.common.commands;

import com.toma.pubgmc.common.capability.IWorldData;
import com.toma.pubgmc.util.PUBGMCUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class CommandManageGhillieVariants
extends CommandBase {
    private final String[] args = new String[]{"add", "remove", "list"};

    public String func_71517_b() {
        return "ghillie";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/ghillie [add, remove, list] <color>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        World world = sender.func_130014_f_();
        IWorldData data = (IWorldData)world.getCapability(IWorldData.WorldDataProvider.WORLD_DATA, null);
        if (data == null) {
            throw new CommandException("Unable to get world capability data!", new Object[0]);
        }
        if (args.length == 0) {
            throw new CommandException("Unknown operation. Use /ghillie <add,remove,list>", new Object[0]);
        }
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase(this.args[0])) {
                int color;
                if (args.length < 2) {
                    throw new WrongUsageException("You must define color", new Object[0]);
                }
                try {
                    color = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException e) {
                    throw new WrongUsageException("This is not a valid number: " + args[1] + "!", new Object[0]);
                }
                if (PUBGMCUtil.contains(color, data.getGhillieSuitsColorVariants().toArray(new Integer[0]))) {
                    throw new CommandException("This color is already registered!", new Object[0]);
                }
                data.addColorVariant(color);
                this.sendFeedback(sender, "Successfully added new color variant");
            } else if (args[0].equalsIgnoreCase(this.args[1])) {
                int index;
                if (args.length < 2) {
                    throw new WrongUsageException("You must define color index!", new Object[0]);
                }
                try {
                    index = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException e) {
                    throw new WrongUsageException("This is not a valid number: " + args[1] + "!", new Object[0]);
                }
                index = Math.abs(index);
                if (index >= data.getGhillieSuitsColorVariants().size()) {
                    throw new CommandException("Invalid index, max: " + (data.getGhillieSuitsColorVariants().size() - 1), new Object[0]);
                }
                int removed = data.getGhillieSuitsColorVariants().remove(index);
                this.sendFeedback(sender, "You have deleted the color " + removed);
            } else if (args[0].equalsIgnoreCase(this.args[2])) {
                List<Integer> list = data.getGhillieSuitsColorVariants();
                sender.func_145747_a((ITextComponent)new TextComponentString("Registered colors: "));
                for (int i = 0; i < list.size(); ++i) {
                    TextComponentString textComponentString = new TextComponentString("- " + list.get(i));
                    sender.func_145747_a((ITextComponent)textComponentString);
                }
            } else {
                throw new CommandException("Unknown command operation! Try /ghillie <add,remove,list>", new Object[0]);
            }
        }
    }

    public int func_82362_a() {
        return 2;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return super.func_184883_a(server, sender, args, targetPos);
    }

    public void sendFeedback(ICommandSender sender, String feedback) {
        if (sender.func_174792_t_()) {
            sender.func_145747_a((ITextComponent)new TextComponentString(feedback));
        }
    }
}

