/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.common.commands;

import com.toma.pubgmc.Pubgmc;
import com.toma.pubgmc.common.capability.IPlayerData;
import com.toma.pubgmc.network.PacketHandler;
import com.toma.pubgmc.util.PUBGMCUtil;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class CommandPlayerData
extends CommandBase {
    static final String[] subCmd = new String[]{"backpackLevel", "boost", "nightVision", "resetAll"};

    public String func_71517_b() {
        return "playerdata";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/playerdata [player/all/me]" + subCmd[0] + " <value>";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            throw new WrongUsageException("Unknown operation, use /playerdata [player] <data> <value>", new Object[0]);
        }
        if (args.length > 1) {
            if (args[0].equalsIgnoreCase("me")) {
                if (sender instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)sender;
                    if (player.hasCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null)) {
                        IPlayerData data = (IPlayerData)player.getCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null);
                        this.updateData(server, args, player, data, sender, true);
                    } else {
                        Pubgmc.logger.warn("Couldn't modify data of {}, no data found!", (Object)player.func_70005_c_());
                    }
                }
            } else if (args[0].equalsIgnoreCase("all")) {
                for (EntityPlayer player : sender.func_130014_f_().field_73010_i) {
                    if (player.hasCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null)) {
                        IPlayerData data = (IPlayerData)player.getCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null);
                        this.updateData(server, args, player, data, sender, false);
                        continue;
                    }
                    Pubgmc.logger.warn("Couldn't modify data of {}, no data found!", (Object)player.func_70005_c_());
                }
            } else if (server.func_184103_al().func_152612_a(args[0]) != null) {
                EntityPlayerMP player = server.func_184103_al().func_152612_a(args[0]);
                if (player.hasCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null)) {
                    IPlayerData data = (IPlayerData)player.getCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null);
                    this.updateData(server, args, (EntityPlayer)player, data, sender, true);
                } else {
                    Pubgmc.logger.warn("Couldn't modify data of {}, no data found!", (Object)player.func_70005_c_());
                }
            } else {
                throw new WrongUsageException("Unknown target, try /playerdata <me,all,playerName>", new Object[0]);
            }
        }
    }

    private void updateData(MinecraftServer server, String[] args, EntityPlayer player, IPlayerData data, ICommandSender sender, boolean feedback) throws CommandException {
        switch (args[1]) {
            case "backpackLevel": {
                if (args.length > 1) {
                    if (args.length > 2 && PUBGMCUtil.isValidNumber(args[2])) {
                        int num = Integer.parseInt(args[2]);
                        if (num >= 0 && num < 4) {
                            data.setBackpackLevel(num);
                            if (!feedback) break;
                            this.sendFeedback(sender, "Updated backpack level of " + player.func_70005_c_());
                            break;
                        }
                        if (!feedback) break;
                        this.sendFeedback(sender, TextFormatting.RED + "Number must be in range 0-3!");
                        break;
                    }
                    if (!feedback) break;
                    this.sendFeedback(sender, player.func_70005_c_() + " has backpack level = " + data.getBackpackLevel());
                    break;
                }
                if (!feedback) break;
                this.sendFeedback(sender, player.func_70005_c_() + " has backpack level = " + data.getBackpackLevel());
                break;
            }
            case "boost": {
                if (args.length > 1) {
                    if (args.length > 2 && PUBGMCUtil.isValidNumber(args[2])) {
                        int num = Integer.parseInt(args[2]);
                        if (num >= 0 && num <= 100) {
                            data.setBoost(num);
                            if (!feedback) break;
                            this.sendFeedback(sender, "Updated boost level of " + player.func_70005_c_());
                            break;
                        }
                        if (!feedback) break;
                        this.sendFeedback(sender, TextFormatting.RED + "Number must be in range 0-100!");
                        break;
                    }
                    if (!feedback) break;
                    this.sendFeedback(sender, player.func_70005_c_() + " has boost level = " + data.getBoost());
                    break;
                }
                if (!feedback) break;
                this.sendFeedback(sender, player.func_70005_c_() + " has boost level = " + data.getBoost());
                break;
            }
            case "nightVision": {
                if (args.length > 1) {
                    if (args.length > 2 && (args[2].equalsIgnoreCase("false") || args[2].equalsIgnoreCase("true"))) {
                        boolean b = Boolean.parseBoolean(args[2]);
                        data.hasEquippedNV(b);
                        if (!feedback) break;
                        this.sendFeedback(sender, "Updated state of night vision of " + player.func_70005_c_() + " to " + b);
                        break;
                    }
                    if (!feedback) break;
                    this.sendFeedback(sender, "Equipped NV: " + data.getEquippedNV());
                    break;
                }
                if (!feedback) break;
                this.sendFeedback(sender, "Equipped NV: " + data.getEquippedNV());
                break;
            }
            case "resetAll": {
                data.setBackpackLevel(0);
                data.setBoost(0.0f);
                data.hasEquippedNV(false);
                if (!feedback) break;
                this.sendFeedback(sender, "Data of " + player.func_70005_c_() + " has been reset");
            }
        }
        if (player instanceof EntityPlayerMP) {
            PacketHandler.syncPlayerDataToClient(data, (EntityPlayerMP)player);
        }
    }

    private void sendFeedback(ICommandSender sender, String message) {
        sender.func_145747_a((ITextComponent)new TextComponentString(message));
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1) {
            return CommandPlayerData.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        if (args.length == 2) {
            return CommandPlayerData.func_71530_a((String[])args, (String[])subCmd);
        }
        if (args.length == 3 && args[1].equalsIgnoreCase(subCmd[2])) {
            return CommandPlayerData.func_71530_a((String[])args, (String[])new String[]{"true", "false"});
        }
        return Collections.EMPTY_LIST;
    }
}

