/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.common.entity;

import com.toma.pubgmc.common.capability.IGameData;
import com.toma.pubgmc.common.tileentity.TileEntityAirdrop;
import com.toma.pubgmc.config.ConfigPMC;
import com.toma.pubgmc.init.PMCRegistry;
import com.toma.pubgmc.util.PUBGMCUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityAirdrop
extends Entity
implements IEntityAdditionalSpawnData {
    private boolean isBigDrop;
    private String hash;

    public EntityAirdrop(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.isBigDrop = false;
        IGameData gameData = (IGameData)world.getCapability(IGameData.GameDataProvider.GAMEDATA, null);
        this.hash = gameData == null ? "empty" : gameData.getGameID();
    }

    public EntityAirdrop(World world, BlockPos pos, boolean type) {
        this(world);
        this.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        this.isBigDrop = type;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.handleMotion(0.15);
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 20 == 0 && !((IGameData)this.field_70170_p.getCapability(IGameData.GameDataProvider.GAMEDATA, null)).getGameID().equals(this.hash)) {
            this.func_70106_y();
        }
    }

    public void onEntityLanded() {
        IBlockState state = this.isBigDrop ? PMCRegistry.PMCBlocks.BIG_AIRDROP.func_176223_P() : PMCRegistry.PMCBlocks.AIRDROP.func_176223_P();
        this.field_70170_p.func_180501_a(this.func_180425_c(), state, 3);
        if (this.field_70170_p.func_175625_s(this.func_180425_c()) instanceof TileEntityAirdrop && ConfigPMC.common.world.airdropLoot.ordinal() > 0) {
            ((TileEntityAirdrop)this.field_70170_p.func_175625_s(this.func_180425_c())).onLanded();
        }
    }

    public boolean getType() {
        return this.isBigDrop;
    }

    public boolean func_70112_a(double distance) {
        return true;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        PUBGMCUtil.readBasicEntityNBT(compound, this);
        this.isBigDrop = compound.func_74767_n("dropType");
        this.hash = compound.func_74764_b("hash") ? compound.func_74779_i("hash") : "empty";
    }

    protected void func_70014_b(NBTTagCompound compound) {
        PUBGMCUtil.writeBasicEntityNBT(compound, this);
        compound.func_74757_a("dropType", this.isBigDrop);
        compound.func_74778_a("hash", this.hash);
    }

    public void readSpawnData(ByteBuf buf) {
        this.isBigDrop = buf.readBoolean();
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeBoolean(this.isBigDrop);
    }

    protected void func_70088_a() {
    }

    private void handleMotion(double motion) {
        if (!this.field_70122_E) {
            this.field_70181_x = -motion;
        } else {
            if (!this.field_70170_p.field_72995_K) {
                this.onEntityLanded();
            }
            this.func_70106_y();
        }
    }
}

