/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.common.entity;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.toma.pubgmc.common.blocks.BlockLandMine;
import com.toma.pubgmc.common.blocks.BlockWindow;
import com.toma.pubgmc.common.blocks.IBulletReaction;
import com.toma.pubgmc.common.capability.IPlayerData;
import com.toma.pubgmc.common.entity.EntityVehicle;
import com.toma.pubgmc.common.items.armor.ArmorBase;
import com.toma.pubgmc.common.items.guns.GunBase;
import com.toma.pubgmc.common.tileentity.TileEntityLandMine;
import com.toma.pubgmc.config.common.CFGWeapon;
import com.toma.pubgmc.init.DamageSourceGun;
import com.toma.pubgmc.init.PMCRegistry;
import com.toma.pubgmc.init.PMCSounds;
import com.toma.pubgmc.network.PacketHandler;
import com.toma.pubgmc.network.sp.PacketParticle;
import com.toma.pubgmc.util.PUBGMCUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityBullet
extends Entity {
    private static final Predicate<Entity> ARROW_TARGETS = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d, EntitySelectors.field_94557_a, Entity::func_70067_L});
    private int shooterId;
    private EntityLivingBase shooter;
    private int gravitystart;
    private double velocity;
    private double gravity;
    private float damage;
    private GunBase.GunType type;
    private int survivalTime;
    private ItemStack stack;
    private RayTraceResult entityRaytrace;

    public EntityBullet(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.1f, 0.1f);
        this.field_70156_m = true;
    }

    public EntityBullet(World worldIn, EntityLivingBase shooter, GunBase gun) {
        this(worldIn);
        this.func_70105_a(0.1f, 0.1f);
        this.field_70145_X = true;
        this.shooterId = shooter.func_145782_y();
        this.shooter = shooter;
        CFGWeapon cfg = gun.getConfigurableStats();
        this.gravitystart = cfg.gravityEffectStart;
        this.gravity = cfg.gravityModifier;
        this.velocity = cfg.velocity;
        this.damage = cfg.damage;
        this.type = gun.getGunType();
        this.survivalTime = (int)this.velocity + 3;
        this.stack = new ItemStack((Item)gun);
        Vec3d direct = this.func_174806_f(shooter.field_70125_A + this.getPitchRotationInaccuracy(shooter), shooter.func_70079_am() + this.getYawRotationInaccuracy(shooter));
        if (shooter instanceof EntityPlayer) {
            IPlayerData data = (IPlayerData)shooter.getCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null);
            this.calculateBulletHeading(direct, (EntityPlayer)shooter, data.isAiming());
            this.func_70107_b(shooter.field_70165_t, data.isProning() ? shooter.field_70163_u + 0.5 : shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v);
        } else {
            this.calculateBulletHeading(direct, shooter, 2 + this.field_70170_p.func_175659_aa().ordinal());
            this.func_70107_b(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v);
        }
        this.updateHeading();
    }

    public EntityLivingBase getShooter() {
        return this.shooter;
    }

    public void onBulletCollided(RayTraceResult rayTraceResult) {
        if (rayTraceResult == null) {
            return;
        }
        Entity entity = rayTraceResult.field_72308_g;
        if (entity != null && !this.field_70170_p.field_72995_K) {
            Block block;
            boolean isHeadshot = this.canEntityGetHeadshot(entity) && this.entityRaytrace.field_72307_f.field_72448_b >= (double)((float)entity.func_180425_c().func_177956_o() + entity.func_70047_e() - 0.15f);
            Vec3d vec = rayTraceResult.field_72307_f;
            Block block2 = block = entity instanceof EntityVehicle ? Blocks.field_150340_R : Blocks.field_150451_bX;
            if (isHeadshot) {
                this.damage = (float)((double)this.damage * 2.5);
            }
            if (entity instanceof EntityLivingBase || entity instanceof EntityVehicle) {
                PacketHandler.sendToDimension((IMessage)new PacketParticle(EnumParticleTypes.BLOCK_CRACK, 2 * Math.round(this.damage), vec.field_72450_a, this.entityRaytrace.field_72307_f.field_72448_b, vec.field_72449_c, block, PacketParticle.ParticleAction.HIT_EFFECT, 0), this.field_71093_bK);
            }
            this.onEntityHit(isHeadshot, entity);
            entity.field_70172_ad = 0;
            this.func_70106_y();
        } else if (rayTraceResult.func_178782_a() != null && !this.field_70170_p.field_72995_K) {
            BlockPos pos = rayTraceResult.func_178782_a();
            IBlockState state = this.field_70170_p.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (block instanceof IBulletReaction && ((IBulletReaction)block).canReceiveFeedBack(this.field_70170_p, rayTraceResult.func_178782_a(), state)) {
                ((IBulletReaction)block).onHit(this, rayTraceResult.field_72307_f);
            }
            boolean griefingFlag = this.field_70170_p.func_82736_K().func_82766_b("weaponGriefing");
            boolean canBePenetrated = false;
            if (block instanceof BlockWindow) {
                canBePenetrated = true;
                ((BlockWindow)block).breakWindow(state, pos, this.field_70170_p);
            } else if (state.func_185904_a() == Material.field_151592_s) {
                if (griefingFlag) {
                    this.field_70170_p.func_175698_g(pos);
                    this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187561_bM, SoundCategory.BLOCKS, 3.0f, 1.0f);
                }
                canBePenetrated = griefingFlag;
            } else if (!block.func_176200_f((IBlockAccess)this.field_70170_p, pos)) {
                Vec3d vec = rayTraceResult.field_72307_f;
                PacketHandler.sendToDimension((IMessage)new PacketParticle(EnumParticleTypes.BLOCK_CRACK, 10, vec, pos, PacketParticle.ParticleAction.SPREAD_RANDOMLY, 0), this.field_71093_bK);
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, block.func_185467_w().func_185845_c(), SoundCategory.BLOCKS, 0.5f, block.func_185467_w().func_185847_b() * 0.8f);
                if (block instanceof BlockLandMine) {
                    ((TileEntityLandMine)this.field_70170_p.func_175625_s(pos)).explode(this.field_70170_p, pos);
                }
                this.func_70106_y();
            }
            if (canBePenetrated && this.damage > 0.0f) {
                RayTraceResult trace;
                Vec3d startVec = PUBGMCUtil.getPositionVec(this);
                Vec3d nextPos = PUBGMCUtil.getMotionVec(this);
                Entity e = this.findEntityOnPath(nextPos, startVec, trace = this.field_70170_p.func_147447_a(nextPos, startVec, false, true, false));
                if (e != null) {
                    trace = new RayTraceResult(e);
                }
                if (trace != null && rayTraceResult.field_72308_g instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)rayTraceResult.field_72308_g;
                    if (this.shooter instanceof EntityPlayer && !((EntityPlayer)this.shooter).func_96122_a(player)) {
                        trace = null;
                    }
                }
                if (trace != null) {
                    this.onBulletCollided(trace);
                }
            }
        }
    }

    public void func_70071_h_() {
        Entity entity;
        super.func_70071_h_();
        this.updateHeading();
        Vec3d vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(vec3d1, vec3d, false, true, false);
        if (this.field_70173_aa > this.gravitystart && !this.field_70170_p.field_72995_K) {
            this.field_70181_x -= this.gravity;
        }
        if ((double)this.field_70173_aa >= this.velocity * 3.0) {
            this.func_70106_y();
        }
        if (this.field_70173_aa > 2 && this.field_70173_aa % 2 == 0) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, PMCSounds.bullet_whizz, SoundCategory.PLAYERS, 0.1f, 1.0f);
        }
        if (this.type == GunBase.GunType.SHOTGUN && !this.field_70170_p.field_72995_K && this.field_70173_aa % 2 == 0 && this.damage > 1.0f) {
            this.damage -= 1.0f;
            if (this.damage <= 0.0f) {
                this.damage = 1.0f;
            }
        }
        if ((entity = this.findEntityOnPath(vec3d1, vec3d, raytraceresult)) != null) {
            raytraceresult = new RayTraceResult(entity);
        }
        if (raytraceresult != null && raytraceresult.field_72308_g instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)raytraceresult.field_72308_g;
            if (this.shooter instanceof EntityPlayer && !((EntityPlayer)this.shooter).func_96122_a(entityplayer)) {
                raytraceresult = null;
            }
        }
        if (raytraceresult != null && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
            this.onBulletCollided(raytraceresult);
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    public boolean func_70112_a(double distance) {
        return false;
    }

    @Nullable
    protected Entity findEntityOnPath(Vec3d start, Vec3d end, RayTraceResult trace) {
        Entity entity = null;
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0), ARROW_TARGETS);
        double d0 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult;
            Entity entity1 = (Entity)list.get(i);
            if (entity1 == this.shooter || (raytraceresult = (axisalignedbb = entity1.func_174813_aQ()).func_72327_a(start, end)) == null) continue;
            if (trace != null && this.getDistanceTo(trace.field_72307_f) < this.getDistanceTo(raytraceresult.field_72307_f)) {
                return entity;
            }
            double d1 = start.func_72436_e(raytraceresult.field_72307_f);
            this.entityRaytrace = raytraceresult;
            if (!(d1 < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity;
    }

    protected void onEntityHit(boolean isHeadshot, Entity entity) {
        DamageSource gunsource = new DamageSourceGun("generic", (Entity)this.shooter, entity, this.stack, isHeadshot).func_76348_h();
        if (entity instanceof EntityLivingBase) {
            this.getCalculatedDamage((EntityLivingBase)entity, isHeadshot);
        }
        entity.func_70097_a(gunsource, this.damage);
    }

    protected void func_70088_a() {
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74780_a("x", this.field_70165_t);
        compound.func_74780_a("y", this.field_70163_u);
        compound.func_74780_a("z", this.field_70161_v);
        compound.func_74780_a("movx", this.field_70159_w);
        compound.func_74780_a("movy", this.field_70181_x);
        compound.func_74780_a("movz", this.field_70179_y);
        compound.func_74768_a("lifespan", this.field_70173_aa);
        compound.func_74776_a("bullet_damage", this.damage);
        compound.func_74780_a("bullet_velocity", this.velocity);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.field_70165_t = compound.func_74769_h("x");
        this.field_70163_u = compound.func_74769_h("y");
        this.field_70161_v = compound.func_74769_h("z");
        this.field_70159_w = compound.func_74769_h("movx");
        this.field_70181_x = compound.func_74769_h("movy");
        this.field_70179_y = compound.func_74769_h("movz");
        this.field_70173_aa = compound.func_74762_e("lifespan");
        this.damage = compound.func_74760_g("bullet_damage");
        this.velocity = compound.func_74769_h("bullet_velocity");
    }

    private boolean canEntityGetHeadshot(Entity e) {
        double ratio = e.field_70131_O / e.field_70130_N;
        return ratio > 1.0;
    }

    private float getPitchRotationInaccuracy(EntityLivingBase shooter) {
        if (!shooter.func_70051_ag()) {
            return 0.0f;
        }
        return (this.type.equals((Object)GunBase.GunType.PISTOL) || this.type.equals((Object)GunBase.GunType.SMG) || shooter.func_184614_ca().func_77973_b() == PMCRegistry.PMCItems.SAWED_OFF) && shooter.func_184614_ca().func_77973_b() != PMCRegistry.PMCItems.WIN94 ? -35.0f : 0.0f;
    }

    private float getYawRotationInaccuracy(EntityLivingBase shooter) {
        if (!shooter.func_70051_ag()) {
            return 0.0f;
        }
        return this.getPitchRotationInaccuracy(shooter) == -35.0f ? 0.0f : -60.0f;
    }

    private void calculateBulletHeading(Vec3d rotVec, EntityPlayer shooter, boolean aim) {
        if (aim && this.type != GunBase.GunType.SHOTGUN) {
            this.field_70159_w = rotVec.field_72450_a * this.velocity;
            this.field_70181_x = rotVec.field_72448_b * this.velocity;
            this.field_70179_y = rotVec.field_72449_c * this.velocity;
        } else {
            this.field_70159_w = rotVec.field_72450_a * this.velocity + (this.field_70146_Z.nextDouble() - 0.5);
            this.field_70181_x = rotVec.field_72448_b * this.velocity + (this.field_70146_Z.nextDouble() - 0.5);
            this.field_70179_y = rotVec.field_72449_c * this.velocity + (this.field_70146_Z.nextDouble() - 0.5);
        }
    }

    private void calculateBulletHeading(Vec3d rotVec, EntityLivingBase shooter, int accuracy) {
        if (accuracy == 0) {
            accuracy = 1;
        }
        this.field_70159_w = rotVec.field_72450_a * this.velocity + this.field_70146_Z.nextDouble() / (double)accuracy - this.field_70146_Z.nextDouble() / (double)accuracy;
        this.field_70181_x = rotVec.field_72448_b * this.velocity + this.field_70146_Z.nextDouble() / (double)accuracy - this.field_70146_Z.nextDouble() / (double)accuracy;
        this.field_70179_y = rotVec.field_72449_c * this.velocity + this.field_70146_Z.nextDouble() / (double)accuracy - this.field_70146_Z.nextDouble() / (double)accuracy;
    }

    private void updateHeading() {
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    private double getDistanceTo(Vec3d vec) {
        Vec3d start = PUBGMCUtil.getPositionVec(this);
        return PUBGMCUtil.getDistanceToBlockPos3D(new BlockPos(start), new BlockPos(vec));
    }

    private void getCalculatedDamage(EntityLivingBase entity, boolean isHeadShot) {
        float baseDamage = this.damage;
        if (isHeadShot) {
            ItemStack head = entity.func_184582_a(EntityEquipmentSlot.HEAD);
            if (head.func_77973_b() == PMCRegistry.PMCItems.ARMOR1HELMET) {
                this.damage *= 0.7f;
            } else if (head.func_77973_b() == PMCRegistry.PMCItems.ARMOR2HELMET) {
                this.damage *= 0.6f;
            } else if (head.func_77973_b() == PMCRegistry.PMCItems.ARMOR3HELMET) {
                this.damage *= 0.4f;
            }
            if (entity.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() instanceof ArmorBase) {
                head.func_77972_a(Math.round((baseDamage - (baseDamage - this.damage)) * 0.55f), entity);
            }
        } else {
            ItemStack body = entity.func_184582_a(EntityEquipmentSlot.CHEST);
            if (body.func_77973_b() == PMCRegistry.PMCItems.ARMOR1BODY) {
                this.damage *= 0.7f;
            } else if (body.func_77973_b() == PMCRegistry.PMCItems.ARMOR2BODY) {
                this.damage *= 0.6f;
            } else if (body.func_77973_b() == PMCRegistry.PMCItems.ARMOR3BODY) {
                this.damage *= 0.5f;
            }
            if (entity.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() instanceof ArmorBase) {
                body.func_77972_a(Math.round((baseDamage - (baseDamage - this.damage)) * 0.8f), entity);
            }
        }
    }

    public float getDamage() {
        return this.damage;
    }
}

