/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.common.entity;

import com.toma.pubgmc.init.PMCSounds;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityParachute
extends Entity
implements IEntityAdditionalSpawnData {
    public static final float MAX_TURN_MODIFIER = 2.5f;
    private Entity user;
    private int color = 0;
    private float turnModifier = 0.0f;
    private boolean inputDown;
    private boolean inputUp;
    private boolean inputRight;
    private boolean inputLeft = false;

    public EntityParachute(World world) {
        super(world);
        this.field_70156_m = true;
    }

    public EntityParachute(World world, Entity user) {
        this(world);
        this.func_70107_b(user.field_70165_t, user.field_70163_u, user.field_70161_v);
        this.func_174810_b(true);
        this.func_70105_a(1.0f, 1.0f);
        this.user = user;
        this.field_70177_z = user.field_70177_z;
        this.field_70169_q = user.field_70165_t;
        this.field_70167_r = user.field_70163_u;
        this.field_70166_s = user.field_70161_v;
        this.handleColorState();
    }

    public void func_70071_h_() {
        if (this.func_184207_aI()) {
            if (this.func_184179_bs() != null) {
                Entity entity = this.func_184179_bs();
                BlockPos pos = entity.func_180425_c();
                this.field_70181_x = -0.2;
                if (this.field_70122_E || this.func_70090_H() || this.func_180799_ab()) {
                    this.onParachuteLand();
                }
                if (entity instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)entity;
                    this.handleMovement(player);
                }
                if (!(this.field_70170_p.func_175623_d(new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p())) && this.field_70170_p.func_175623_d(new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p())) && this.field_70170_p.func_175623_d(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1)) && this.field_70170_p.func_175623_d(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1)))) {
                    this.onParachuteLand();
                }
            }
        } else {
            this.func_70106_y();
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        super.func_70071_h_();
    }

    protected void handleMovement(EntityPlayer user) {
        if (this.inputUp && !this.inputDown && this.field_70125_A < 35.0f) {
            this.field_70125_A += 2.0f;
        }
        if (this.inputDown && !this.inputUp && this.field_70125_A > 0.0f) {
            this.field_70125_A -= 2.0f;
            if (this.field_70125_A < 0.0f) {
                this.field_70125_A = 0.0f;
            }
        }
        if (this.inputRight && !this.inputLeft && this.turnModifier < 2.5f) {
            this.turnModifier += 0.4f;
        }
        if (this.inputLeft && !this.inputRight && this.turnModifier > -2.5f) {
            this.turnModifier -= 0.4f;
        }
        this.field_70177_z += this.turnModifier;
        if (this.noHorizontalMovementInput() && this.turnModifier != 0.0f) {
            if (this.turnModifier > 0.0f && this.turnModifier - 0.25f < 0.0f) {
                this.turnModifier = 0.0f;
            }
            if (this.turnModifier < 0.0f && this.turnModifier + 0.25f > 0.0f) {
                this.turnModifier = 0.0f;
            }
            if (this.turnModifier > 0.0f) {
                this.turnModifier -= 0.25f;
            }
            if (this.turnModifier < 0.0f) {
                this.turnModifier += 0.25f;
            }
        }
        if (this.noVerticalMovementInput() && this.field_70125_A != 0.0f) {
            if (this.field_70125_A > 0.0f) {
                this.field_70125_A -= 0.5f;
            }
            if (this.field_70125_A < 0.0f) {
                this.field_70125_A = 0.0f;
            }
        }
        float speedModifier = 1.0f;
        Vec3d lookVec = this.func_70040_Z();
        if (this.field_70125_A > 0.0f) {
            speedModifier = 1.0f - this.field_70125_A / 100.0f * 1.75f;
        }
        this.field_70159_w = lookVec.field_72450_a * (double)speedModifier * 0.7;
        this.field_70179_y = lookVec.field_72449_c * (double)speedModifier * 0.7;
    }

    public void func_184190_l(Entity entityToUpdate) {
        entityToUpdate.field_70177_z = this.field_70177_z;
        entityToUpdate.field_70125_A = this.field_70125_A;
    }

    public Entity func_184179_bs() {
        return this.func_184207_aI() ? (Entity)this.func_184188_bt().get(0) : null;
    }

    private void handleColorState() {
        this.color = this.field_70146_Z.nextInt(EnumDyeColor.values().length);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public boolean func_70112_a(double distance) {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float f) {
        this.func_70106_y();
        return true;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.field_70165_t = compound.func_74769_h("posX");
        this.field_70163_u = compound.func_74769_h("posY");
        this.field_70161_v = compound.func_74769_h("posZ");
        this.field_70159_w = compound.func_74769_h("motionX");
        this.field_70181_x = compound.func_74769_h("motionY");
        this.field_70179_y = compound.func_74769_h("motionZ");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74780_a("posX", this.field_70165_t);
        compound.func_74780_a("posY", this.field_70163_u);
        compound.func_74780_a("posZ", this.field_70161_v);
        compound.func_74780_a("motionX", this.field_70159_w);
        compound.func_74780_a("motionY", this.field_70181_x);
        compound.func_74780_a("motionZ", this.field_70179_y);
    }

    protected void func_70088_a() {
    }

    private void onParachuteLand() {
        this.field_70170_p.func_184133_a(null, this.func_180425_c(), PMCSounds.chute_land, SoundCategory.MASTER, 3.0f, 1.0f);
        this.func_184226_ay();
        this.func_70106_y();
    }

    private boolean noInput() {
        return !this.inputDown && !this.inputUp && !this.inputRight && !this.inputRight;
    }

    private boolean noHorizontalMovementInput() {
        return !this.inputRight && !this.inputLeft;
    }

    private boolean noVerticalMovementInput() {
        return !this.inputDown && !this.inputUp;
    }

    public void handleInputs(boolean down, boolean up, boolean right, boolean left) {
        this.inputDown = up;
        this.inputUp = down;
        this.inputRight = right;
        this.inputLeft = left;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int colorID) {
        this.color = colorID;
    }

    public Entity getUser() {
        return this.user;
    }

    public void readSpawnData(ByteBuf buf) {
        this.color = buf.readInt();
    }

    public void writeSpawnData(ByteBuf buf) {
        buf.writeInt(this.color);
    }
}

