/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.common.entity;

import com.toma.pubgmc.Pubgmc;
import com.toma.pubgmc.common.capability.IGameData;
import com.toma.pubgmc.common.capability.IPlayerData;
import com.toma.pubgmc.config.ConfigPMC;
import com.toma.pubgmc.network.PacketHandler;
import com.toma.pubgmc.network.sp.PacketUpdatePlayerRotation;
import com.toma.pubgmc.util.PUBGMCUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class EntityPlane
extends Entity {
    public HashMap<EntityPlayer, BlockPos> dropLoc = new HashMap();
    protected IGameData gameData;
    protected BlockPos endPos;
    protected BlockPos startPos;
    private boolean hasReachedDestination;
    private short timeSinceDestination;
    private boolean canFly;
    public List<EntityPlayer> pendingPlayers = new ArrayList<EntityPlayer>();

    public EntityPlane(World world) {
        super(world);
        this.func_70105_a(15.0f, 5.0f);
        this.field_70158_ak = true;
    }

    public EntityPlane(World world, IGameData data) {
        this(world);
        this.gameData = data;
        this.onCreated();
    }

    protected static void setPlayerFaceTheirDropLocation(EntityPlayer player, BlockPos finalDest) {
        player.field_70177_z = 0.0f;
        PUBGMCUtil.updateEntityRotation((Entity)player, finalDest);
        player.field_70177_z += 180.0f;
        if (player instanceof EntityPlayerMP) {
            PacketHandler.sendToClient(new PacketUpdatePlayerRotation(player.field_70177_z), (EntityPlayerMP)player);
        }
    }

    public double func_70042_X() {
        return 2.3;
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < 32;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger) && !this.func_184188_bt().isEmpty()) {
            float f1 = (float)((this.field_70128_L ? (double)0.01f : this.func_70042_X()) + passenger.func_70033_W());
            int id = this.func_184188_bt().indexOf(passenger);
            float x = id >= 16 ? (float)(-6 + (id - 16) * 3) : (float)(-6 + id * 3);
            float z = id < 16 ? 3.0f : -3.0f;
            Vec3d vec3d = new Vec3d((double)x, 0.0, (double)z).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.field_70165_t + vec3d.field_72450_a, this.field_70163_u + (double)f1, this.field_70161_v + vec3d.field_72449_c);
        }
    }

    public boolean func_70112_a(double distance) {
        return true;
    }

    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    public void onCreated() {
        this.dropLoc.clear();
        BlockPos mapCenter = this.gameData.getMapCenter();
        short startSide = (short)this.field_70146_Z.nextInt(4);
        int startX = 0;
        int startZ = 0;
        int endX = 0;
        int endZ = 0;
        switch (startSide) {
            case 0: {
                startX = this.edgeCoordinate(mapCenter.func_177958_n(), false);
                startZ = this.generateRandomPosition(mapCenter.func_177952_p());
                endX = this.edgeCoordinate(mapCenter.func_177958_n(), true);
                endZ = this.generateRandomPosition(mapCenter.func_177952_p());
                break;
            }
            case 1: {
                startZ = this.edgeCoordinate(mapCenter.func_177952_p(), true);
                endZ = this.edgeCoordinate(mapCenter.func_177952_p(), false);
                startX = this.generateRandomPosition(mapCenter.func_177958_n());
                endX = this.generateRandomPosition(mapCenter.func_177958_n());
                break;
            }
            case 2: {
                startX = this.edgeCoordinate(mapCenter.func_177958_n(), true);
                startZ = this.generateRandomPosition(mapCenter.func_177952_p());
                endX = this.edgeCoordinate(mapCenter.func_177958_n(), false);
                endZ = this.generateRandomPosition(mapCenter.func_177952_p());
                break;
            }
            case 3: {
                startZ = this.edgeCoordinate(mapCenter.func_177952_p(), false);
                endZ = this.edgeCoordinate(mapCenter.func_177952_p(), true);
                startX = this.generateRandomPosition(mapCenter.func_177958_n());
                endX = this.generateRandomPosition(mapCenter.func_177958_n());
            }
        }
        this.endPos = new BlockPos(endX, ConfigPMC.common.world.planeHeight, endZ);
        this.func_70107_b(startX, ConfigPMC.common.world.planeHeight, startZ);
        this.startPos = new BlockPos(startX, ConfigPMC.common.world.planeHeight, startZ);
        this.field_70177_z = 180.0f;
        this.updateHeading(startX, startZ, this.endPos);
        for (EntityPlayer player : this.field_70170_p.field_73010_i) {
            if (!player.hasCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null)) continue;
            ((IPlayerData)player.getCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null)).setDistance(Double.MAX_VALUE);
        }
        Pubgmc.logger.info("Spawning plane with start position of " + startX + ", 256, " + startZ + " and end position of " + endX + ", 256, " + endZ + ".");
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        boolean bl = this.canFly = this.field_70173_aa >= ConfigPMC.common.world.planeDelay * 20;
        if (this.gameData == null) {
            Pubgmc.logger.debug("Couldn't load gamedata for plane, getting new instance...");
            IGameData iGameData = this.gameData = this.field_70170_p.hasCapability(IGameData.GameDataProvider.GAMEDATA, null) ? (IGameData)this.field_70170_p.getCapability(IGameData.GameDataProvider.GAMEDATA, null) : null;
        }
        if (this.canFly) {
            if (!this.field_70170_p.field_72995_K) {
                boolean bl2 = this.hasReachedDestination = Math.abs(this.field_70165_t - (double)this.endPos.func_177958_n()) < 10.0 && Math.abs(this.field_70161_v - (double)this.endPos.func_177952_p()) < 10.0;
                if (this.hasReachedDestination) {
                    this.timeSinceDestination = (short)(this.timeSinceDestination + 1);
                    if (this.func_184207_aI()) {
                        this.func_184226_ay();
                    }
                    if (this.timeSinceDestination >= 50) {
                        this.func_70106_y();
                    }
                }
                if (!this.gameData.isPlaying()) {
                    this.func_70106_y();
                }
                if (this.field_70159_w == 0.0 && this.field_70179_y == 0.0 && this.field_70173_aa >= ConfigPMC.common.world.planeDelay * 20 + 15) {
                    this.func_70106_y();
                    Pubgmc.logger.error("Plane is in invalid position, despawning...");
                }
                if (!this.func_184188_bt().isEmpty() && this.field_70173_aa % 10 == 0 && !this.dropLoc.isEmpty()) {
                    for (Entity e : this.func_184188_bt()) {
                        EntityPlayer player;
                        if (!(e instanceof EntityPlayer) || !this.dropLoc.containsKey(player = (EntityPlayer)e)) continue;
                        BlockPos pos = this.dropLoc.get(player);
                        IPlayerData data = (IPlayerData)player.getCapability(IPlayerData.PlayerDataProvider.PLAYER_DATA, null);
                        if (PUBGMCUtil.getDistanceToBlockPos(this.func_180425_c(), pos) < data.getDistance()) {
                            data.setDistance(PUBGMCUtil.getDistanceToBlockPos(this.func_180425_c(), pos));
                            continue;
                        }
                        DecimalFormat num = new DecimalFormat("####.##");
                        this.dropLoc.remove(player);
                        player.func_184210_p();
                        EntityPlane.setPlayerFaceTheirDropLocation(player, pos);
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.BOLD + "" + TextFormatting.GREEN + "You have been dropped closest to your selected location."));
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Distance on map to your location: " + num.format(PUBGMCUtil.getDistanceToBlockPos(player.func_180425_c(), pos)) + " m"));
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Actual distance: " + num.format(PUBGMCUtil.getDistanceToBlockPos3D(player.func_180425_c(), pos)) + " m"));
                    }
                }
            }
            Vec3d look = this.func_70040_Z();
            float f = this.getMovementMultiplier();
            this.field_70159_w = look.field_72450_a * 0.4 * (double)f;
            this.field_70179_y = look.field_72449_c * 0.4 * (double)f;
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
    }

    private float getMovementMultiplier() {
        float f = (float)this.gameData.getMapSize() / 300.0f;
        f = f < 1.0f ? 1.0f : f;
        return f;
    }

    protected void func_70088_a() {
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74780_a("posX", this.field_70165_t);
        compound.func_74780_a("posY", this.field_70163_u);
        compound.func_74780_a("posZ", this.field_70161_v);
        compound.func_74780_a("motX", this.field_70159_w);
        compound.func_74780_a("motY", this.field_70181_x);
        compound.func_74780_a("motZ", this.field_70179_y);
        compound.func_74776_a("rotYaw", this.field_70177_z);
        compound.func_74780_a("endX", (double)this.endPos.func_177958_n());
        compound.func_74780_a("endZ", (double)this.endPos.func_177952_p());
        compound.func_74757_a("reachedDest", this.hasReachedDestination);
        compound.func_74777_a("timeSinceDest", this.timeSinceDestination);
        compound.func_186854_a("UUID", this.func_110124_au());
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.field_70165_t = compound.func_74769_h("posX");
        this.field_70163_u = compound.func_74769_h("posY");
        this.field_70161_v = compound.func_74769_h("posZ");
        this.field_70159_w = compound.func_74769_h("motX");
        this.field_70181_x = compound.func_74769_h("motY");
        this.field_70179_y = compound.func_74769_h("motZ");
        this.field_70177_z = compound.func_74760_g("rotYaw");
        this.endPos = new BlockPos(compound.func_74769_h("endX"), (double)ConfigPMC.common.world.planeHeight, compound.func_74769_h("endZ"));
        this.hasReachedDestination = compound.func_74767_n("reachedDest");
        this.timeSinceDestination = compound.func_74765_d("timeSinceDest");
        this.func_184221_a(compound.func_186857_a("UUID"));
    }

    private void updateHeading(int x, int z, BlockPos endPos) {
        PUBGMCUtil.updateEntityRotation(this, endPos);
    }

    private int edgeCoordinate(int center, boolean endPos) {
        return endPos ? center + this.gameData.getMapSize() - 15 : center - this.gameData.getMapSize() + 15;
    }

    private int generateRandomPosition(int center) {
        return center - this.gameData.getMapSize() + 15 + this.field_70146_Z.nextInt(this.gameData.getMapSize() * 2 - 30);
    }

    public BlockPos getStartingPosition() {
        return this.startPos;
    }
}

