/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.common.entity;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.toma.pubgmc.Pubgmc;
import com.toma.pubgmc.init.PMCDamageSources;
import com.toma.pubgmc.init.PMCSounds;
import com.toma.pubgmc.network.PacketHandler;
import com.toma.pubgmc.network.sp.PacketVehicleData;
import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public abstract class EntityVehicle
extends Entity
implements IEntityAdditionalSpawnData {
    private static final Predicate<Entity> TARGET = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d, EntitySelectors.field_94557_a, Entity::func_70067_L});
    private static final AxisAlignedBB BOX = new AxisAlignedBB(-0.5, 0.0, -0.5, 1.5, 1.0, 1.5);
    public float maxHealth = 100.0f;
    public float health = 100.0f;
    public float acceleration = 0.08f;
    public float turnSpeed = 0.45f;
    public float maxSpeed = 1.2f;
    public float currentSpeed = 0.0f;
    public float turnModifier;
    public float maximalTurningModifier = 3.0f;
    public float fuel = 100.0f;
    public boolean isBroken = false;
    private boolean isWaterVehicle;
    private short timeInInvalidState;
    private boolean inputForward;
    private boolean inputBack;
    private boolean inputRight;
    private boolean inputLeft;
    private boolean inputBoost;
    private byte variantType = 0;

    public EntityVehicle(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70138_W = 1.0f;
        this.field_70156_m = true;
        this.maxSpeed = 1.0f;
        this.createColorVariant();
    }

    public EntityVehicle(World world, int x, int y, int z) {
        this(world);
        this.func_70107_b(x, y, z);
    }

    @Nonnull
    public abstract int getMaximumCapacity();

    @Nonnull
    public abstract Vec3d getEnginePosition();

    @Nonnull
    public abstract Vec3d getExhaustPosition();

    @Nonnull
    public abstract SoundEvent vehicleSound();

    @Nullable
    public abstract String[] getTextureVariants();

    public void func_70071_h_() {
        if (!(this.func_184207_aI() || this.noAccerationInput() && this.noTurningInput() && this.hasFuel())) {
            this.inputForward = false;
            this.inputBack = false;
            this.inputRight = false;
            this.inputLeft = false;
        }
        this.updateMotion();
        this.handleEntityCollisions();
        this.checkState();
        if (this.field_70123_F) {
            this.currentSpeed = (float)((double)this.currentSpeed * 0.6);
        }
        this.applyTerrainMotionMultiplier();
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            PacketHandler.sendToClientsAround(new PacketVehicleData(this), this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 256.0);
        }
        this.playSoundAtVehicle();
        this.spawnParticles();
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    public void handleEntityCollisions() {
        Vec3d vec1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec2 = new Vec3d(vec1.field_72450_a + this.field_70159_w, vec1.field_72448_b + this.field_70181_x, vec1.field_72449_c + this.field_70179_y);
        Entity e = this.findEntityInPath(vec1, vec2);
        if (e != null) {
            e.field_70159_w += this.field_70159_w * (double)this.currentSpeed * 3.0;
            e.field_70181_x += (double)this.currentSpeed;
            e.field_70179_y += this.field_70179_y * (double)this.currentSpeed * 3.0;
            e.func_70097_a(PMCDamageSources.VEHICLE, Math.abs(this.currentSpeed) * 15.0f);
        }
    }

    public void applyTerrainMotionMultiplier() {
        this.currentSpeed = (float)(this.field_70167_r < this.field_70163_u ? (double)this.currentSpeed * 0.95 : (double)this.currentSpeed);
    }

    public void updateMotion() {
        Vec3d lookVec = this.func_70040_Z();
        if (!this.isBroken && this.hasFuel()) {
            if (this.inputForward && !this.inputBack) {
                this.burnFuel();
                float f = this.currentSpeed = this.currentSpeed < this.maxSpeed ? this.currentSpeed + this.acceleration : this.maxSpeed;
            }
            if (this.inputBack && !this.inputForward) {
                this.burnFuel();
                float f = this.currentSpeed > 0.0f ? this.currentSpeed - this.acceleration * 2.0f : (this.currentSpeed = this.currentSpeed > -this.maxSpeed * 0.3f ? this.currentSpeed - 0.02f : -this.maxSpeed * 0.3f);
            }
        }
        if (this.inputRight && !this.inputLeft) {
            float f = this.turnModifier = this.turnModifier < this.maximalTurningModifier ? this.turnModifier + this.turnSpeed : this.maximalTurningModifier;
        }
        if (this.inputLeft && !this.inputRight) {
            float f = this.turnModifier = this.turnModifier > -this.maximalTurningModifier ? this.turnModifier - this.turnSpeed : -this.maximalTurningModifier;
        }
        if (this.noAccerationInput() || this.isBroken) {
            if (Math.abs(this.currentSpeed) < 0.009f) {
                this.currentSpeed = 0.0f;
            }
            if (this.currentSpeed != 0.0f) {
                float f = this.currentSpeed = this.currentSpeed > 0.0f ? this.currentSpeed - 0.008f : this.currentSpeed + 0.008f;
            }
        }
        if (this.noTurningInput()) {
            if (Math.abs(this.turnModifier) < 0.1f) {
                this.turnModifier = 0.0f;
            }
            if (this.turnModifier != 0.0f) {
                this.turnModifier = this.turnModifier > 0.0f ? this.turnModifier - 0.3f : this.turnModifier + 0.3f;
            }
        }
        this.field_70159_w = lookVec.field_72450_a * (double)this.currentSpeed;
        this.field_70179_y = lookVec.field_72449_c * (double)this.currentSpeed;
        if (this.currentSpeed != 0.0f) {
            this.field_70177_z += this.currentSpeed > 0.0f ? this.turnModifier : -this.turnModifier;
        }
        if (!this.field_70122_E) {
            this.field_70181_x -= 0.1;
        }
    }

    @Nullable
    protected Entity findEntityInPath(Vec3d start, Vec3d end) {
        Entity e = null;
        List entityList = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x + 1.0, this.field_70179_y).func_186662_g(1.0), TARGET);
        double d0 = 0.0;
        for (int i = 0; i < entityList.size(); ++i) {
            double d1;
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult;
            Entity entity = (Entity)entityList.get(i);
            if (entity == this || (raytraceresult = (axisalignedbb = entity.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(start, end)) == null || !((d1 = start.func_72436_e(raytraceresult.field_72307_f)) < d0) && d0 != 0.0) continue;
            e = entity;
            d0 = d1;
        }
        return e;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && this.func_184228_n((Entity)player) && this.func_184219_q((Entity)player)) {
            player.func_184220_m((Entity)this);
        }
        return true;
    }

    private void explode() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 3.0f, false);
            this.func_70106_y();
        }
    }

    protected void checkState() {
        if (this.func_70090_H() && this.field_70170_p.func_180495_p(this.func_180425_c().func_177984_a()).func_185904_a().func_76224_d()) {
            this.timeInInvalidState = (short)(this.timeInInvalidState + 1);
            this.field_70159_w *= 0.4;
            this.field_70179_y *= 0.4;
            this.field_70181_x = -0.15;
        }
        if (this.timeInInvalidState > 30) {
            this.isBroken = true;
        }
        if (this.func_180799_ab() || this.health <= 0.0f) {
            this.explode();
        }
    }

    protected void spawnParticles() {
        if (this.field_70170_p.field_72995_K) {
            if (this.health / this.maxHealth <= 0.35f) {
                Vec3d engineVec = new Vec3d(this.getEnginePosition().field_72450_a, this.getEnginePosition().field_72448_b + 0.25, this.getEnginePosition().field_72449_c).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
                this.field_70170_p.func_175682_a(EnumParticleTypes.SMOKE_LARGE, true, this.field_70165_t + engineVec.field_72450_a, this.field_70163_u + engineVec.field_72448_b, this.field_70161_v + engineVec.field_72449_c, 0.0, 0.1, 0.0, new int[0]);
                if (this.health / this.maxHealth <= 0.15f) {
                    double rngX = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.1;
                    double rngZ = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.1;
                    this.field_70170_p.func_175682_a(EnumParticleTypes.FLAME, true, this.field_70165_t + engineVec.field_72450_a, this.field_70163_u + engineVec.field_72448_b - 0.2, this.field_70161_v + engineVec.field_72449_c, rngX, 0.02, rngZ, new int[0]);
                }
            }
            if (!this.isBroken && this.hasFuel()) {
                Vec3d exhaustVec = new Vec3d(this.getExhaustPosition().field_72450_a, this.getExhaustPosition().field_72448_b + 0.25, this.getExhaustPosition().field_72449_c).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
                this.field_70170_p.func_175682_a(EnumParticleTypes.SMOKE_NORMAL, true, this.field_70165_t + exhaustVec.field_72450_a, this.field_70163_u + exhaustVec.field_72448_b, this.field_70161_v + exhaustVec.field_72449_c, 0.0, 0.02, 0.0, new int[0]);
            }
            if (this.isBroken) {
                Vec3d engine = new Vec3d(this.getEnginePosition().field_72450_a, this.getEnginePosition().field_72448_b, this.getEnginePosition().field_72449_c).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
                this.field_70170_p.func_175682_a(EnumParticleTypes.CLOUD, true, this.field_70165_t + engine.field_72450_a, this.field_70163_u + engine.field_72448_b, this.field_70161_v + engine.field_72449_c, 0.0, 0.05, 0.0, new int[0]);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.func_184188_bt().contains(source.func_76346_g())) {
            this.health -= amount;
        }
        return true;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float x = 0.0f;
            float z = -0.55f;
            float f1 = (float)((this.field_70128_L ? (double)0.01f : this.func_70042_X()) + passenger.func_70033_W());
            if (this.func_184188_bt().size() > 0) {
                int i = this.func_184188_bt().indexOf(passenger);
                x = this.getPassengerXOffset(i);
                z = this.getPassengerZOffset(i);
            }
            Vec3d vec3d = new Vec3d((double)x, 0.0, (double)z).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.field_70165_t + vec3d.field_72450_a, this.field_70163_u + (double)f1, this.field_70161_v + vec3d.field_72449_c);
            if (passenger instanceof EntityAnimal && this.func_184188_bt().size() > 1) {
                int j = passenger.func_145782_y() % 2 == 0 ? 90 : 270;
                passenger.func_181013_g(((EntityAnimal)passenger).field_70761_aq + (float)j);
                passenger.func_70034_d(passenger.func_70079_am() + (float)j);
            }
        }
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < this.getMaximumCapacity();
    }

    public void handleInputs(boolean forward, boolean back, boolean right, boolean left, EntityPlayer player) {
        if (this.isPlayerDriver(player)) {
            if (this.hasFuel()) {
                this.inputForward = forward;
                this.inputBack = back;
            }
            this.inputLeft = left;
            this.inputRight = right;
        }
    }

    public boolean func_70112_a(double distance) {
        return true;
    }

    public boolean isPlayerDriver(EntityPlayer player) {
        return player.func_184218_aH() && player.func_184187_bx() instanceof EntityVehicle && player.func_184187_bx().func_184188_bt().get(0) == player;
    }

    private boolean isVehicleMoving() {
        return this.currentSpeed != 0.0f;
    }

    private boolean isVehicleMovingForward() {
        return this.currentSpeed > 0.0f;
    }

    private boolean isVehicleMovingBackward() {
        return this.currentSpeed < 0.0f;
    }

    private void playSoundAtVehicle() {
        if (!this.isVehicleMoving()) {
            if (this.field_70173_aa % 5 == 0) {
                this.func_184185_a(PMCSounds.vehicleIdle, 2.0f, 1.0f);
            }
        } else if (this.field_70173_aa % 18 == 0) {
            this.func_184185_a(this.vehicleSound(), this.currentSpeed * 5.0f, 1.0f);
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.field_70165_t = compound.func_74769_h("posX");
        this.field_70163_u = compound.func_74769_h("posY");
        this.field_70161_v = compound.func_74769_h("posZ");
        this.field_70159_w = compound.func_74769_h("motionX");
        this.field_70181_x = compound.func_74769_h("motionY");
        this.field_70179_y = compound.func_74769_h("motionZ");
        this.maxHealth = compound.func_74760_g("maxHealth");
        this.health = compound.func_74760_g("health");
        this.fuel = compound.func_74760_g("fuel");
        this.currentSpeed = compound.func_74760_g("speed");
        this.maxSpeed = compound.func_74760_g("maxSpeed");
        this.acceleration = compound.func_74760_g("acceleration");
        this.turnSpeed = compound.func_74760_g("turnSpeed");
        this.isBroken = compound.func_74767_n("isBroken");
        this.variantType = compound.func_74771_c("colorVariant");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74780_a("posX", this.field_70165_t);
        compound.func_74780_a("posY", this.field_70163_u);
        compound.func_74780_a("posZ", this.field_70161_v);
        compound.func_74780_a("motionX", this.field_70159_w);
        compound.func_74780_a("motionY", this.field_70181_x);
        compound.func_74780_a("motionZ", this.field_70179_y);
        compound.func_74776_a("maxHealth", this.maxHealth);
        compound.func_74776_a("health", this.health);
        compound.func_74776_a("fuel", this.fuel);
        compound.func_74776_a("speed", this.currentSpeed);
        compound.func_74776_a("maxSpeed", this.maxSpeed);
        compound.func_74776_a("acceleration", this.acceleration);
        compound.func_74776_a("turnSpeed", this.turnSpeed);
        compound.func_74757_a("isBroken", this.isBroken);
        compound.func_74774_a("colorVariant", this.variantType);
    }

    public boolean func_70067_L() {
        return true;
    }

    protected float getPassengerXOffset(int passengerIndex) {
        return passengerIndex % 2 == 0 ? 0.5f : -0.5f;
    }

    protected float getPassengerZOffset(int passengerIndex) {
        return passengerIndex < 2 ? -0.55f : 0.55f;
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
        entityToUpdate.field_70126_B += f1 - f;
        entityToUpdate.field_70177_z += f1 - f;
        entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
    }

    public boolean noAccerationInput() {
        return !this.inputForward && !this.inputBack;
    }

    public boolean noTurningInput() {
        return !this.inputRight && !this.inputLeft;
    }

    public void setAllRequiredValues(float maxHealth, float health, float maxSpeed, float acceleration, float turnSpeed) {
        this.maxHealth = maxHealth;
        this.health = health;
        this.maxSpeed = maxSpeed;
        this.acceleration = acceleration;
        this.turnSpeed = turnSpeed;
    }

    public boolean hasFuel() {
        return this.fuel > 0.0f;
    }

    public void refill(EntityPlayer source) {
        if (this.func_184188_bt().contains(source)) {
            this.fuel = this.fuel + 30.0f < 100.0f ? this.fuel + 30.0f : 100.0f;
        } else {
            Pubgmc.logger.warn("{} has attempted to refuel vehicle with ID {}, but he wasn't inside the vehicle!", (Object)source, (Object)this.func_145782_y());
        }
    }

    public void burnFuel() {
        this.fuel = this.hasFuel() ? this.fuel - 0.01f : 0.0f;
    }

    public byte getColorVariantIndex() {
        return this.variantType;
    }

    private void createColorVariant() {
        this.variantType = (byte)(this.getTextureVariants() != null ? this.field_70146_Z.nextInt(this.getTextureVariants().length) : 0);
    }

    protected float generateFuel() {
        return 60.0f + (float)this.field_70146_Z.nextInt(40) + this.field_70146_Z.nextFloat();
    }

    public void writeSpawnData(ByteBuf buf) {
        buf.writeFloat(this.maxHealth);
        buf.writeFloat(this.health);
        buf.writeFloat(this.maxSpeed);
        buf.writeFloat(this.acceleration);
        buf.writeFloat(this.turnSpeed);
        buf.writeFloat(this.fuel);
        buf.writeByte((int)this.variantType);
    }

    public void readSpawnData(ByteBuf buf) {
        this.maxHealth = buf.readFloat();
        this.health = buf.readFloat();
        this.maxSpeed = buf.readFloat();
        this.acceleration = buf.readFloat();
        this.turnSpeed = buf.readFloat();
        this.fuel = buf.readFloat();
        this.variantType = buf.readByte();
    }
}

