/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.common.entity.bot;

import com.toma.pubgmc.common.capability.IGameData;
import com.toma.pubgmc.common.entity.bot.ai.EntityAIGunAttack;
import com.toma.pubgmc.common.entity.bot.ai.EntityAIMoveIntoZone;
import com.toma.pubgmc.common.entity.bot.ai.EntityAISearchLoot;
import com.toma.pubgmc.common.items.armor.ArmorBase;
import com.toma.pubgmc.common.items.guns.AmmoType;
import com.toma.pubgmc.common.items.guns.GunBase;
import com.toma.pubgmc.common.items.heal.ItemHealing;
import com.toma.pubgmc.common.tileentity.TileEntityLootGenerator;
import com.toma.pubgmc.init.PMCRegistry;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityAIPlayer
extends EntityCreature {
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    private String hash;
    private int variant;

    public EntityAIPlayer(World worldIn) {
        super(worldIn);
        this.field_70156_m = true;
        this.func_110163_bv();
        this.func_70105_a(0.6f, 1.95f);
        this.func_98053_h(true);
        IGameData gameData = (IGameData)this.field_70170_p.getCapability(IGameData.GameDataProvider.GAMEDATA, null);
        this.hash = gameData == null ? "empty" : gameData.getGameID();
        this.variant = worldIn.field_73012_v.nextInt(4);
    }

    public EntityAIPlayer(World world, BlockPos pos) {
        this(world);
        this.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static NonNullList<ItemStack> getBasicInventory() {
        return NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 20 == 0 && !((IGameData)this.field_70170_p.getCapability(IGameData.GameDataProvider.GAMEDATA, null)).getGameID().equals(this.hash)) {
            this.func_70106_y();
        }
    }

    public boolean func_98052_bS() {
        return true;
    }

    public void func_70645_a(DamageSource cause) {
        UUID uuid = this.func_110124_au();
        EntityAISearchLoot.GLOBAL_LOOT_CACHE.remove(uuid);
        super.func_70645_a(cause);
    }

    public boolean func_70112_a(double distance) {
        return true;
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    protected boolean func_146066_aG() {
        return false;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIGunAttack(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAISearchLoot(this, 0.05f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveIntoZone((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0, 1.0E-4f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 10, true, false, EntitySelectors.field_94557_a));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityAIPlayer.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.23);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(128.0);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74778_a("hash", this.hash);
        compound.func_74768_a("variant", this.variant);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.hash = compound.func_74764_b("hash") ? compound.func_74779_i("hash") : "empty";
        this.variant = compound.func_74762_e("variant");
    }

    public int getVariant() {
        return this.variant;
    }

    public int lootFromLootSpawner(TileEntityLootGenerator lootSpawner) {
        boolean needsGun = !this.hasGun();
        boolean needsHelmet = this.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b();
        boolean needsVest = this.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b();
        boolean needsMeds = !(((ItemStack)this.inventory.get(0)).func_77973_b() instanceof ItemHealing);
        boolean needsAmmo = false;
        GunBase lootedGun = null;
        int needToLoot = 0;
        for (int i = 0; i < lootSpawner.func_70302_i_(); ++i) {
            ArmorBase armorBase;
            ItemStack stack = lootSpawner.func_70301_a(i);
            if (needsGun && stack.func_77973_b() instanceof GunBase && stack.func_77973_b() != PMCRegistry.PMCItems.FLARE_GUN) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                EntityItem item = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack.func_77946_l());
                item.func_174867_a(0);
                this.field_70170_p.func_72838_d((Entity)item);
                lootedGun = (GunBase)stack.func_77973_b();
                needsGun = false;
                needsAmmo = true;
                lootSpawner.func_70304_b(i);
            }
            if (needsAmmo || this.hasGun() && this.needsAmmo()) {
                GunBase gun;
                GunBase gunBase = gun = lootedGun != null ? lootedGun : this.getGun();
                if (gun.getAmmoType().ammo() == stack.func_77973_b()) {
                    for (int j = 1; j < 6; ++j) {
                        if (!((ItemStack)this.inventory.get(j)).func_190926_b()) continue;
                        this.inventory.set(j, (Object)stack.func_77946_l());
                        lootSpawner.func_70304_b(i);
                        break;
                    }
                }
            }
            if (needsHelmet && stack.func_77973_b() instanceof ArmorBase) {
                armorBase = (ArmorBase)stack.func_77973_b();
                if (armorBase.field_77881_a == EntityEquipmentSlot.HEAD) {
                    this.func_184201_a(EntityEquipmentSlot.HEAD, stack.func_77946_l());
                    lootSpawner.func_70304_b(i);
                    needsHelmet = false;
                }
            }
            if (needsVest && stack.func_77973_b() instanceof ArmorBase) {
                armorBase = (ArmorBase)stack.func_77973_b();
                if (armorBase.field_77881_a == EntityEquipmentSlot.CHEST) {
                    this.func_184201_a(EntityEquipmentSlot.CHEST, stack.func_77946_l());
                    lootSpawner.func_70304_b(i);
                    needsVest = false;
                }
            }
            if (!needsMeds || !(stack.func_77973_b() instanceof ItemHealing)) continue;
            this.inventory.set(0, (Object)stack.func_77946_l());
            lootSpawner.func_70304_b(i);
            needsMeds = false;
        }
        IBlockState state = this.field_70170_p.func_180495_p(lootSpawner.func_174877_v());
        this.field_70170_p.func_184138_a(lootSpawner.func_174877_v(), state, state, 3);
        needToLoot = needToLoot + (needsGun ? 10 : 0) + (this.needsAmmo() ? 10 : 0) + (needsHelmet ? 5 : 0) + (needsVest ? 5 : 0) + (needsMeds ? 3 : 0);
        return needToLoot;
    }

    protected boolean needsAmmo() {
        if (!this.hasGun()) {
            return false;
        }
        int totalAmmoCount = 0;
        AmmoType ammoType = this.getGun().getAmmoType();
        for (int i = 1; i < 6; ++i) {
            ItemStack stack = (ItemStack)this.inventory.get(i);
            if (ammoType.ammo() != stack.func_77973_b()) continue;
            totalAmmoCount += stack.func_190916_E();
        }
        return totalAmmoCount < 60;
    }

    public boolean hasGun() {
        return this.func_184614_ca().func_77973_b() instanceof GunBase;
    }

    public GunBase getGun() {
        return (GunBase)this.func_184614_ca().func_77973_b();
    }
}

