/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.common.entity.bot.ai;

import com.toma.pubgmc.common.entity.EntityBullet;
import com.toma.pubgmc.common.entity.bot.EntityAIPlayer;
import com.toma.pubgmc.common.items.guns.GunBase;
import com.toma.pubgmc.network.PacketHandler;
import com.toma.pubgmc.network.sp.PacketDelayedSound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityAIGunAttack
extends EntityAIBase {
    private static final int[] MAX_ATTACK_RANGE_TABLE = new int[]{40, 20, 10, 20, 40, 60, 60};
    private final EntityAIPlayer aiPlayer;
    private int timeRemaining;
    private int shotsFired;
    private int timeWatching;
    private EntityLivingBase target;

    public EntityAIGunAttack(EntityAIPlayer aiPlayer) {
        this.aiPlayer = aiPlayer;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (!this.aiPlayer.hasGun()) {
            return false;
        }
        this.target = this.aiPlayer.func_70638_az();
        return this.target != null;
    }

    public boolean func_75253_b() {
        return this.func_75250_a() || !this.aiPlayer.func_70661_as().func_75500_f() || !this.aiPlayer.hasGun();
    }

    public void func_75251_c() {
        this.timeWatching = 0;
        this.timeRemaining = 5;
        this.shotsFired = 0;
        this.target = null;
    }

    public void func_75246_d() {
        if (this.target == null) {
            return;
        }
        double distanceToTarget = Math.sqrt(this.aiPlayer.func_70068_e((Entity)this.target));
        boolean flag = this.aiPlayer.func_70635_at().func_75522_a((Entity)this.target);
        this.timeWatching = flag ? ++this.timeWatching : 0;
        if (!this.aiPlayer.hasGun()) {
            return;
        }
        GunBase gun = this.aiPlayer.getGun();
        int tableIndex = gun.getGunType().ordinal();
        if (distanceToTarget <= (double)MAX_ATTACK_RANGE_TABLE[tableIndex] * 1.5 && this.timeWatching >= 20) {
            this.aiPlayer.func_70661_as().func_75499_g();
        } else {
            this.aiPlayer.func_70661_as().func_75497_a((Entity)this.target, 1.0);
        }
        this.aiPlayer.func_70671_ap().func_75651_a((Entity)this.target, 30.0f, 30.0f);
        if (--this.timeRemaining <= 0) {
            if (!flag) {
                return;
            }
            this.shoot(gun, distanceToTarget);
        }
    }

    private void shoot(GunBase gun, double distanceToTarget) {
        if (distanceToTarget > (double)(MAX_ATTACK_RANGE_TABLE[gun.getGunType().ordinal()] * 10)) {
            return;
        }
        ++this.shotsFired;
        int shotAmount = gun.getGunType() == GunBase.GunType.SHOTGUN ? 8 : 1;
        boolean isSilenced = this.aiPlayer.func_184614_ca().func_77942_o() && this.aiPlayer.func_184614_ca().func_77978_p().func_74762_e("barrel") == 1;
        SoundEvent event = isSilenced ? gun.getGunSilencedSound() : gun.getGunSound();
        float volume = isSilenced ? gun.getGunSilencedVolume() : gun.getGunVolume();
        PacketHandler.sendToDimension((IMessage)new PacketDelayedSound(event, volume, this.aiPlayer.field_70165_t, this.aiPlayer.field_70163_u, this.aiPlayer.field_70161_v), this.aiPlayer.field_71093_bK);
        for (int i = 0; i < shotAmount; ++i) {
            EntityBullet bullet = new EntityBullet(this.aiPlayer.field_70170_p, (EntityLivingBase)this.aiPlayer, gun);
            bullet.func_70107_b(bullet.field_70165_t, bullet.field_70163_u - 0.5, bullet.field_70161_v);
            if (shotAmount > 1) {
                double d0 = distanceToTarget / 150.0;
                bullet.field_70181_x += d0;
            }
            this.aiPlayer.field_70170_p.func_72838_d((Entity)bullet);
        }
        boolean effectiveRange = distanceToTarget < (double)MAX_ATTACK_RANGE_TABLE[gun.getGunType().ordinal()];
        this.timeRemaining = gun.getFireRate() + (effectiveRange ? 6 : 18);
        if (this.shotsFired >= gun.getWeaponAmmoLimit(this.aiPlayer.func_184614_ca())) {
            this.shotsFired = 0;
            this.timeRemaining = 80;
        }
    }
}

