/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.common.entity.bot.ai;

import com.toma.pubgmc.common.entity.bot.EntityAIPlayer;
import com.toma.pubgmc.common.tileentity.TileEntityLootGenerator;
import com.toma.pubgmc.util.PUBGMCUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class EntityAISearchLoot
extends EntityAIBase {
    public static final HashMap<UUID, List<BlockPos>> GLOBAL_LOOT_CACHE = new HashMap();
    private EntityAIPlayer aiPlayer;
    private final float chance;
    private float modifier;
    @Nullable
    private BlockPos pos;

    public EntityAISearchLoot(EntityAIPlayer entityAIPlayer, float chance) {
        this.aiPlayer = entityAIPlayer;
        this.chance = chance;
        this.modifier = chance;
        this.func_75248_a(1);
        GLOBAL_LOOT_CACHE.put(entityAIPlayer.func_110124_au(), new ArrayList());
    }

    public BlockPos findNearestUncheckedSpawner() {
        List<BlockPos> checkedBlocks = GLOBAL_LOOT_CACHE.get(this.aiPlayer.func_110124_au());
        if (checkedBlocks == null) {
            GLOBAL_LOOT_CACHE.put(this.aiPlayer.func_110124_au(), new ArrayList());
            checkedBlocks = GLOBAL_LOOT_CACHE.get(this.aiPlayer.func_110124_au());
        }
        int smallestDist = Integer.MAX_VALUE;
        TileEntityLootGenerator closest = null;
        for (TileEntity tileEntity : this.aiPlayer.field_70170_p.field_147482_g) {
            int distance;
            boolean flag;
            TileEntityLootGenerator lootSpawner;
            if (!(tileEntity instanceof TileEntityLootGenerator) || (lootSpawner = (TileEntityLootGenerator)tileEntity) == null || lootSpawner.func_174877_v() == null || (flag = checkedBlocks.contains(lootSpawner.func_174877_v())) || (distance = (int)PUBGMCUtil.getDistanceToBlockPos3D(this.aiPlayer.func_180425_c(), lootSpawner.func_174877_v())) >= smallestDist) continue;
            smallestDist = distance;
            closest = lootSpawner;
        }
        if (closest == null) {
            this.modifier = 0.0f;
            return null;
        }
        return closest.func_174877_v();
    }

    public boolean func_75250_a() {
        float f = this.aiPlayer.func_70681_au().nextFloat();
        if (f <= this.modifier) {
            BlockPos pos = this.findNearestUncheckedSpawner();
            if (pos == null) {
                return false;
            }
            this.pos = pos;
            return true;
        }
        this.pos = null;
        return false;
    }

    public boolean func_75253_b() {
        return !this.aiPlayer.func_70661_as().func_75500_f();
    }

    public void func_75249_e() {
        if (this.pos == null) {
            return;
        }
        this.aiPlayer.func_70661_as().func_75492_a((double)this.pos.func_177958_n(), (double)(this.pos.func_177956_o() + 1), (double)this.pos.func_177952_p(), 1.0);
    }

    public void func_75251_c() {
        if (PUBGMCUtil.getDistanceToBlockPos(this.aiPlayer.func_180425_c(), this.pos) > 10.0) {
            return;
        }
        TileEntity tileEntity = this.aiPlayer.field_70170_p.func_175625_s(this.pos);
        if (tileEntity instanceof TileEntityLootGenerator) {
            TileEntityLootGenerator lootSpawner = (TileEntityLootGenerator)tileEntity;
            int i = this.aiPlayer.lootFromLootSpawner(lootSpawner);
            this.modifier = i == 0 ? 0.0f : (i < 5 ? this.chance * 0.1f : (i >= 10 ? this.chance * 2.5f : this.modifier));
            GLOBAL_LOOT_CACHE.get(this.aiPlayer.func_110124_au()).add(this.pos);
            this.pos = null;
        }
    }
}

