/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.common.entity.throwables;

import com.toma.pubgmc.Pubgmc;
import com.toma.pubgmc.common.entity.throwables.EntityThrowableExplodeable;
import com.toma.pubgmc.util.PUBGMCUtil;
import com.toma.pubgmc.util.handlers.FlashHandler;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityFlashBang
extends EntityThrowableExplodeable {
    public EntityFlashBang(World world) {
        super(world);
    }

    public EntityFlashBang(World world, EntityLivingBase thrower, EntityThrowableExplodeable.EnumEntityThrowState state) {
        super(world, thrower, state);
    }

    public EntityFlashBang(World world, EntityLivingBase thrower, EntityThrowableExplodeable.EnumEntityThrowState state, int timeLeft) {
        super(world, thrower, state, timeLeft);
    }

    @Override
    public void onExplode() {
        if (this.field_70170_p.field_72995_K) {
            Pubgmc.proxy.playDelayedSound(SoundEvents.field_187539_bB, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f);
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
            for (int i = 0; i < 7; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.CLOUD, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z.nextDouble() / 8.0 - this.field_70146_Z.nextDouble() / 8.0, this.field_70146_Z.nextDouble() / 4.0, this.field_70146_Z.nextDouble() / 8.0 - this.field_70146_Z.nextDouble() / 8.0, new int[0]);
            }
        }
        List entityList = this.field_70170_p.func_72872_a(EntityPlayer.class, Block.field_185505_j.func_186670_a(this.func_180425_c()).func_186662_g(30.0));
        Vec3d start = PUBGMCUtil.getPositionVec(this);
        entityList.forEach(e -> {
            Vec3d entityVec = new Vec3d(e.field_70165_t, e.field_70163_u + (double)e.func_70047_e() + 0.25, e.field_70161_v);
            RayTraceResult rayTrace = this.rayTraceBlocks(start, entityVec, iBlockState -> iBlockState.func_177230_c().func_149662_c(iBlockState));
            if (rayTrace == null) {
                FlashHandler.flashPlayer(e, this);
            }
        });
        this.func_70106_y();
    }

    protected RayTraceResult rayTraceBlocks(Vec3d from, Vec3d to, Predicate<IBlockState> predicate) {
        RayTraceResult rayTraceResult;
        if (Double.isNaN(from.field_72450_a) || Double.isNaN(from.field_72448_b) || Double.isNaN(from.field_72449_c) || Double.isNaN(to.field_72450_a) || Double.isNaN(to.field_72448_b) || Double.isNaN(to.field_72449_c)) {
            return null;
        }
        BlockPos current = new BlockPos(from);
        IBlockState stateAtStart = this.field_70170_p.func_180495_p(current);
        if (stateAtStart.func_185890_d((IBlockAccess)this.field_70170_p, current) != Block.field_185506_k && stateAtStart.func_177230_c().func_176209_a(stateAtStart, false) && predicate.test(stateAtStart) && (rayTraceResult = stateAtStart.func_185910_a(this.field_70170_p, current, from, to)) != null) {
            return rayTraceResult;
        }
        int checks = this.getPartialChecksAmount(from, to);
        double x = (to.field_72450_a - from.field_72450_a) / (double)checks;
        double y = (to.field_72448_b - from.field_72448_b) / (double)checks;
        double z = (to.field_72449_c - from.field_72449_c) / (double)checks;
        for (int i = 1; i <= checks; ++i) {
            RayTraceResult rayTraceResult2;
            BlockPos pos = new BlockPos(from.field_72450_a + x * (double)i, from.field_72448_b + y * (double)i, from.field_72449_c + z * (double)i);
            IBlockState state = this.field_70170_p.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (!predicate.test(state) || state.func_185890_d((IBlockAccess)this.field_70170_p, pos) == Block.field_185506_k || !block.func_176209_a(state, false) || (rayTraceResult2 = state.func_185910_a(this.field_70170_p, pos, new Vec3d(from.field_72450_a + x, from.field_72448_b + y, from.field_72449_c + z), to)) == null) continue;
            return rayTraceResult2;
        }
        return null;
    }

    private int getPartialChecksAmount(Vec3d from, Vec3d to) {
        double distX = this.sqr(from.field_72450_a - to.field_72450_a);
        double distY = this.sqr(from.field_72448_b - to.field_72448_b);
        double distZ = this.sqr(from.field_72449_c - to.field_72449_c);
        double distance = Math.sqrt(distX + distY + distZ);
        return (int)Math.max(1.0, distance * 2.0);
    }

    private double sqr(double num) {
        return num * num;
    }
}

