/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.common.entity.throwables;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.toma.pubgmc.common.entity.throwables.EntityThrowableExplodeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class EntityMolotov
extends EntityThrowableExplodeable {
    public static final int FIRE_SPREAD_AMOUNT = 6;
    public static final int SPREAD_DELAY = 15;
    private MolotovFireSpreader fireSpreader = new MolotovFireSpreader();
    private List<MolotovFirePosEntry> burningBlocks;
    private int timesSpreaded;
    private int timeLeft = 200;
    private int startedSpreadingAt;
    private boolean hasStartedSpreading;

    public EntityMolotov(World world) {
        super(world);
    }

    public EntityMolotov(World world, EntityLivingBase thrower, EntityThrowableExplodeable.EnumEntityThrowState state) {
        super(world, thrower, state, Integer.MAX_VALUE);
    }

    @Override
    public void onThrowableTick() {
        this.func_82142_c(this.isFrozen);
        if (this.field_70170_p.field_72995_K && !this.isFrozen) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
        if (this.field_70170_p.func_180495_p(this.func_180425_c()).func_185904_a().func_76224_d()) {
            this.func_70106_y();
        }
        if (this.isFrozen) {
            if (this.hasStartedSpreading && (this.field_70173_aa - this.startedSpreadingAt) % 15 == 0 && this.timesSpreaded < 6) {
                ++this.timesSpreaded;
                this.fireSpreader.spread(this, this.burningBlocks);
            }
            if (this.burningBlocks != null && !this.burningBlocks.isEmpty()) {
                List entities = this.field_70170_p.func_175674_a((Entity)this, new AxisAlignedBB(this.field_70165_t - 6.0, this.field_70163_u - 6.0, this.field_70161_v - 6.0, this.field_70165_t + 6.0, this.field_70163_u + 6.0, this.field_70161_v + 6.0), Predicates.and((Predicate)EntitySelectors.field_94557_a, (Predicate)EntitySelectors.field_180132_d));
                block0: for (Entity e : entities) {
                    if (!(e instanceof EntityLivingBase)) continue;
                    for (MolotovFirePosEntry entry2 : this.burningBlocks) {
                        BlockPos p0 = new BlockPos((double)entry2.pos.func_177958_n(), (double)entry2.y, (double)entry2.pos.func_177952_p());
                        BlockPos p00 = new BlockPos(p0.func_177958_n(), p0.func_177956_o() + 1, p0.func_177952_p());
                        BlockPos p1 = e.func_180425_c();
                        if (!p0.equals((Object)p1) && !p00.equals((Object)p1)) continue;
                        e.func_70015_d(5);
                        if (this.field_70173_aa % 10 != 0) continue block0;
                        e.func_70097_a(DamageSource.field_76370_b, 4.0f);
                        continue block0;
                    }
                }
                if (this.field_70170_p.field_72995_K) {
                    this.burningBlocks.forEach(entry -> this.createMolotovParticles(this.field_70170_p, (MolotovFirePosEntry)entry, 2, 1));
                }
            }
            --this.timeLeft;
            if (this.timeLeft <= 0) {
                this.func_70106_y();
            }
        }
    }

    @Override
    public void onExplode() {
    }

    @Override
    public boolean canBounce() {
        return false;
    }

    public boolean func_189652_ae() {
        return super.func_189652_ae() || this.hasStartedSpreading;
    }

    @Override
    protected void onEntityFrozen() {
        this.burningBlocks = this.fireSpreader.startSpreading(this);
        this.hasStartedSpreading = true;
        this.startedSpreadingAt = this.field_70173_aa;
        this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187561_bM, SoundCategory.MASTER, 1.0f, 1.0f);
        super.onEntityFrozen();
    }

    protected void createMolotovParticles(World world, MolotovFirePosEntry entry, int amount, int spreadAmount) {
        BlockPos pos = entry.pos;
        for (int i = 0; i < amount; ++i) {
            world.func_175688_a(EnumParticleTypes.FLAME, (double)pos.func_177958_n() + this.smallDouble(spreadAmount), (double)entry.y, (double)pos.func_177952_p() + this.smallDouble(spreadAmount), this.smallDouble(20) - this.smallDouble(20), 0.01, this.smallDouble(20) - this.smallDouble(20), new int[0]);
        }
    }

    protected double smallDouble(int modifier) {
        return this.field_70146_Z.nextDouble() / (double)modifier;
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("ticksExisted", this.field_70173_aa);
        compound.func_74768_a("timeLeft", this.timeLeft);
        compound.func_74768_a("startedSpreadingAt", this.startedSpreadingAt);
        compound.func_74757_a("hasStarted", this.hasStartedSpreading);
        if (this.burningBlocks != null && !this.burningBlocks.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (MolotovFirePosEntry entry : this.burningBlocks) {
                list.func_74742_a((NBTBase)this.writeFireEntryToNBT(entry));
            }
            compound.func_74782_a("burningBlocks", (NBTBase)list);
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70173_aa = compound.func_74762_e("ticksExisted");
        this.timeLeft = compound.func_74762_e("timeLeft");
        this.startedSpreadingAt = compound.func_74762_e("startedSpreadingAt");
        this.hasStartedSpreading = compound.func_74767_n("hasStarted");
        this.fireSpreader = new MolotovFireSpreader();
        this.burningBlocks = new ArrayList<MolotovFirePosEntry>();
        if (compound.func_74764_b("burningBlocks")) {
            NBTTagList list = compound.func_150295_c("burningBlocks", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound nbt = list.func_150305_b(i);
                MolotovFirePosEntry entry = this.readEntryFromNBT(nbt);
                this.burningBlocks.add(entry);
            }
        }
    }

    protected NBTTagCompound writeFireEntryToNBT(MolotovFirePosEntry entry) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("pos", (NBTBase)NBTUtil.func_186859_a((BlockPos)entry.pos));
        nbt.func_74776_a("y", entry.y);
        return nbt;
    }

    protected MolotovFirePosEntry readEntryFromNBT(NBTTagCompound nbt) {
        BlockPos pos = NBTUtil.func_186861_c((NBTTagCompound)nbt.func_74775_l("pos"));
        float y = nbt.func_74760_g("y");
        return new MolotovFirePosEntry(pos, y);
    }

    protected class MolotovFirePosEntry {
        public BlockPos pos;
        public float y;

        public MolotovFirePosEntry(BlockPos pos) {
            this.pos = pos;
            this.y = (float)pos.func_177956_o() + 0.25f;
        }

        public MolotovFirePosEntry(BlockPos pos, AxisAlignedBB collisionBox) {
            this.pos = pos;
            this.y = (float)pos.func_177956_o() + (collisionBox != null ? (float)collisionBox.field_72337_e : 0.0f);
        }

        public MolotovFirePosEntry(BlockPos pos, float y) {
            this.pos = pos;
            this.y = y;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof MolotovFirePosEntry) {
                MolotovFirePosEntry entry = (MolotovFirePosEntry)obj;
                return this.pos.equals((Object)entry.pos) && this.y == entry.y;
            }
            return false;
        }
    }

    protected class MolotovFireSpreader {
        final EnumFacing[] FACINGS = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.SOUTH, EnumFacing.EAST};

        protected MolotovFireSpreader() {
        }

        public List<MolotovFirePosEntry> startSpreading(EntityMolotov molotov) {
            if (molotov.func_70090_H()) {
                molotov.func_70106_y();
                return Collections.emptyList();
            }
            ArrayList<MolotovFirePosEntry> list = new ArrayList<MolotovFirePosEntry>();
            BlockPos initial = molotov.func_180425_c();
            BlockPos ground = this.findGround(molotov.field_70170_p, initial);
            AxisAlignedBB alignedBB = molotov.field_70170_p.func_180495_p(ground).func_185890_d((IBlockAccess)molotov.field_70170_p, ground);
            if (molotov.field_70170_p.func_175623_d(ground.func_177984_a())) {
                list.add(new MolotovFirePosEntry(ground, alignedBB));
            }
            return list;
        }

        public void spread(EntityMolotov molotov, List<MolotovFirePosEntry> list) {
            if (list == null) {
                return;
            }
            ArrayList<MolotovFirePosEntry> toBeAdded = new ArrayList<MolotovFirePosEntry>();
            for (MolotovFirePosEntry entry2 : list) {
                for (EnumFacing facing : this.FACINGS) {
                    BlockPos pos = entry2.pos.func_177972_a(facing);
                    BlockPos ground = this.findGround(molotov.field_70170_p, pos);
                    Pair<Integer, BlockPos> pair = this.getFireStepHeight(molotov.field_70170_p, ground);
                    ground = (BlockPos)pair.getRight();
                    int stepHeight = (Integer)pair.getLeft();
                    if (stepHeight > 1) continue;
                    IBlockState state = molotov.field_70170_p.func_180495_p(ground);
                    AxisAlignedBB alignedBB = state.func_185890_d((IBlockAccess)molotov.field_70170_p, ground);
                    if (state.func_177230_c() == Blocks.field_150350_a || state.func_185904_a().func_76224_d()) continue;
                    MolotovFirePosEntry entry1 = new MolotovFirePosEntry(ground, alignedBB);
                    toBeAdded.add(entry1);
                }
            }
            toBeAdded.stream().filter(entry -> !list.contains(entry)).forEach(list::add);
        }

        public BlockPos findGround(World world, BlockPos pos) {
            BlockPos ground = pos;
            while (ground.func_177956_o() > 1 && world.func_175623_d(ground)) {
                ground = new BlockPos(ground.func_177958_n(), ground.func_177956_o() - 1, ground.func_177952_p());
            }
            return ground;
        }

        public Pair<Integer, BlockPos> getFireStepHeight(World world, BlockPos pos) {
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(pos);
            int stepHeight = 0;
            while (!world.func_175623_d(mutableBlockPos.func_177984_a()) && pos.func_177956_o() < 255) {
                ++stepHeight;
                mutableBlockPos.func_185336_p(mutableBlockPos.func_177956_o() + 1);
            }
            return Pair.of((Object)stepHeight, (Object)mutableBlockPos.func_185334_h());
        }
    }
}

