/*
 * Decompiled with CFR 0.152.
 */
package com.toma.pubgmc.common.entity.throwables;

import com.toma.pubgmc.common.entity.throwables.EntityThrowableExplodeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;

public class EntitySmokeGrenade
extends EntityThrowableExplodeable {
    public static final int SMOKE_EFFECT_DURATION = 400;
    public static final int SMOKE_ANGLE_PER_TICK = 90;
    private boolean startedSmoking;
    private int effectLeft = 400;
    private int currentAngle;
    private double smokeHeight = 0.0;

    public EntitySmokeGrenade(World world) {
        super(world);
    }

    public EntitySmokeGrenade(World world, EntityLivingBase thrower, EntityThrowableExplodeable.EnumEntityThrowState state) {
        super(world, thrower, state);
    }

    public EntitySmokeGrenade(World world, EntityLivingBase thrower, EntityThrowableExplodeable.EnumEntityThrowState state, int timeLeft) {
        super(world, thrower, state, timeLeft);
    }

    @Override
    public void onExplode() {
        this.startedSmoking = true;
    }

    public void createSmokeParticles() {
        if (this.field_70170_p.func_180495_p(this.func_180425_c()).func_185904_a().func_76224_d()) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.2, 0.0, new int[0]);
            return;
        }
        this.currentAngle += 90;
        if (this.field_70170_p.field_72995_K) {
            for (int i = 90; i > 0; i -= 5) {
                int updatedAngle = (this.currentAngle - i) % 360;
                double angle = Math.toRadians(updatedAngle);
                double x = Math.sin(angle) / 3.0;
                double z = Math.cos(angle) / 3.0;
                double y = 0.0;
                for (double d = 0.0; d < this.smokeHeight; d += 0.5) {
                    this.field_70170_p.func_175682_a(EnumParticleTypes.CLOUD, true, this.field_70165_t, this.field_70163_u + d, this.field_70161_v, x, y, z, new int[0]);
                }
            }
        }
    }

    @Override
    public void onThrowableTick() {
        if (this.startedSmoking) {
            if (this.smokeHeight < 3.5 && this.field_70173_aa % 5 == 0) {
                this.smokeHeight += 0.25;
            }
            this.createSmokeParticles();
            --this.effectLeft;
            if (this.effectLeft <= 0) {
                this.func_70106_y();
            }
        }
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("smoking", this.startedSmoking);
        compound.func_74768_a("left", this.effectLeft);
        compound.func_74768_a("angle", this.currentAngle);
        compound.func_74780_a("smokeHeight", this.smokeHeight);
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.startedSmoking = compound.func_74767_n("smoking");
        this.effectLeft = compound.func_74762_e("left");
        this.currentAngle = compound.func_74762_e("angle");
        this.smokeHeight = compound.func_74769_h("smokeHeight");
    }
}

